/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.Arrays;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.ExportAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ExportRecordsTests
extends BaseRMRestTest {
    private RecordCategory rootCategory;
    private RecordCategoryChild recordFolder;
    @Autowired
    private ExportAPI exportAPI;

    @BeforeClass(alwaysRun=true)
    public void exportRecordsTestsBeforeClass() {
        Step.STEP((String)"Create root level category");
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"Category"));
        Step.STEP((String)"Create the record folder inside the rootCategory");
        this.recordFolder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"Folder"));
    }

    @DataProvider(name="CreateRMNodes")
    public Object[][] getRMNodeID() {
        return new String[][]{{this.createRecord("Record_4MB", 4).getId()}, {this.createRecord("Record_200MB", 200).getId()}, {this.recordFolder.getId()}};
    }

    @Test(description="Testing the RM Export functionality for records of size >4MB and Record Folder containing records with size >4MB", dataProvider="CreateRMNodes")
    @AlfrescoTest(jira="APPS-986")
    public void exportRMNodeTest(String nodeID) {
        Step.STEP((String)"Export the created record/record folder with size greater than 4 MB and verifying the expected response code");
        this.exportAPI.exportRMNode(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 200, nodeID);
    }

    @Test(description="Testing the RM Export functionality using API for a list of Records at once with collective size of more than 4MB")
    public void exportRecordsTest() {
        Step.STEP((String)"Export all the created records at once and verifying the expected response code");
        this.exportAPI.exportRMNodes(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 200, Arrays.asList(this.createRecord("Record_2MB", 2).getId(), this.createRecord("Record_3MB", 3).getId()));
    }

    public Record createRecord(String recordName, int sizeInMegaBytes) {
        return this.getRestAPIFactory().getRecordFolderAPI().createRecord(Record.builder().name(recordName).nodeType("cm:content").build(), this.recordFolder.getId(), FilePlanComponentsUtil.createTempFile("TempFile", sizeInMegaBytes));
    }

    @AfterClass(alwaysRun=true)
    public void exportRecordsTestsAfter() {
        Step.STEP((String)"Delete the created rootCategory along with corresponding record folders/records present in it");
        this.getRestAPIFactory().getRecordCategoryAPI().deleteRecordCategory(this.rootCategory.getId());
    }
}

