/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMAuditAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RecordCategoryAuditLogTest
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RMAuditAPI auditLog;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(RecordCategoryAuditLogTest.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private static final String AUDIT_CATEGORY = CommonTestUtils.generateTestPrefix(RecordCategoryAuditLogTest.class) + "category";
    private RecordCategory recordCategoryAudit;

    @BeforeClass(alwaysRun=true)
    public void recordCategoryAuditLogSetup() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
    }

    @Test
    @AlfrescoTest(jira="RM-2768")
    public void recordCategoryAudit() throws Exception {
        Step.STEP((String)"Create root level category");
        this.recordCategoryAudit = this.createRootCategory(AUDIT_CATEGORY);
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Created Object Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Created Object")));
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @Test(dependsOnMethods={"recordCategoryAudit"}, description="Viewing audit log is itself an auditable event")
    @AlfrescoTest(jira="RM-4303")
    public void recordCategoryAuditIsEvent() {
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Audit View Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Audit View")));
    }

    @Test(dependsOnMethods={"recordCategoryAuditIsEvent"}, description="Record category rename is an edit metadata event")
    @AlfrescoTest(jira="RM-4303")
    public void renameRecordCategory() {
        String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
        RecordCategory rootRecordCategory = this.createRootCategory(categoryName);
        String newCategoryName = "Rename " + categoryName;
        RecordCategory recordCategoryUpdated = RecordCategory.builder().name(newCategoryName).build();
        RecordCategory renamedRecordCategory = this.getRestAPIFactory().getRecordCategoryAPI().updateRecordCategory(recordCategoryUpdated, rootRecordCategory.getId());
        this.assertStatusCode(HttpStatus.OK);
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @AfterClass(alwaysRun=true)
    private void electronicRecordAuditLogCleanup() {
        this.deleteRecordCategory(this.recordCategoryAudit.getId());
        this.dataUser.deleteUser(new UserModel(this.RM_ADMIN, this.getAdminUser().getPassword()));
        this.auditLog.clearAuditLog(this.getAdminUser().getUsername(), this.getAdminUser().getPassword());
    }
}

