/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.rest.core.v0.BaseAPI;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchAPI
extends BaseAPI {
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;
    private static final String FACETED_SEARCH_ENDPOINT = "{0}alfresco/s/slingshot/rmsearch/faceted/rmsearch?{1}";
    private static final String SHARE_LIVE_SEARCH_DOCS_ENDPOINT = "{0}alfresco/s/slingshot/live-search-docs?{1}";
    private static final String RM_SEARCH_ENDPOINT = "{0}alfresco/s/slingshot/rmsearch/{1}?{2}";
    private static final String RM_DEFAULT_NODES_FILTERS = "records/true,undeclared/true,vital/false,folders/{0},categories/{1},frozen/false,cutoff/false";

    private JSONObject doSearch(String searchEndpoint, String searchUser, String searchPassword) {
        return this.facetedRequest(searchUser, searchPassword, null, searchEndpoint);
    }

    public JSONObject rmSearch(String username, String password, String site, String query, String filters, String sortby) {
        ArrayList<BasicNameValuePair> searchParameters = new ArrayList<BasicNameValuePair>();
        searchParameters.add(new BasicNameValuePair("query", query));
        searchParameters.add(new BasicNameValuePair("filters", filters));
        if (sortby != null) {
            searchParameters.add(new BasicNameValuePair("sortby", sortby));
        }
        String requestURL = MessageFormat.format(RM_SEARCH_ENDPOINT, this.alfrescoHttpClientFactory.getObject().getAlfrescoUrl(), site != null ? site : "rm", URLEncodedUtils.format(searchParameters, (String)"UTF-8"));
        return this.doSearch(requestURL, username, password);
    }

    public List<String> searchForNodeNamesAsUser(String username, String password, String query, String sortby, boolean includeCategories, boolean includeFolders) {
        String searchFilterParamaters = MessageFormat.format(RM_DEFAULT_NODES_FILTERS, Boolean.toString(includeFolders), Boolean.toString(includeCategories));
        return this.getItemNames(this.rmSearch(username, password, "rm", query, searchFilterParamaters, sortby));
    }

    public String searchForNodePropertyAsUser(String username, String password, String nodeRef, String propertyName, String query, String sortby, boolean includeCategories, boolean includeFolders) {
        String searchFilterParamaters = MessageFormat.format(RM_DEFAULT_NODES_FILTERS, Boolean.toString(includeFolders), Boolean.toString(includeCategories));
        return this.getItemProperty(this.rmSearch(username, password, "rm", query, searchFilterParamaters, sortby), nodeRef, propertyName);
    }

    public JSONObject facetedSearch(String username, String password, List<NameValuePair> parameters) {
        return this.facetedRequest(username, password, parameters, FACETED_SEARCH_ENDPOINT);
    }

    public JSONObject liveSearchForDocuments(String searchUser, String searchPassword, String searchTerm) {
        return this.facetedRequest(searchUser, searchPassword, Arrays.asList(new BasicNameValuePair("t", searchTerm)), SHARE_LIVE_SEARCH_DOCS_ENDPOINT);
    }

    public JSONObject facetedSearchForTerm(String searchUser, String searchPassword, String searchTerm) {
        return this.facetedSearch(searchUser, searchPassword, Arrays.asList(new BasicNameValuePair("term", searchTerm)));
    }

    public List<String> searchForDocumentsAsUser(String username, String password, String term) {
        return this.getItemNames(this.facetedSearchForTerm(username, password, term));
    }

    public List<String> liveSearchForDocumentsAsUser(String username, String password, String term) throws JSONException {
        JSONObject searchResult = this.liveSearchForDocuments(username, password, term);
        LOGGER.info(searchResult.toString(3));
        return this.getItemNames(searchResult);
    }

    private List<String> getItemNames(JSONObject searchResult) {
        return this.getPropertyValues(searchResult, "name");
    }

    private String getItemProperty(JSONObject searchResult, String nodeRef, String propertyName) {
        return this.getPropertyValue(searchResult, nodeRef, propertyName);
    }
}

