/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.util.concurrent.atomic.AtomicReference;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.smoke.FileAsRecordTests;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileVersionAsRecordTests
extends BaseRMRestTest {
    private UserModel nonRMuser;
    private UserModel rmManager;
    private SiteModel testSite;
    private FileModel document;
    private FileModel documentDeclared;
    private RecordCategory category_manager;
    private RecordCategory category_admin;
    private RecordCategoryChild folder_admin;
    private RecordCategoryChild folder_manager;
    private static final String CATEGORY_MANAGER = "catManager" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String CATEGORY_ADMIN = "catAdmin" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String FOLDER_MANAGER = "recordFolder" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String FOLDER_ADMIN = "recordFolder" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    @Autowired
    private DataSite dataSite;
    @Autowired
    private DataContent dataContent;
    @Autowired
    private RoleService roleService;

    @BeforeClass(alwaysRun=true)
    public void preconditionForFileVersionAsRecordTests() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create a user");
        this.nonRMuser = this.dataUser.createRandomTestUser("testUser");
        Step.STEP((String)"Create a collaboration site");
        this.testSite = ((DataSite)this.dataSite.usingUser(this.nonRMuser)).createPublicRandomSite();
        Step.STEP((String)"Create a document with the user without RM role");
        this.document = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.nonRMuser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create two categories with two folders");
        this.category_manager = this.createRootCategory(CATEGORY_MANAGER);
        this.category_admin = this.createRootCategory(CATEGORY_ADMIN);
        this.folder_admin = this.createFolder(this.category_admin.getId(), FOLDER_ADMIN);
        this.folder_manager = this.createFolder(this.category_manager.getId(), FOLDER_MANAGER);
        Step.STEP((String)"Create an rm user and give filling permission over CATEGORY_MANAGER record category");
        new RecordCategory();
        RecordCategory recordCategory = RecordCategory.builder().id(this.category_manager.getId()).build();
        this.rmManager = this.roleService.createCollaboratorWithRMRoleAndPermission(this.testSite, recordCategory, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
    }

    @Test
    @AlfrescoTest(jira="APPS-1625")
    public void fileVersionAsRecordToUnfiledRecordContainer() throws Exception {
        AtomicReference apiChildren = new AtomicReference();
        Step.STEP((String)"Create a document with the user without RM role");
        FileModel inplaceRecord = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.rmManager).createContent(new FileModel("declareAndFileToIntoUnfiledRecordFolder", FileType.TEXT_PLAIN));
        Step.STEP((String)"Click on Declare and file without selecting a record folder");
        this.getRestAPIFactory().getActionsAPI(this.rmManager).declareAndFile((RepoTestModel)inplaceRecord, "");
        Step.STEP((String)"Check the file is declared in unfiled record folder");
        Assert.assertTrue((boolean)this.isMatchingRecordInUnfiledRecords(inplaceRecord), (String)"Record should be filed to Unfiled Records folder");
    }
}

