/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildCollection;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledRecordFolder;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.alfresco.rest.rm.community.util.UnfiledContainerChildMixin;
import org.springframework.http.HttpMethod;
import org.testng.Assert;

public class UnfiledRecordFolderAPI
extends RMModelRequest {
    public UnfiledRecordFolderAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public UnfiledRecordFolder getUnfiledRecordFolder(String unfiledRecordFolderId) {
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.getUnfiledRecordFolder(unfiledRecordFolderId, "");
    }

    public UnfiledRecordFolder getUnfiledRecordFolder(String unfiledRecordFolderId, String parameters) {
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.getRmRestWrapper().processModel(UnfiledRecordFolder.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"unfiled-record-folders/{unfiledRecordFolderId}?{parameters}", (String[])new String[]{unfiledRecordFolderId, parameters}));
    }

    public UnfiledContainerChildCollection getUnfiledRecordFolderChildren(String unfiledRecordFolderId) {
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.getUnfiledRecordFolderChildren(unfiledRecordFolderId, "");
    }

    public UnfiledContainerChildCollection getUnfiledRecordFolderChildren(String unfiledRecordFolderId, String parameters) {
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.getRmRestWrapper().processModels(UnfiledContainerChildCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"unfiled-record-folders/{unfiledRecordFolderId}/children?{parameters}", (String[])new String[]{unfiledRecordFolderId, parameters}));
    }

    public UnfiledContainerChild createUnfiledRecordFolderChild(UnfiledContainerChild unfiledRecordFolderChildModel, String unfiledRecordFolderId) {
        ParameterCheck.mandatoryObject("unfiledRecordFolderChildModel", (Object)unfiledRecordFolderChildModel);
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.createUnfiledRecordFolderChild(unfiledRecordFolderChildModel, unfiledRecordFolderId, "");
    }

    public UnfiledContainerChild createUnfiledRecordFolderChild(UnfiledContainerChild unfiledRecordFolderChildModel, String unfiledRecordFolderId, String parameters) {
        ParameterCheck.mandatoryObject("unfiledRecordFolderChildModel", (Object)unfiledRecordFolderChildModel);
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.getRmRestWrapper().processModel(UnfiledContainerChild.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)unfiledRecordFolderChildModel), (String)"unfiled-record-folders/{unfiledRecordFolderId}/children?{parameters}", (String[])new String[]{unfiledRecordFolderId, parameters}));
    }

    public UnfiledContainerChild uploadRecord(UnfiledContainerChild unfiledRecordFolderChildModel, String unfiledRecordFolderId, File unfiledRecordFolderChildContent) {
        JsonNode root;
        ParameterCheck.mandatoryObject("unfiledRecordFolderChildModel", (Object)unfiledRecordFolderChildModel);
        ParameterCheck.mandatoryObject("unfiledRecordFolderChildContent", unfiledRecordFolderChildContent);
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        if (!unfiledRecordFolderChildModel.getNodeType().equals("cm:content")) {
            Assert.fail((String)"Only electronic records are supported");
        }
        RequestSpecBuilder builder = this.getRmRestWrapper().configureRequestSpec();
        try {
            root = new ObjectMapper().readTree(PojoUtility.toJson((Object)unfiledRecordFolderChildModel, UnfiledContainerChild.class, UnfiledContainerChildMixin.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert model to JSON.", e);
        }
        Iterator fieldNames = root.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            builder.addMultiPart(fieldName, root.get(fieldName).asText(), ContentType.JSON.name());
        }
        builder.addMultiPart("filedata", unfiledRecordFolderChildContent, ContentType.BINARY.name());
        return this.createUnfiledRecordFolderChild(unfiledRecordFolderChildModel, unfiledRecordFolderId);
    }

    public UnfiledRecordFolder updateUnfiledRecordFolder(UnfiledRecordFolder unfiledRecordFolderModel, String unfiledRecordFolderId) {
        ParameterCheck.mandatoryObject("unfiledRecordFolderModel", (Object)unfiledRecordFolderModel);
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.updateUnfiledRecordFolder(unfiledRecordFolderModel, unfiledRecordFolderId, "");
    }

    public UnfiledRecordFolder updateUnfiledRecordFolder(UnfiledRecordFolder unfiledRecordFolderModel, String unfiledRecordFolderId, String parameters) {
        ParameterCheck.mandatoryObject("unfiledRecordFolderModel", (Object)unfiledRecordFolderModel);
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        return this.getRmRestWrapper().processModel(UnfiledRecordFolder.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)unfiledRecordFolderModel), (String)"unfiled-record-folders/{unfiledRecordFolderId}?{parameters}", (String[])new String[]{unfiledRecordFolderId, parameters}));
    }

    public void deleteUnfiledRecordFolder(String unfiledRecordFolderId) {
        ParameterCheck.mandatoryString("unfiledRecordFolderId", unfiledRecordFolderId);
        this.getRmRestWrapper().processEmptyModel(RestRequest.simpleRequest((HttpMethod)HttpMethod.DELETE, (String)"unfiled-record-folders/{recordFolderId}", (String[])new String[]{unfiledRecordFolderId}));
    }
}

