/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataGroup;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-5236")
public class AuditGroupEventsTests
extends BaseRMRestTest {
    @Autowired
    private RMAuditService rmAuditService;
    private GroupModel testGroup;
    private UserModel testUser;

    @BeforeClass(alwaysRun=true)
    public void cleanAuditLogs() {
        this.rmAuditService.clearAuditLog();
    }

    @Test
    public void createGroupEventIsAudited() {
        this.testGroup = this.dataGroup.createRandomGroup();
        Step.STEP((String)"Check the audit log contains the entry for the created group.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.CREATE_USER_GROUP, this.getAdminUser(), this.testGroup.getGroupIdentifier(), Collections.singletonList(ImmutableMap.of((Object)"new", (Object)this.testGroup.getGroupIdentifier(), (Object)"previous", (Object)"", (Object)"name", (Object)"authorityDisplayName")));
    }

    @Test
    public void addUserToGroupEventIsAudited() {
        this.testGroup = this.dataGroup.createRandomGroup();
        this.testUser = this.getDataUser().createRandomTestUser();
        ((DataGroup)this.dataGroup.usingUser(this.testUser)).addUserToGroup(this.testGroup);
        Step.STEP((String)"Check the audit log contains the entry for the add user to group event.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.ADD_TO_USER_GROUP, this.getAdminUser(), this.testGroup.getGroupIdentifier(), Arrays.asList(ImmutableMap.of((Object)"new", (Object)this.testUser.getUsername(), (Object)"previous", (Object)"", (Object)"name", (Object)"User Name"), ImmutableMap.of((Object)"new", (Object)this.testGroup.getGroupIdentifier(), (Object)"previous", (Object)"", (Object)"name", (Object)"Parent Group")));
    }

    @Test
    public void removeUserFromGroupEventIsAudited() {
        this.testGroup = this.dataGroup.createRandomGroup();
        this.testUser = this.getDataUser().createRandomTestUser();
        ((DataGroup)this.dataGroup.usingUser(this.testUser)).addUserToGroup(this.testGroup);
        this.dataGroup.removeUserFromGroup(this.testGroup, this.testUser);
        Step.STEP((String)"Check the audit log contains the entry for the remove user from group event.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.REMOVE_FROM_USER_GROUP, this.getAdminUser(), this.testGroup.getGroupIdentifier(), Arrays.asList(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.testUser.getUsername(), (Object)"name", (Object)"User Name"), ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.testGroup.getGroupIdentifier(), (Object)"name", (Object)"Parent Group")));
    }

    @Test
    public void deleteGroupEventIsAudited() {
        this.testGroup = this.dataGroup.createRandomGroup();
        this.dataGroup.deleteGroup(this.testGroup);
        Step.STEP((String)"Check the audit log contains the entry for the delete group event.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.DELETE_USER_GROUP, this.getAdminUser(), this.testGroup.getGroupIdentifier(), Collections.singletonList(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.testGroup.getGroupIdentifier(), (Object)"name", (Object)"authorityDisplayName")));
    }
}

