/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.io.IOException;
import java.text.MessageFormat;
import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.utility.model.UserModel;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NodePropertiesAPI
extends BaseAPI {
    private static final String GET_NODE_API = "{0}alfresco/s/slingshot/node/{1}";
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;

    protected JSONArray getNodeProperties(String username, String password, String nodeId) {
        String responseString;
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String requestURL = MessageFormat.format(GET_NODE_API, client.getAlfrescoUrl(), "workspace/SpacesStore/" + nodeId);
        HttpGet get = new HttpGet(requestURL);
        HttpResponse response = client.execute(username, password, (HttpRequestBase)get);
        HttpEntity entity = response.getEntity();
        try {
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read the response", e);
        }
        client.close();
        Object obj = JSONValue.parse((String)responseString);
        JSONObject jsonObject = (JSONObject)obj;
        return (JSONArray)jsonObject.get((Object)"properties");
    }

    public String getContentUrl(UserModel userModel, String nodeId) {
        String contentProperty = this.getContentProperty(userModel, nodeId);
        if (contentProperty != null) {
            contentProperty = contentProperty.split("\\|")[0];
            return contentProperty.replaceAll("contentUrl=", "");
        }
        return null;
    }

    public String getContentProperty(UserModel userModel, String nodeId) {
        JSONArray properties = this.getNodeProperties(userModel.getUsername(), userModel.getPassword(), nodeId);
        for (int i = 0; i < properties.size(); ++i) {
            JSONObject object = (JSONObject)properties.get(i);
            JSONArray valuesArray = (JSONArray)object.get((Object)"values");
            if (!valuesArray.toString().contains("contentUrl")) continue;
            return ((JSONObject)valuesArray.get(0)).get((Object)"value").toString();
        }
        return null;
    }
}

