/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateCategoriesTests
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    private RecordCategory rootCategory;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CreateCategoriesTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private RecordCategory Category1;
    private RecordCategory Category2;
    private RecordCategory SubCategory1;
    private RecordCategory SubCategory2;

    @BeforeClass(alwaysRun=true)
    public void preconditionForCreateCategoriesTests() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        Step.STEP((String)"Create two category");
        this.Category1 = this.createRootCategory(RandomData.getRandomName((String)"Category1"));
        this.Category2 = this.createRootCategory(RandomData.getRandomName((String)"Category2"));
        Step.STEP((String)"Create Sub category");
        RecordCategoryChild subCategory1 = this.createRecordCategory(this.Category1.getId(), RandomData.getRandomName((String)"subCategory1"));
        RecordCategoryChild subCategory2 = this.createRecordCategory(this.Category2.getId(), RandomData.getRandomName((String)"subCategory2"));
    }

    @Test
    @AlfrescoTest(jira="RM-2756")
    public void createCategories() throws Exception {
        FilePlan filePlan = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        Step.STEP((String)"copy category 1 to File Plan.");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(this.Category1.getId())).copy(CoreUtil.createBodyForMoveCopy(filePlan.getId()));
        Step.STEP((String)"copy category 1 to category 2");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(this.Category1.getId())).copy(CoreUtil.createBodyForMoveCopy(this.Category2.getId()));
        String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
        String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
        RecordCategory Category1 = this.createRootCategory(categoryName, categoryTitle);
        String newCategoryName = "Rename " + categoryName;
        RecordCategory recordCategoryUpdated = Category1.builder().name(newCategoryName).build();
        RecordCategory renamedRecordCategory = this.getRestAPIFactory().getRecordCategoryAPI().updateRecordCategory(recordCategoryUpdated, Category1.getId());
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)renamedRecordCategory.getParentId(), (String)filePlan.getId());
        Step.STEP((String)"move category 1 edited copy to File Plan");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(renamedRecordCategory.getId())).move(CoreUtil.createBodyForMoveCopy(filePlan.getId()));
        this.assertStatusCode(HttpStatus.OK);
        this.deleteRecordCategory(Category1.getId());
        this.deleteRecordCategory(this.Category2.getId());
    }
}

