/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.retentionschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.retentionschedule.RetentionSchedule;
import org.alfresco.rest.rm.community.model.retentionschedule.RetentionScheduleActionDefinition;
import org.alfresco.rest.rm.community.model.retentionschedule.RetentionScheduleStepCollection;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RetentionScheduleStepTests
extends BaseRMRestTest {
    private RecordCategory recordCategory;
    private RetentionSchedule createdRetentionSchedule;
    private final RetentionScheduleActionDefinition retentionScheduleActionDefinition = new RetentionScheduleActionDefinition();
    private RetentionScheduleActionDefinition createdRetentionActionDefinition;
    private UserModel nonRMuser;
    private final List<String> recordCategories = new ArrayList<String>();
    private static final String TEST_USER = "testUser";
    private static final String RECORD_CATEGORY = "recordCategory";
    private static final String PERIOD_PROPERTY = "cm:created";
    private static final String AUTHORITY = "authority";
    private static final String INSTRUCTIONS = "instructions";
    private static final int PERIOD_AMOUNT = 5;
    private static final String PERIOD = "month";
    private static final List<String> EVENTS = Arrays.asList("case_closed", "abolished");
    private static final String TRANSFER_STEP = "transfer";
    private static final String RETAIN_STEP = "retain";
    private static final String INVALID_PERIOD = "random";
    private static final String CUTOFF_STEP = "cutoff";
    private static final String DESTROY_STEP = "destroyContent";
    private static final String INVALID_PASSWORD = "wrongPassword";
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;

    @BeforeClass(alwaysRun=true)
    public void preconditionForRetentionScheduleStepTests() {
        this.createRMSiteIfNotExists();
        this.nonRMuser = this.dataUser.createRandomTestUser(TEST_USER);
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)RECORD_CATEGORY));
        this.recordCategories.add(this.recordCategory.getId());
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        retentionSchedule.setAuthority(AUTHORITY + RandomData.getRandomAlphanumeric());
        retentionSchedule.setInstructions(INSTRUCTIONS + RandomData.getRandomAlphanumeric());
        retentionSchedule.setIsRecordLevel(false);
        this.createdRetentionSchedule = this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionSchedule(retentionSchedule, this.recordCategory.getId());
        this.retentionScheduleActionDefinition.setName(RETAIN_STEP);
        this.retentionScheduleActionDefinition.setDescription(INSTRUCTIONS);
        this.retentionScheduleActionDefinition.setPeriodAmount(5);
        this.retentionScheduleActionDefinition.setPeriodProperty(PERIOD_PROPERTY);
        this.retentionScheduleActionDefinition.setPeriod(PERIOD);
        this.retentionScheduleActionDefinition.setCombineRetentionStepConditions(false);
        this.retentionScheduleActionDefinition.setEligibleOnFirstCompleteEvent(true);
        this.retentionScheduleActionDefinition.setEvents(EVENTS);
    }

    @Test(priority=1)
    public void createRetentionScheduleStepFor422() {
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(TRANSFER_STEP);
        actionDefinition.setLocation("location");
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(priority=2)
    public void createRetentionScheduleStepWithInvalidPeriodValue() {
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(RETAIN_STEP);
        actionDefinition.setPeriod(INVALID_PERIOD);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(priority=3)
    public void createRetentionScheduleWithInvalidStep() {
        RecordCategory recordCategory = this.createRootCategory(RandomData.getRandomName((String)RECORD_CATEGORY));
        this.recordCategories.add(recordCategory.getId());
        RetentionSchedule retentionSchedule = this.createRetentionSchedule(recordCategory);
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(RETAIN_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RetentionScheduleActionDefinition actionDefinition1 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition1.setName(TRANSFER_STEP);
        actionDefinition1.setLocation("location");
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition1, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RetentionScheduleActionDefinition actionDefinition2 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition2.setName(CUTOFF_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition2, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CONFLICT);
    }

    @Test(priority=4)
    public void createRetentionScheduleWithInvalidStepAfterDestroy() {
        RecordCategory recordCategory = this.createRootCategory(RandomData.getRandomName((String)RECORD_CATEGORY));
        this.recordCategories.add(recordCategory.getId());
        RetentionSchedule retentionSchedule = this.createRetentionSchedule(recordCategory);
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(RETAIN_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RetentionScheduleActionDefinition actionDefinition1 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition1.setName(DESTROY_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition1, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RetentionScheduleActionDefinition actionDefinition2 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition2.setName(CUTOFF_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition2, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CONFLICT);
    }

    @Test(priority=5)
    public void combineRetentionStepConditionsNotValidForNonAccessionStep() {
        RecordCategory recordCategory = this.createRootCategory(RandomData.getRandomName((String)RECORD_CATEGORY));
        this.recordCategories.add(recordCategory.getId());
        RetentionSchedule retentionSchedule = this.createRetentionSchedule(recordCategory);
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(RETAIN_STEP);
        actionDefinition.setCombineRetentionStepConditions(true);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(priority=6)
    public void createRetentionScheduleWithSameStep() {
        RecordCategory recordCategory = this.createRootCategory(RandomData.getRandomName((String)RECORD_CATEGORY));
        this.recordCategories.add(recordCategory.getId());
        RetentionSchedule retentionSchedule = this.createRetentionSchedule(recordCategory);
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(RETAIN_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RetentionScheduleActionDefinition actionDefinition1 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition1.setName(RETAIN_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition1, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CONFLICT);
    }

    @Test(priority=7)
    public void createRetentionScheduleWithMultipleTransferStep() {
        RecordCategory recordCategory = this.createRootCategory(RandomData.getRandomName((String)RECORD_CATEGORY));
        this.recordCategories.add(recordCategory.getId());
        RetentionSchedule retentionSchedule = this.createRetentionSchedule(recordCategory);
        RetentionScheduleActionDefinition actionDefinition = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition.setName(RETAIN_STEP);
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RetentionScheduleActionDefinition actionDefinition1 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition1.setName(TRANSFER_STEP);
        actionDefinition1.setLocation("location");
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition1, retentionSchedule.getId());
        RetentionScheduleActionDefinition actionDefinition2 = RetentionScheduleStepTests.getRetentionScheduleActionDefinition();
        actionDefinition2.setName(TRANSFER_STEP);
        actionDefinition2.setLocation("location");
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(actionDefinition2, retentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
    }

    @Test(priority=8)
    public void createRetentionScheduleStepFor201() {
        this.createdRetentionActionDefinition = this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(this.retentionScheduleActionDefinition, this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        AssertJUnit.assertEquals((String)this.createdRetentionActionDefinition.getName(), (String)this.retentionScheduleActionDefinition.getName());
        AssertJUnit.assertEquals((String)this.createdRetentionActionDefinition.getDescription(), (String)this.retentionScheduleActionDefinition.getDescription());
        AssertJUnit.assertEquals((int)this.createdRetentionActionDefinition.getPeriodAmount(), (int)this.retentionScheduleActionDefinition.getPeriodAmount());
        AssertJUnit.assertEquals((boolean)this.createdRetentionActionDefinition.isCombineRetentionStepConditions(), (boolean)this.retentionScheduleActionDefinition.isCombineRetentionStepConditions());
        AssertJUnit.assertEquals((boolean)this.createdRetentionActionDefinition.isEligibleOnFirstCompleteEvent(), (boolean)this.retentionScheduleActionDefinition.isEligibleOnFirstCompleteEvent());
    }

    @Test(priority=9)
    public void createRetentionScheduleStepFor401() {
        this.getRestAPIFactory().getRetentionScheduleAPI(new UserModel(this.getAdminUser().getUsername(), INVALID_PASSWORD)).createRetentionScheduleStep(this.retentionScheduleActionDefinition, this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.UNAUTHORIZED);
    }

    @Test(priority=10)
    public void createRetentionScheduleStepFor403() {
        this.getRestAPIFactory().getRetentionScheduleAPI(this.nonRMuser).createRetentionScheduleStep(this.retentionScheduleActionDefinition, this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test(priority=11)
    public void retentionScheduleStepFor400() {
        this.getRestAPIFactory().getRetentionScheduleAPI().getRetentionScheduleStep(this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(priority=12)
    public void createRetentionScheduleStepFor404() {
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionScheduleStep(this.retentionScheduleActionDefinition, RandomData.getRandomAlphanumeric());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test(priority=13)
    public void retentionScheduleStepFor403() {
        this.getRestAPIFactory().getRetentionScheduleAPI(this.nonRMuser).getRetentionScheduleStep(this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test(priority=14)
    public void retentionScheduleStepFor401() {
        this.getRestAPIFactory().getRetentionScheduleAPI(new UserModel(this.getAdminUser().getUsername(), INVALID_PASSWORD)).getRetentionScheduleStep(this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.UNAUTHORIZED);
    }

    @Test(priority=15)
    public void retentionScheduleStepWith200() {
        RetentionScheduleStepCollection receiveRetentionStepCollection = this.getRestAPIFactory().getRetentionScheduleAPI().getRetentionScheduleStep(this.createdRetentionSchedule.getId());
        this.assertStatusCode(HttpStatus.OK);
        receiveRetentionStepCollection.getEntries().forEach(c -> {
            RetentionScheduleActionDefinition retentionActionDef = c.getEntry();
            Assert.assertNotNull((Object)retentionActionDef.getId());
            AssertJUnit.assertEquals((String)this.createdRetentionActionDefinition.getId(), (String)retentionActionDef.getId());
            AssertJUnit.assertEquals((String)this.createdRetentionActionDefinition.getName(), (String)retentionActionDef.getName());
            AssertJUnit.assertEquals((String)this.createdRetentionActionDefinition.getDescription(), (String)retentionActionDef.getDescription());
            AssertJUnit.assertEquals((String)this.createdRetentionActionDefinition.getPeriod(), (String)retentionActionDef.getPeriod());
            AssertJUnit.assertEquals((int)this.createdRetentionActionDefinition.getPeriodAmount(), (int)retentionActionDef.getPeriodAmount());
            AssertJUnit.assertEquals((boolean)this.createdRetentionActionDefinition.isCombineRetentionStepConditions(), (boolean)retentionActionDef.isCombineRetentionStepConditions());
            AssertJUnit.assertEquals((boolean)this.createdRetentionActionDefinition.isEligibleOnFirstCompleteEvent(), (boolean)retentionActionDef.isEligibleOnFirstCompleteEvent());
        });
    }

    private RetentionSchedule createRetentionSchedule(RecordCategory recordCategory) {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        retentionSchedule.setAuthority(AUTHORITY + RandomData.getRandomAlphanumeric());
        retentionSchedule.setInstructions(INSTRUCTIONS + RandomData.getRandomAlphanumeric());
        retentionSchedule.setIsRecordLevel(false);
        retentionSchedule = this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionSchedule(retentionSchedule, recordCategory.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        return retentionSchedule;
    }

    private static RetentionScheduleActionDefinition getRetentionScheduleActionDefinition() {
        RetentionScheduleActionDefinition actionDefinition = new RetentionScheduleActionDefinition();
        actionDefinition.setDescription(INSTRUCTIONS);
        actionDefinition.setPeriodAmount(5);
        actionDefinition.setPeriodProperty(PERIOD_PROPERTY);
        actionDefinition.setPeriod(PERIOD);
        actionDefinition.setCombineRetentionStepConditions(false);
        actionDefinition.setEligibleOnFirstCompleteEvent(true);
        actionDefinition.setEvents(EVENTS);
        return actionDefinition;
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpRetentionScheduleStepTests() {
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.recordCategory.getName());
        this.recordCategories.forEach(this::deleteRecordCategory);
        this.dataUser.deleteUser(this.nonRMuser);
    }
}

