/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.custom.CustomDefinitions;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.CustomDefinitionsAPI;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordCategoriesAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

public class AddRelationshipTests
extends BaseRMRestTest {
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(AddRelationshipTests.class);
    private final String CATEGORY = this.TEST_PREFIX + "category";
    private final String HOLD1 = this.TEST_PREFIX + "hold1";
    private final String FOLDER = this.TEST_PREFIX + "RM_2709_1814_FOLDER";
    private final String RECORD1 = this.TEST_PREFIX + "RM_2709_1814_RECORD_ONE";
    private final String RECORD2 = this.TEST_PREFIX + "RM_1814_RECORD_TWO";
    private String hold1NodeRef;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private CustomDefinitionsAPI customDefinitionsAPI;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordCategoriesAPI recordCategoriesAPI;

    @Test(priority=1)
    @AlfrescoTest(jira="RM-1814")
    public void addRelationshipToHoldRecord() {
        String CATEGORY_RELATIONSHIP = this.CATEGORY + "To Hold";
        this.createRMSiteIfNotExists();
        RecordCategory recordCategory = this.createCategoryIfDoesNotExist(CATEGORY_RELATIONSHIP);
        RecordCategoryChild recordCategoryChild = this.createRecordFolderInCategory(this.FOLDER, recordCategory);
        this.createRecordItems(recordCategoryChild, this.RECORD1);
        Record record2 = this.createRecordItems(recordCategoryChild, this.RECORD2);
        this.hold1NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD1, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsAPI.addItemsToHolds(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), 200, Collections.singletonList(record2.getId()), Collections.singletonList(this.hold1NodeRef));
        String elRecordFullName1 = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.FOLDER, this.RECORD1);
        String elRecordNodeRef1 = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName1, "/" + CATEGORY_RELATIONSHIP + "/" + this.FOLDER);
        String elRecordFullName2 = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.FOLDER, this.RECORD2);
        String elRecordNodeRef2 = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName2, "/" + CATEGORY_RELATIONSHIP + "/" + this.FOLDER);
        this.customDefinitionsAPI.createRelationship(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), 500, this.formatNodeRef(elRecordNodeRef1), this.formatNodeRef(elRecordNodeRef2), CustomDefinitions.ATTACHMENT);
        this.deletePrecondition();
    }

    @Test(priority=2)
    @AlfrescoTest(jira="RM-1874")
    public void deleteRelationship() {
        String CATEGORY_RELATIONSHIP = this.CATEGORY + "deleteRelationship";
        this.createRMSiteIfNotExists();
        RecordCategory recordCategory = this.createCategoryIfDoesNotExist(CATEGORY_RELATIONSHIP);
        RecordCategoryChild recordCategoryChild = this.createRecordFolderInCategory(this.FOLDER, recordCategory);
        this.createRecordItems(recordCategoryChild, this.RECORD1);
        this.createRecordItems(recordCategoryChild, this.RECORD2);
        String elRecordFullName1 = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.FOLDER, this.RECORD1);
        String elRecordNodeRef1 = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName1, "/" + CATEGORY_RELATIONSHIP + "/" + this.FOLDER);
        String elRecordFullName2 = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.FOLDER, this.RECORD2);
        String elRecordNodeRef2 = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName2, "/" + CATEGORY_RELATIONSHIP + "/" + this.FOLDER);
        this.customDefinitionsAPI.createRelationship(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.formatNodeRef(elRecordNodeRef1), this.formatNodeRef(elRecordNodeRef2), CustomDefinitions.ATTACHMENT);
        JSONObject relationshipDetails = this.customDefinitionsAPI.getRelationshipDetails(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.formatNodeRef(elRecordNodeRef1));
        this.customDefinitionsAPI.deleteRelationship(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.formatNodeRef(elRecordNodeRef1), this.formatNodeRef(elRecordNodeRef2), this.relationshipUniqueName(relationshipDetails));
        this.tearDown(CATEGORY_RELATIONSHIP);
    }

    private void deletePrecondition() {
        this.holdsAPI.deleteHold(this.getAdminUser(), this.hold1NodeRef);
    }

    private Record createRecordItems(RecordCategoryChild recordCategoryChild, String record) {
        return this.createElectronicRecord(recordCategoryChild.getId(), record);
    }

    private RecordCategory createCategoryIfDoesNotExist(String CATEGORY_ALL) {
        return this.createRootCategory(((DataUser)this.getDataUser().usingAdmin()).getAdminUser(), CATEGORY_ALL);
    }

    private RecordCategoryChild createRecordFolderInCategory(String FOLDER_SEARCH, RecordCategory recordCategory) {
        return this.createFolder(((DataUser)this.getDataUser().usingAdmin()).getAdminUser(), recordCategory.getId(), FOLDER_SEARCH);
    }

    private String formatNodeRef(String nodeRef) {
        return StringUtils.remove((String)nodeRef, (String)"workspace://SpacesStore/");
    }

    private void tearDown(String category) {
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.FOLDER);
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", category);
        this.recordCategoriesAPI.deleteCategory(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), category);
    }

    private String relationshipUniqueName(JSONObject relationshipDetails) {
        return relationshipDetails.getJSONObject("data").getJSONArray("items").getJSONObject(0).getJSONObject("node").get("relationshipUniqueName").toString();
    }
}

