/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldDeletionReason;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6859")
public class AuditDeleteHoldTests
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditDeleteHoldTests.class);
    private final String hold = this.PREFIX + "holdToBeDeleted";
    private final String hold2 = this.PREFIX + "deleteHold";
    private final String hold3 = this.PREFIX + "deleteHoldWithReason";
    @Autowired
    private RMAuditService rmAuditService;
    @Autowired
    private RoleService roleService;
    private UserModel rmAdmin;
    private UserModel rmManager;
    private String holdNodeRef;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAuditDeleteHoldTests() {
        Step.STEP((String)"Create a new hold.");
        this.holdNodeRef = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createHold(Hold.builder().name(this.hold).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-").getId();
        Step.STEP((String)"Create 2 users with different permissions for the created hold.");
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        this.rmManager = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_MANAGER.roleId);
    }

    @Test
    public void deleteHoldEventIsAudited() {
        Step.STEP((String)"Create a new hold.");
        String holdRef = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createHold(Hold.builder().name(this.hold2).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-").getId();
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Delete the created hold.");
        this.getRestAPIFactory().getHoldsAPI(this.rmAdmin).deleteHold(holdRef);
        Step.STEP((String)"Check the audit log contains the entry for the deleted hold with the hold details.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.DELETE_HOLD, this.rmAdmin, this.hold2, List.of(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.hold2, (Object)"name", (Object)"Hold Name"), ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)"", (Object)"name", (Object)"Hold deletion reason")));
    }

    @Test
    public void deleteHoldWithReasonEventIsAudited() {
        Step.STEP((String)"Create a new hold.");
        String holdRef = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createHold(Hold.builder().name(this.hold3).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), "-filePlan-").getId();
        String deletionReason = "Test reason";
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Delete the created hold with a reason.");
        this.getRestAPIFactory().getHoldsAPI(this.rmAdmin).deleteHoldWithReason(HoldDeletionReason.builder().reason(deletionReason).build(), holdRef);
        Step.STEP((String)"Check the audit log contains the entry for the deleted hold with the hold details.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.DELETE_HOLD, this.rmAdmin, this.hold3, List.of(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.hold3, (Object)"name", (Object)"Hold Name"), ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)deletionReason, (Object)"name", (Object)"Hold deletion reason")));
    }

    @Test
    public void unsuccessfulDeleteHoldIsNotAudited() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Try to delete a hold by an user with no Read permissions over the hold.");
        this.getRestAPIFactory().getHoldsAPI(this.rmManager).deleteHold(this.holdNodeRef);
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        Step.STEP((String)"Check the audit log doesn't contain the entry for the unsuccessful delete hold.");
        AssertJUnit.assertTrue((String)"The list of events should not contain Delete Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.DELETE_HOLD).isEmpty());
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpAuditDeleteHoldTests() {
        this.getRestAPIFactory().getHoldsAPI(this.rmManager).deleteHold(this.holdNodeRef);
        Arrays.asList(this.rmAdmin, this.rmManager).forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
    }
}

