/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.fileplans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.DataProviderClass;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.fileplan.FilePlanProperties;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldCollection;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryCollection;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryProperties;
import org.alfresco.rest.rm.community.model.site.RMSite;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.RMSiteAPI;
import org.alfresco.rest.rm.community.utils.RMSiteUtil;
import org.alfresco.utility.constants.ContainerName;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FilePlanTests
extends BaseRMRestTest {
    private static final int NUMBER_OF_CHILDREN = 10;

    @DataProvider
    public static Object[][] childrenNotAllowedForFilePlan() {
        return new String[][]{{"rma:filePlan"}, {"rma:transferContainer"}, {"rma:unfiledRecordContainer"}, {"rma:unfiledRecordFolder"}, {"rma:transfer"}, {"cm:content"}, {"rma:nonElectronicDocument"}, {"rma:recordFolder"}};
    }

    @DataProvider(name="rmSiteModels")
    public static Object[][] rmSiteModels() {
        return new Object[][]{{"ddod", RMSiteUtil.createDOD5015RMSiteModel()}, {"standard", RMSiteUtil.createStandardRMSiteModel()}};
    }

    @Test(priority=1)
    public void getFilePlanWhenRMIsNotCreated() {
        RMSiteAPI rmSiteAPI = this.getRestAPIFactory().getRMSiteAPI();
        if (rmSiteAPI.existsRMSite()) {
            rmSiteAPI.deleteRMSite();
        }
        this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test
    public void getFilePlanWhenRMIsCreated() {
        this.createRMSiteIfNotExists();
        FilePlan filePlan = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        this.assertStatusCode(HttpStatus.OK);
        AssertJUnit.assertEquals((String)"rma:filePlan", (String)filePlan.getNodeType());
        AssertJUnit.assertEquals((String)ContainerName.documentLibrary.toString(), (String)filePlan.getName());
    }

    @Test
    public void includeAllowableOperations() {
        FilePlan filePlan = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-", "include=allowableOperations");
        Assert.assertTrue((boolean)filePlan.getAllowableOperations().containsAll(Arrays.asList("update", "create")), (String)("Wrong list of the allowable operations is return" + filePlan.getAllowableOperations().toString()));
        Assert.assertFalse((boolean)filePlan.getAllowableOperations().contains("delete"), (String)("The list of allowable operations contains delete option" + filePlan.getAllowableOperations().toString()));
    }

    @Test
    public void getFilePlanWithNonRMuser() {
        UserModel nonRMuser = this.getDataUser().createRandomTestUser("testUser");
        this.getRestAPIFactory().getFilePlansAPI(nonRMuser).getFilePlan("-filePlan-");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test
    @Bug(id="RM-4295")
    public void updateFilePlan() {
        String FILE_PLAN_DESCRIPTION = "Description updated " + RandomData.getRandomAlphanumeric();
        String FILE_PLAN_TITLE = "Title updated " + RandomData.getRandomAlphanumeric();
        FilePlan filePlanComponent = FilePlan.builder().properties(FilePlanProperties.builder().title(FILE_PLAN_TITLE).description(FILE_PLAN_DESCRIPTION).build()).build();
        UserModel nonRMuser = this.getDataUser().createRandomTestUser("testUser");
        this.getRestAPIFactory().getFilePlansAPI(nonRMuser).updateFilePlan(filePlanComponent, "-filePlan-");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        FilePlan renamedFilePlan = this.getRestAPIFactory().getFilePlansAPI().updateFilePlan(filePlanComponent, "-filePlan-");
        this.assertStatusCode(HttpStatus.OK);
        AssertJUnit.assertEquals((String)FILE_PLAN_DESCRIPTION, (String)renamedFilePlan.getProperties().getDescription());
        AssertJUnit.assertEquals((String)FILE_PLAN_TITLE, (String)renamedFilePlan.getProperties().getTitle());
    }

    @Test
    @Bug(id="RM-4295")
    public void updateFilePlanName() {
        FilePlan filePlanComponent = FilePlan.builder().name(RandomData.getRandomName((String)"File Plan name updated ")).build();
        this.getRestAPIFactory().getFilePlansAPI().updateFilePlan(filePlanComponent, "-filePlan-");
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Create root category", dataProviderClass=DataProviderClass.class, dataProvider="categoryTypes")
    public void createFilePlanChildren(String nodeType) {
        String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
        String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
        RecordCategory recordCategory = RecordCategory.builder().name(categoryName).properties(RecordCategoryProperties.builder().title(categoryTitle).build()).nodeType(nodeType).build();
        RecordCategory rootRecordCategory = this.getRestAPIFactory().getFilePlansAPI().createRootRecordCategory(recordCategory, "-filePlan-");
        this.assertStatusCode(HttpStatus.CREATED);
        AssertJUnit.assertEquals((String)rootRecordCategory.getName(), (String)categoryName);
        AssertJUnit.assertEquals((String)rootRecordCategory.getNodeType(), (String)"rma:recordCategory");
        AssertJUnit.assertEquals((String)rootRecordCategory.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
        RecordCategoryProperties rootRecordCategoryProperties = rootRecordCategory.getProperties();
        AssertJUnit.assertEquals((String)rootRecordCategoryProperties.getTitle(), (String)categoryTitle);
        Assert.assertNotNull((Object)rootRecordCategoryProperties.getIdentifier());
    }

    @Test
    @Bug(id="RM-5116")
    public void createDuplicateCategories() {
        String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
        String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
        RecordCategory recordCategory = RecordCategory.builder().name(categoryName).properties(RecordCategoryProperties.builder().title(categoryTitle).build()).build();
        RecordCategory rootRecordCategory = this.getRestAPIFactory().getFilePlansAPI().createRootRecordCategory(recordCategory, "-filePlan-");
        this.assertStatusCode(HttpStatus.CREATED);
        AssertJUnit.assertEquals((String)rootRecordCategory.getName(), (String)categoryName);
        this.getRestAPIFactory().getFilePlansAPI().createRootRecordCategory(recordCategory, "-filePlan-");
        this.assertStatusCode(HttpStatus.CONFLICT);
        RecordCategory rootRecordCategoryAutoRename = this.getRestAPIFactory().getFilePlansAPI().createRootRecordCategory(recordCategory, "-filePlan-", "autoRename=true");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertNotEquals((Object)rootRecordCategoryAutoRename.getName(), (Object)categoryName);
        Assert.assertTrue((boolean)rootRecordCategoryAutoRename.getName().startsWith(categoryName));
    }

    @Test
    public void listFilePlanChildren() {
        this.getRestAPIFactory().getFilePlansAPI().getRootRecordCategories("-filePlan-").getEntries().forEach(recordCategoryEntry -> this.deleteRecordCategory(recordCategoryEntry.getEntry().getId()));
        ArrayList<RecordCategory> children = new ArrayList<RecordCategory>();
        for (int i = 0; i < 10; ++i) {
            String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
            String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
            RecordCategory recordCategory = this.createRootCategory(categoryName, categoryTitle);
            Assert.assertNotNull((Object)recordCategory.getId());
            children.add(recordCategory);
        }
        RecordCategoryCollection recordCategoryChildren = this.getRestAPIFactory().getFilePlansAPI().getRootRecordCategories("-filePlan-", "include=aspects,properties");
        this.assertStatusCode(HttpStatus.OK);
        recordCategoryChildren.getEntries().forEach(c -> {
            RecordCategory recordCategoryChild = c.getEntry();
            String recordCategoryChildId = recordCategoryChild.getId();
            Assert.assertNotNull((Object)recordCategoryChildId);
            this.logger.info((Object)("Checking child " + recordCategoryChildId));
            try {
                RecordCategory createdComponent = children.stream().filter(child -> child.getId().equals(recordCategoryChildId)).findFirst().orElseThrow();
                AssertJUnit.assertEquals((String)recordCategoryChild.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
                AssertJUnit.assertEquals((String)createdComponent.getName(), (String)recordCategoryChild.getName());
                AssertJUnit.assertEquals((String)createdComponent.getNodeType(), (String)recordCategoryChild.getNodeType());
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + recordCategoryChildId));
            }
        });
    }

    @Test(description="Create a record folder/unfiled container/unfiled folder/record/file plan container", dataProvider="childrenNotAllowedForFilePlan")
    public void createChildrenNotAllowedInFilePlan(String nodeType) {
        String componentName = "Component" + RandomData.getRandomAlphanumeric();
        RecordCategory component = RecordCategory.builder().name(componentName).nodeType(nodeType).build();
        RecordCategory rootRecordCategory = this.getRestAPIFactory().getFilePlansAPI().createRootRecordCategory(component, "-filePlan-");
        this.assertStatusCode(HttpStatus.CREATED);
        AssertJUnit.assertEquals((String)rootRecordCategory.getName(), (String)componentName);
        AssertJUnit.assertEquals((String)rootRecordCategory.getNodeType(), (String)"rma:recordCategory");
        AssertJUnit.assertEquals((String)rootRecordCategory.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
        Assert.assertNotNull((Object)rootRecordCategory.getProperties().getIdentifier());
    }

    @Test
    public void listChildrenUserPermission() {
        UserModel managerUser = this.getDataUser().createRandomTestUser("managerUser");
        ArrayList<RecordCategory> children = new ArrayList<RecordCategory>();
        for (int i = 0; i < 5; ++i) {
            String categoryName = "Category name " + RandomData.getRandomAlphanumeric();
            String categoryTitle = "Category title " + RandomData.getRandomAlphanumeric();
            RecordCategory recordCategory = this.createRootCategory(categoryName, categoryTitle);
            Assert.assertNotNull((Object)recordCategory.getId());
            children.add(recordCategory);
        }
        this.getRestAPIFactory().getRMUserAPI().assignRoleToUser(managerUser.getUsername(), UserRoles.ROLE_RM_MANAGER.roleId);
        ((RestModels)this.getRestAPIFactory().getFilePlansAPI(managerUser).getRootRecordCategories("-filePlan-").assertThat().entriesListIsEmpty()).assertThat().paginationExist();
        ArrayList<RecordCategory> childrenManager = new ArrayList<RecordCategory>();
        for (int i = 0; i < 5; ++i) {
            String categoryName = "Category for manager " + RandomData.getRandomAlphanumeric();
            String categoryTitle = "Category for manager " + RandomData.getRandomAlphanumeric();
            RecordCategory recordCategory = this.createRootCategory(categoryName, categoryTitle);
            Assert.assertNotNull((Object)recordCategory.getId());
            this.getRestAPIFactory().getRMUserAPI().addUserPermission(recordCategory.getId(), managerUser, UserPermissions.PERMISSION_FILING);
            childrenManager.add(recordCategory);
        }
        RecordCategoryCollection recordCategoryChildren = this.getRestAPIFactory().getFilePlansAPI(managerUser).getRootRecordCategories("-filePlan-");
        recordCategoryChildren.getEntries().forEach(c -> {
            RecordCategory recordCategoryChild = c.getEntry();
            String recordCategoryChildId = recordCategoryChild.getId();
            Assert.assertNotNull((Object)recordCategoryChildId);
            this.logger.info((Object)("Checking child " + recordCategoryChildId));
            try {
                Assert.assertTrue((boolean)childrenManager.stream().anyMatch(child -> child.getId().equals(recordCategoryChildId)));
                Assert.assertFalse((boolean)children.stream().anyMatch(child -> child.getId().equals(recordCategoryChildId)));
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + recordCategoryChildId));
            }
        });
    }

    @Test(dataProvider="rmSiteModels")
    public void createHoldForRMSiteModel(String siteType, Object rmSiteModel) {
        this.createRMSite((RMSite)rmSiteModel);
        String holdName = "Hold" + RandomData.getRandomAlphanumeric();
        String holdDescription = "Description" + RandomData.getRandomAlphanumeric();
        String holdReason = "Reason" + RandomData.getRandomAlphanumeric();
        Hold hold = Hold.builder().name(holdName).description(holdDescription).reason(holdReason).build();
        Hold createdHold = this.getRestAPIFactory().getFilePlansAPI().createHold(hold, "-filePlan-");
        this.assertStatusCode(HttpStatus.CREATED);
        AssertJUnit.assertEquals((String)createdHold.getName(), (String)holdName);
        AssertJUnit.assertEquals((String)createdHold.getDescription(), (String)holdDescription);
        AssertJUnit.assertEquals((String)createdHold.getReason(), (String)holdReason);
        Assert.assertNotNull((Object)createdHold.getId());
    }

    @Test(dataProvider="rmSiteModels")
    public void listHolds(String siteType, Object rmSiteModel) {
        this.createRMSite((RMSite)rmSiteModel);
        this.getRestAPIFactory().getFilePlansAPI().getHolds("-filePlan-").getEntries().forEach(holdEntry -> this.getRestAPIFactory().getHoldsAPI().deleteHold(holdEntry.getEntry().getId()));
        ArrayList<Hold> filePlanHolds = new ArrayList<Hold>();
        for (int i = 0; i < 10; ++i) {
            String holdName = "Hold name " + RandomData.getRandomAlphanumeric();
            String holdDescription = "Hold Description " + RandomData.getRandomAlphanumeric();
            String holdReason = "Reason " + RandomData.getRandomAlphanumeric();
            Hold hold = Hold.builder().name(holdName).description(holdDescription).reason(holdReason).build();
            Hold createdHold = this.getRestAPIFactory().getFilePlansAPI().createHold(hold, "-filePlan-");
            Assert.assertNotNull((Object)createdHold.getId());
            filePlanHolds.add(createdHold);
        }
        HoldCollection holdCollection = this.getRestAPIFactory().getFilePlansAPI().getHolds("-filePlan-");
        this.assertStatusCode(HttpStatus.OK);
        holdCollection.getEntries().forEach(c -> {
            Hold hold = c.getEntry();
            String holdId = hold.getId();
            Assert.assertNotNull((Object)holdId);
            this.logger.info((Object)("Checking hold " + holdId));
            try {
                Hold createdHold = filePlanHolds.stream().filter(child -> child.getId().equals(holdId)).findFirst().orElseThrow();
                AssertJUnit.assertEquals((String)createdHold.getName(), (String)hold.getName());
                AssertJUnit.assertEquals((String)createdHold.getDescription(), (String)hold.getDescription());
                AssertJUnit.assertEquals((String)createdHold.getReason(), (String)hold.getReason());
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + String.valueOf(hold)));
            }
        });
    }
}

