/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MoveRecordsTests
extends BaseRMRestTest {
    @Test(description="rma:recordSearch aspect is reapplied after record move")
    @AlfrescoTest(jira="RM-7060")
    public void moveRecord() throws Exception {
        String parentFolderId = this.createCategoryFolderInFilePlan().getId();
        String targetFolderId = this.createCategoryFolderInFilePlan().getId();
        String electronicRecordId = this.createElectronicRecord(parentFolderId, TestData.ELECTRONIC_RECORD_NAME).getId();
        Step.STEP((String)"Move record from one folder to the other");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(electronicRecordId)).move(CoreUtil.createBodyForMoveCopy(targetFolderId));
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Check the record still has rma:recordSearch aspect.");
        Assert.assertTrue((boolean)this.hasAspect(electronicRecordId, "rma:recordSearch"), (String)"recordSearch aspect is lost after move!");
    }
}

