/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoUtility.class);

    private PojoUtility() {
    }

    public static String toJson(Object model) {
        ParameterCheck.mandatoryObject("model", model);
        return PojoUtility.toJson(model, null, null);
    }

    public static String toJson(Object model, Class<?> target, Class<?> mixinSource) {
        ParameterCheck.mandatoryObject("model", model);
        ObjectMapper mapper = new ObjectMapper();
        if (target != null && mixinSource != null) {
            mapper.addMixIn(target, mixinSource);
        }
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(model);
        }
        catch (JsonProcessingException error) {
            return error.toString();
        }
    }

    public static <T> T jsonToObject(JSONObject json, Class<T> classz) {
        ParameterCheck.mandatoryObject("model", classz);
        ParameterCheck.mandatoryObject("jsonObject", json);
        ObjectMapper mapper = new ObjectMapper();
        Object obj = null;
        try {
            obj = mapper.readValue(json.toString(), classz);
        }
        catch (IOException e) {
            LOGGER.error("Unable to convert the json into a java object.", (Throwable)e);
        }
        return (T)obj;
    }

    public static <T> List<T> jsonToObject(JSONArray json, Class<T> classz) {
        ParameterCheck.mandatoryObject("model", classz);
        ParameterCheck.mandatoryObject("jsonObject", json);
        ObjectMapper mapper = new ObjectMapper();
        CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(List.class, classz);
        List asList = null;
        try {
            asList = (List)mapper.readValue(json.toString(), (JavaType)collectionType);
        }
        catch (IOException e) {
            LOGGER.error("Unable to convert the json array into a java collection.", (Throwable)e);
        }
        return asList;
    }
}

