/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.core.v0.APIUtils;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.model.hold.HoldEntry;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.alfresco.utility.model.UserModel;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class HoldsAPI
extends BaseAPI {
    public static final String HOLDS_CONTAINER = "Holds";
    private static final String CREATE_HOLDS_API = "{0}type/rma:hold/formprocessor";
    private static final String RM_HOLDS_API = "{0}rma/holds";
    private static final String GET_RM_HOLDS = "{0}rma/holds?{1}";

    public HttpResponse createHold(String user, String password, String holdName, String reason, String description) {
        return this.createHold(user, password, holdName, reason, description, 200);
    }

    public HttpResponse createHold(String user, String password, String holdName, String reason, String description, int expectedStatusCode) {
        String parentNodeRef = this.getItemNodeRef(user, password, "/Holds");
        JSONObject requestParams = new JSONObject();
        requestParams.put("alf_destination", (Object)(HoldsAPI.getNodeRefSpacesStore() + parentNodeRef));
        requestParams.put("prop_cm_name", (Object)holdName);
        requestParams.put("prop_cm_description", (Object)description);
        requestParams.put("prop_rma_holdReason", (Object)reason);
        return this.doPostJsonRequest(user, password, expectedStatusCode, requestParams, CREATE_HOLDS_API, new String[0]);
    }

    public String createHoldAndGetNodeRef(String user, String password, String holdName, String reason, String description) {
        HttpResponse httpResponse = this.createHold(user, password, holdName, reason, description);
        try {
            return APIUtils.convertHTTPResponseToJSON(httpResponse).getString("persistedObject").replace("workspace://SpacesStore/", "");
        }
        catch (JSONException error) {
            LOGGER.error("Converting message body to JSON failed. Body: {}", (Object)httpResponse, (Object)error);
        }
        catch (ParseException error) {
            LOGGER.error("Parsing message body failed.", (Throwable)error);
        }
        return null;
    }

    public HttpResponse deleteHold(UserModel user, String holdNodeRef) {
        return this.deleteHold(user.getUsername(), user.getPassword(), holdNodeRef, 200);
    }

    public HttpResponse deleteHold(String username, String password, String holdNodeRef, int expectedStatusCode) {
        JSONObject requestParams = new JSONObject();
        requestParams.put("name", (Object)"deleteHold");
        requestParams.put("nodeRef", (Object)(HoldsAPI.getNodeRefSpacesStore() + holdNodeRef));
        return this.doPostJsonRequest(username, password, expectedStatusCode, requestParams, "{0}rma/actions/ExecutionQueue", new String[0]);
    }

    public void deleteHold(String username, String password, String holdName) {
        this.deleteItem(username, password, String.format("/%s/%s", HOLDS_CONTAINER, holdName));
    }

    public HttpResponse addItemToHold(String user, String password, String itemNodeRef, String holdName) {
        return this.addItemsToHolds(user, password, Collections.singletonList(itemNodeRef), Collections.singletonList(holdName));
    }

    public HttpResponse addItemsToHolds(String user, String password, List<String> itemNodeRefs, List<String> holdNames) {
        List<String> holdNodeRefs = holdNames.stream().map(hold -> this.getItemNodeRef(user, password, String.format("/%s/%s", HOLDS_CONTAINER, hold))).collect(Collectors.toList());
        return this.addItemsToHolds(user, password, 200, itemNodeRefs, holdNodeRefs);
    }

    public HttpResponse addItemsToHolds(String user, String password, int expectedStatus, List<String> itemNodeRefs, List<String> holdNodeRefs) {
        JSONObject requestParams = this.addOrRemoveToFromHoldJsonObject(itemNodeRefs, holdNodeRefs);
        return this.doPostJsonRequest(user, password, expectedStatus, requestParams, RM_HOLDS_API, new String[0]);
    }

    public String addToHoldAndGetMessage(String user, String password, int expectedStatus, String itemNodeRef, String holdNodeRef) {
        HttpResponse httpResponse = this.addItemsToHolds(user, password, expectedStatus, Collections.singletonList(itemNodeRef), Collections.singletonList(holdNodeRef));
        return APIUtils.extractErrorMessageFromHttpResponse(httpResponse);
    }

    private JSONObject addOrRemoveToFromHoldJsonObject(List<String> items, List<String> holdNodeRefs) {
        JSONArray nodeRefs = new JSONArray();
        items.forEach(itemNodeRef -> nodeRefs.put((Object)(HoldsAPI.getNodeRefSpacesStore() + itemNodeRef)));
        JSONArray holds = new JSONArray();
        holdNodeRefs.forEach(holdNodeRef -> holds.put((Object)(HoldsAPI.getNodeRefSpacesStore() + holdNodeRef)));
        JSONObject requestParams = new JSONObject();
        requestParams.put("nodeRefs", (Object)nodeRefs);
        requestParams.put("holds", (Object)holds);
        return requestParams;
    }

    public HttpResponse removeItemFromHold(String user, String password, String itemNodeRef, String holdName) {
        return this.removeItemsFromHolds(user, password, Collections.singletonList(itemNodeRef), Collections.singletonList(holdName));
    }

    public HttpResponse removeItemsFromHolds(String user, String password, List<String> itemNodeRefs, List<String> holdNames) {
        List<String> holdNodeRefs = holdNames.stream().map(hold -> this.getItemNodeRef(user, password, String.format("/%s/%s", HOLDS_CONTAINER, hold))).collect(Collectors.toList());
        return this.removeItemsFromHolds(user, password, 200, itemNodeRefs, holdNodeRefs);
    }

    public HttpResponse removeItemsFromHolds(String user, String password, int expectedStatus, List<String> itemNodeRefs, List<String> holdNodeRefs) {
        JSONObject requestParams = this.addOrRemoveToFromHoldJsonObject(itemNodeRefs, holdNodeRefs);
        return this.doPutJsonRequest(user, password, expectedStatus, requestParams, RM_HOLDS_API, new String[0]);
    }

    public String removeFromHoldAndGetMessage(String user, String password, int expectedStatus, String itemNodeRef, String holdNodeRef) {
        HttpResponse httpResponse = this.removeItemsFromHolds(user, password, expectedStatus, Collections.singletonList(itemNodeRef), Collections.singletonList(holdNodeRef));
        return APIUtils.extractErrorMessageFromHttpResponse(httpResponse);
    }

    public List<HoldEntry> getHolds(String user, String password, String itemNodeRef, Boolean includedInHold, Boolean fileOnly) {
        String parameters = (String)(itemNodeRef != null ? "itemNodeRef=workspace://SpacesStore/" + itemNodeRef : "") + (String)(includedInHold != null ? "&includedInHold=" + includedInHold : "") + (String)(fileOnly != null ? "&fileOnly=" + fileOnly : "");
        JSONArray holdEntries = this.doGetRequest(user, password, MessageFormat.format(GET_RM_HOLDS, "{0}", parameters), new String[0]).getJSONObject("data").getJSONArray("holds");
        return PojoUtility.jsonToObject(holdEntries, HoldEntry.class);
    }
}

