/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEntry;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6859")
public class AuditAddToHoldTests
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditAddToHoldTests.class);
    private final String HOLD1 = this.PREFIX + "hold1";
    private final String HOLD2 = this.PREFIX + "hold2";
    @Autowired
    private RMAuditService rmAuditService;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;
    private UserModel rmAdmin;
    private UserModel rmManagerNoReadOnHold;
    private UserModel rmManagerNoReadOnNode;
    private SiteModel privateSite;
    private RecordCategory recordCategory;
    private RecordCategoryChild recordFolder;
    private List<AuditEntry> auditEntries;
    private final List<String> holdsList = Arrays.asList(this.HOLD1, this.HOLD2);
    private List<String> holdsListRef = new ArrayList<String>();
    private String hold1NodeRef;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAuditAddToHoldTests() {
        Step.STEP((String)"Create 2 holds.");
        this.hold1NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD1, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        String hold2NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD2, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsListRef = Arrays.asList(this.hold1NodeRef, hold2NodeRef);
        Step.STEP((String)"Create a new record category with a record folder.");
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        this.recordFolder = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "recFolder");
        Step.STEP((String)"Create an user with full rights to add content to a hold.");
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        Step.STEP((String)"Create a collaboration site.");
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.rmAdmin)).createPrivateRandomSite();
        Step.STEP((String)"Create users without rights to add content to a hold.");
        this.rmManagerNoReadOnHold = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.privateSite, UserRole.SiteManager, this.recordCategory.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.rmManagerNoReadOnNode = this.roleService.createUserWithRMRoleAndRMNodePermission(UserRoles.ROLE_RM_MANAGER.roleId, this.hold1NodeRef, UserPermissions.PERMISSION_FILING);
    }

    @DataProvider(name="validNodesForAddToHold")
    public Object[][] getValidNodesForAddToHold() {
        FileModel contentToBeAdded = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RecordCategoryChild recordFolderToBeAdded = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "recFolderToBeAdded");
        Record recordToBeAdded = this.createElectronicRecord(this.recordFolder.getId(), this.PREFIX + "record");
        String recordFolderPath = Utility.removeLastSlash((String)Utility.buildPath((String)"/rm/documentLibrary", (String[])new String[]{this.recordCategory.getName(), recordFolderToBeAdded.getName()}));
        String recordPath = Utility.removeLastSlash((String)Utility.buildPath((String)"/rm/documentLibrary", (String[])new String[]{this.recordCategory.getName(), this.recordFolder.getName(), recordToBeAdded.getName()}));
        String contentPath = "/Company Home" + contentToBeAdded.getCmisLocation();
        return new String[][]{{recordFolderToBeAdded.getId(), recordFolderToBeAdded.getName(), recordFolderPath}, {recordToBeAdded.getId(), recordToBeAdded.getName(), recordPath}, {contentToBeAdded.getNodeRefWithoutVersion(), contentToBeAdded.getName(), contentPath}};
    }

    @Test(dataProvider="validNodesForAddToHold")
    public void addToHoldEventIsAudited(String nodeId, String nodeName, String nodePath) {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Add node to hold.");
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), nodeId, this.HOLD1);
        Step.STEP((String)"Check the audit log contains the entry for the add to hold event.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.ADD_TO_HOLD, this.rmAdmin, nodeName, nodePath, Arrays.asList(ImmutableMap.of((Object)"new", (Object)nodeName, (Object)"previous", (Object)"", (Object)"name", (Object)"Name"), ImmutableMap.of((Object)"new", (Object)this.HOLD1, (Object)"previous", (Object)"", (Object)"name", (Object)"Hold Name")));
    }

    @Test
    public void unsuccessfulAddToHoldIsNotAudited() {
        Step.STEP((String)"Create a new record");
        Record recordToBeAdded = this.createElectronicRecord(this.recordFolder.getId(), this.PREFIX + "record");
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Try to add the record to a hold by an user with no rights.");
        this.holdsAPI.addItemsToHolds(this.rmManagerNoReadOnHold.getUsername(), this.rmManagerNoReadOnHold.getPassword(), 500, Collections.singletonList(recordToBeAdded.getId()), Collections.singletonList(this.hold1NodeRef));
        Step.STEP((String)"Check the audit log doesn't contain the entry for the unsuccessful add to hold.");
        AssertJUnit.assertTrue((String)"The list of events should not contain Add to Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.ADD_TO_HOLD).isEmpty());
    }

    @Test
    public void addToHoldIsNotAuditedForRecordFolderChildren() {
        Step.STEP((String)"Create a new record folder with a record inside");
        RecordCategoryChild notEmptyRecFolder = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "notEmptyRecFolder");
        Record record = this.createElectronicRecord(notEmptyRecFolder.getId(), this.PREFIX + "record");
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Add record folder to hold.");
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), notEmptyRecFolder.getId(), this.HOLD1);
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.ADD_TO_HOLD);
        Step.STEP((String)"Check the audit log contains only an entry for add to hold.");
        AssertJUnit.assertEquals((String)"The list of events should contain only an entry", (int)1, (int)this.auditEntries.size());
        AssertJUnit.assertTrue((String)"The list of events should not contain Add to Hold entry for the record", (boolean)this.auditEntries.stream().noneMatch(entry -> entry.getNodeName().equals(record.getName())));
    }

    @Test
    public void addToHoldIsAuditedInBulkAddition() {
        Step.STEP((String)"Create a new record");
        Record recordToBeAdded = this.createElectronicRecord(this.recordFolder.getId(), this.PREFIX + "record");
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Add record to multiple holds.");
        this.holdsAPI.addItemsToHolds(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), Collections.singletonList(recordToBeAdded.getId()), this.holdsList);
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.ADD_TO_HOLD);
        Step.STEP((String)"Check the audit log contains entries for both additions.");
        AssertJUnit.assertEquals((String)"The list of events should contain Add to Hold entries for both holds", (int)2, (int)this.auditEntries.size());
        AssertJUnit.assertTrue((String)"The hold name value for the first add to hold is not audited.", (boolean)this.auditEntries.stream().anyMatch(entry -> entry.getChangedValues().contains(ImmutableMap.of((Object)"new", (Object)this.HOLD1, (Object)"previous", (Object)"", (Object)"name", (Object)"Hold Name"))));
        AssertJUnit.assertTrue((String)"The hold name value for the second add to hold is not audited.", (boolean)this.auditEntries.stream().anyMatch(entry -> entry.getChangedValues().contains(ImmutableMap.of((Object)"new", (Object)this.HOLD2, (Object)"previous", (Object)"", (Object)"name", (Object)"Hold Name"))));
    }

    @Test
    public void addToHoldAuditEntryNotVisible() {
        Step.STEP((String)"Create a new file");
        FileModel contentToBeAdded = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Add file to hold.");
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), contentToBeAdded.getNodeRefWithoutVersion(), this.HOLD1);
        Step.STEP((String)"Check that an user with no Read permissions can't see the entry for the add to hold event.");
        AssertJUnit.assertTrue((String)"The list of events should not contain Add to Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.rmManagerNoReadOnNode, AuditEvents.ADD_TO_HOLD).isEmpty());
    }

    @Test
    public void addToHoldAuditEntryHoldNameNotVisible() {
        Step.STEP((String)"Create a new file");
        FileModel contentToBeAdded = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Add file to hold.");
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), contentToBeAdded.getNodeRefWithoutVersion(), this.HOLD1);
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.rmManagerNoReadOnHold, AuditEvents.ADD_TO_HOLD);
        Step.STEP((String)"Check that an user with no Read permissions can't see the hold name in the add to hold event.");
        String replacementHoldName = "You don't have permission to view this hold.";
        AssertJUnit.assertEquals((String)"The list of events should contain the Add to Hold entry", (int)1, (int)this.auditEntries.size());
        AssertJUnit.assertTrue((String)"The hold name should not be visible in the Add to Hold entry ", (boolean)this.auditEntries.stream().anyMatch(entry -> entry.getChangedValues().contains(ImmutableMap.of((Object)"new", (Object)replacementHoldName, (Object)"previous", (Object)"", (Object)"name", (Object)"Hold Name"))));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpAuditAddToHoldTests() {
        this.holdsListRef.forEach(holdRef -> this.holdsAPI.deleteHold(this.getAdminUser(), holdRef));
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.privateSite);
        Arrays.asList(this.rmAdmin, this.rmManagerNoReadOnHold, this.rmManagerNoReadOnNode).forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
        this.deleteRecordCategory(this.recordCategory.getId());
    }
}

