/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.utils;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordProperties;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChildProperties;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryProperties;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderProperties;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.utility.data.RandomData;
import org.testng.Assert;

public class FilePlanComponentsUtil {
    public static final String IMAGE_FILE = "money.JPG";
    public static final String TITLE_PREFIX = "Title for ";
    public static final String DESCRIPTION_PREFIX = "This is the description for";

    private FilePlanComponentsUtil() {
    }

    public static File getFile(String fileName) {
        return new File(Resources.getResource((String)fileName).getFile());
    }

    private static Record createRecordModel(String nodeType) {
        return Record.builder().name("Record " + RandomData.getRandomAlphanumeric()).nodeType(nodeType).build();
    }

    public static Record createElectronicRecordModel() {
        return FilePlanComponentsUtil.createRecordModel("cm:content");
    }

    public static UnfiledContainerChild createElectronicUnfiledContainerChildModel() {
        return FilePlanComponentsUtil.createUnfiledContainerChildRecordModel("Record " + RandomData.getRandomAlphanumeric(), "cm:content");
    }

    public static UnfiledContainerChild createNonElectronicUnfiledContainerChildModel() {
        return FilePlanComponentsUtil.createUnfiledContainerChildRecordModel("Record " + RandomData.getRandomAlphanumeric(), "rma:nonElectronicDocument");
    }

    public static UnfiledContainerChild createUnfiledContainerChildRecordModel(String name, String nodeType) {
        return UnfiledContainerChild.builder().name(name).nodeType(nodeType).build();
    }

    public static UnfiledContainerChild createFullNonElectronicUnfiledContainerChildRecordModel(String name, String title, String description, String box, String file, String shelf, String storageLocation, Integer numberOfCopies, Integer physicalSize) {
        return UnfiledContainerChild.builder().name(name).nodeType("rma:nonElectronicDocument").properties(UnfiledContainerChildProperties.builder().title(title).description(description).box(box).file(file).shelf(shelf).storageLocation(storageLocation).numberOfCopies(numberOfCopies).physicalSize(physicalSize).build()).build();
    }

    public static Record createNonElectronicRecordModel() {
        return FilePlanComponentsUtil.createRecordModel("rma:nonElectronicDocument");
    }

    public static Record createFullNonElectronicRecordModel(String name, String title, String description, String box, String file, String shelf, String storageLocation, Integer numberOfCopies, Integer physicalSize) {
        return Record.builder().name(name).nodeType("rma:nonElectronicDocument").properties(RecordProperties.builder().title(title).description(description).box(box).file(file).shelf(shelf).storageLocation(storageLocation).numberOfCopies(numberOfCopies).physicalSize(physicalSize).build()).build();
    }

    public static Record createRecordModel(String name, String description, String title) {
        return Record.builder().name(name).properties(RecordProperties.builder().description(description).title(title).build()).build();
    }

    public static RecordCategoryChild createRecordCategoryChildModel(String name, String nodeType) {
        return RecordCategoryChild.builder().name(name).nodeType(nodeType).properties(RecordCategoryChildProperties.builder().title(TITLE_PREFIX + name).build()).build();
    }

    public static RecordCategory createRecordCategoryModel(String name, String title) {
        return RecordCategory.builder().name(name).nodeType("rma:recordCategory").properties(RecordCategoryProperties.builder().title(title).build()).build();
    }

    public static RecordFolder createRecordFolderModel(String name, String title) {
        return RecordFolder.builder().name(name).nodeType("rma:recordFolder").properties(RecordFolderProperties.builder().title(title).build()).build();
    }

    public static UnfiledContainerChild createUnfiledContainerChildModel(String name, String nodeType) {
        return UnfiledContainerChild.builder().name(name).nodeType(nodeType).properties(UnfiledContainerChildProperties.builder().title(TITLE_PREFIX + name).build()).build();
    }

    public static File createTempFile(String name, String content) {
        try {
            File file = File.createTempFile(name, ".txt");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8").newEncoder());){
                writer.write(content);
            }
            return file;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create test file.", exception);
        }
    }

    public static File createTempFile(String name, long sizeInMegaBytes) {
        try {
            File file = File.createTempFile(name, ".txt");
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.setLength(sizeInMegaBytes * 1024L * 1024L);
            raf.close();
            return file;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create test file.", exception);
        }
    }

    public static void verifyFullNonElectronicRecord(Record nonElectronicRecord, String name, String title, String description, String box, String file, String shelf, String storageLocation, Integer numberOfCopies, Integer physicalSize) {
        RecordProperties properties = nonElectronicRecord.getProperties();
        Assert.assertEquals((String)title, (String)properties.getTitle());
        Assert.assertEquals((String)description, (String)properties.getDescription());
        Assert.assertEquals((String)box, (String)properties.getBox());
        Assert.assertEquals((String)file, (String)properties.getFile());
        Assert.assertEquals((String)shelf, (String)properties.getShelf());
        Assert.assertEquals((String)storageLocation, (String)properties.getStorageLocation());
        Assert.assertEquals((Object)numberOfCopies, (Object)properties.getNumberOfCopies());
        Assert.assertEquals((Object)physicalSize, (Object)properties.getPhysicalSize());
        Assert.assertTrue((boolean)nonElectronicRecord.getName().contains(properties.getIdentifier()));
        Assert.assertTrue((boolean)nonElectronicRecord.getName().contains(name));
    }
}

