/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEntry;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6859")
public class AuditRemoveFromHoldTests
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditRemoveFromHoldTests.class);
    private final String HOLD1 = this.PREFIX + "hold1";
    private final String HOLD2 = this.PREFIX + "hold2";
    private final String HOLD3 = this.PREFIX + "hold3";
    @Autowired
    private RMAuditService rmAuditService;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;
    private UserModel rmAdmin;
    private UserModel rmManagerNoReadOnHold;
    private UserModel rmManagerNoReadOnNode;
    private SiteModel privateSite;
    private RecordCategory recordCategory;
    private RecordCategoryChild recordFolder;
    private RecordCategoryChild heldRecordFolder;
    private Record heldRecord;
    private List<AuditEntry> auditEntries;
    private final List<String> holdsList = Arrays.asList(this.HOLD1, this.HOLD2, this.HOLD3);
    private List<String> holdsListRef = new ArrayList<String>();
    private FileModel heldContent;
    private String hold1NodeRef;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAuditRemoveFromHoldTests() {
        Step.STEP((String)"Create an user with full rights to remove content from a hold.");
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        Step.STEP((String)"Create a collaboration site.");
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.rmAdmin)).createPrivateRandomSite();
        Step.STEP((String)"Create new holds.");
        this.hold1NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD1, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        String hold2NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD2, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        String hold3NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD3, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsListRef = Arrays.asList(this.hold1NodeRef, hold2NodeRef, hold3NodeRef);
        Step.STEP((String)"Create a new record category with a record folder.");
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        this.recordFolder = this.createRecordFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Step.STEP((String)"Create some held items");
        this.heldContent = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.heldRecordFolder = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "heldRecFolder");
        this.heldRecord = this.createElectronicRecord(this.recordFolder.getId(), this.PREFIX + "record");
        this.holdsAPI.addItemsToHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), Arrays.asList(this.heldContent.getNodeRefWithoutVersion(), this.heldRecordFolder.getId(), this.heldRecord.getId()), this.holdsList);
        Step.STEP((String)"Create users without rights to remove content from a hold.");
        this.rmManagerNoReadOnHold = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.privateSite, UserRole.SiteManager, this.recordCategory.getId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.rmManagerNoReadOnNode = this.roleService.createUserWithRMRoleAndRMNodePermission(UserRoles.ROLE_RM_MANAGER.roleId, this.hold1NodeRef, UserPermissions.PERMISSION_FILING);
    }

    @DataProvider(name="validNodesForRemoveFromHold")
    public Object[][] getValidNodesForRemoveFromHold() {
        String recordFolderPath = Utility.removeLastSlash((String)Utility.buildPath((String)"/rm/documentLibrary", (String[])new String[]{this.recordCategory.getName(), this.heldRecordFolder.getName()}));
        String recordPath = Utility.removeLastSlash((String)Utility.buildPath((String)"/rm/documentLibrary", (String[])new String[]{this.recordCategory.getName(), this.recordFolder.getName(), this.heldRecord.getName()}));
        String contentPath = "/Company Home" + this.heldContent.getCmisLocation();
        return new String[][]{{this.heldRecordFolder.getId(), this.heldRecordFolder.getName(), recordFolderPath}, {this.heldRecord.getId(), this.heldRecord.getName(), recordPath}, {this.heldContent.getNodeRefWithoutVersion(), this.heldContent.getName(), contentPath}};
    }

    @Test(dataProvider="validNodesForRemoveFromHold")
    public void removeFromHoldEventIsAudited(String nodeId, String nodeName, String nodePath) {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Remove node from hold.");
        this.holdsAPI.removeItemFromHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), nodeId, this.HOLD3);
        Step.STEP((String)"Check the audit log contains the entry for the remove from hold event.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.REMOVE_FROM_HOLD, this.rmAdmin, nodeName, nodePath, Arrays.asList(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)nodeName, (Object)"name", (Object)"Name"), ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.HOLD3, (Object)"name", (Object)"Hold Name")));
    }

    @Test
    public void unsuccessfulRemoveFromHoldIsNotAudited() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Try to remove the record from a hold by an user with no rights.");
        this.holdsAPI.removeItemsFromHolds(this.rmManagerNoReadOnHold.getUsername(), this.rmManagerNoReadOnHold.getPassword(), 500, Collections.singletonList(this.heldRecord.getId()), Collections.singletonList(this.hold1NodeRef));
        Step.STEP((String)"Check the audit log doesn't contain the entry for the unsuccessful remove from hold.");
        AssertJUnit.assertTrue((String)"The list of events should not contain remove from hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.REMOVE_FROM_HOLD).isEmpty());
    }

    @Test
    public void removeFromHoldNotAuditedForRecordFolderChildren() {
        Step.STEP((String)"Create a new record folder with a record inside");
        RecordCategoryChild notEmptyRecFolder = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "notEmptyRecFolder");
        Record record = this.createElectronicRecord(notEmptyRecFolder.getId(), this.PREFIX + "record");
        Step.STEP((String)"Add the record folder to a hold.");
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), notEmptyRecFolder.getId(), this.HOLD1);
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Remove record folder from hold.");
        this.holdsAPI.removeItemFromHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), notEmptyRecFolder.getId(), this.HOLD1);
        Step.STEP((String)"Get the list of audit entries for the remove from hold event.");
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.REMOVE_FROM_HOLD);
        Step.STEP((String)"Check the audit log contains only an entry for remove from hold.");
        AssertJUnit.assertEquals((String)"The list of events should contain only an entry", (int)1, (int)this.auditEntries.size());
        AssertJUnit.assertTrue((String)"The list of events should not contain Remove from Hold entry for the record", (boolean)this.auditEntries.stream().noneMatch(entry -> entry.getNodeName().equals(record.getName())));
    }

    @Test
    public void removeFromHoldIsAuditedInBulkRemoval() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Remove record folder from multiple holds.");
        this.holdsAPI.removeItemsFromHolds(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), Collections.singletonList(this.heldRecordFolder.getId()), Arrays.asList(this.HOLD1, this.HOLD2));
        Step.STEP((String)"Get the list of audit entries for the remove from hold event.");
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.REMOVE_FROM_HOLD);
        Step.STEP((String)"Check the audit log contains entries for both removal.");
        AssertJUnit.assertEquals((String)"The list of events should contain remove from Hold entries for both holds", (int)2, (int)this.auditEntries.size());
        AssertJUnit.assertTrue((String)"The hold name value for the first remove from hold is not audited.", (boolean)this.auditEntries.stream().anyMatch(entry -> entry.getChangedValues().contains(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.HOLD1, (Object)"name", (Object)"Hold Name"))));
        AssertJUnit.assertTrue((String)"The hold name value for the second remove from hold is not audited.", (boolean)this.auditEntries.stream().anyMatch(entry -> entry.getChangedValues().contains(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.HOLD2, (Object)"name", (Object)"Hold Name"))));
    }

    @Test
    public void removeFromHoldAuditEntryNotVisible() {
        Step.STEP((String)"Add content to a hold.");
        FileModel heldFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), heldFile.getNodeRefWithoutVersion(), this.HOLD1);
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Remove held content from the hold.");
        this.holdsAPI.removeItemFromHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), heldFile.getNodeRefWithoutVersion(), this.HOLD1);
        Step.STEP((String)"Check that an user with no Read permissions can't see the entry for the remove from hold event.");
        AssertJUnit.assertTrue((String)"The list of events should not contain Remove from Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.rmManagerNoReadOnNode, AuditEvents.REMOVE_FROM_HOLD).isEmpty());
    }

    @Test
    public void removeFromHoldAuditEntryHoldNameNotVisible() {
        Step.STEP((String)"Add content to a hold.");
        FileModel heldFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), heldFile.getNodeRefWithoutVersion(), this.HOLD1);
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Remove held content from the hold.");
        this.holdsAPI.removeItemFromHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), heldFile.getNodeRefWithoutVersion(), this.HOLD1);
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.rmManagerNoReadOnHold, AuditEvents.REMOVE_FROM_HOLD);
        Step.STEP((String)"Check that an user with no Read permissions can't see the hold name in the remove from hold event.");
        String replacementHoldName = "You don't have permission to view this hold.";
        AssertJUnit.assertEquals((String)"The list of events should contain the Remove from Hold entry", (int)1, (int)this.auditEntries.size());
        AssertJUnit.assertTrue((String)"The hold name should not be visible in the Remove from Hold entry ", (boolean)this.auditEntries.stream().anyMatch(entry -> entry.getChangedValues().contains(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)replacementHoldName, (Object)"name", (Object)"Hold Name"))));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpAuditRemoveFromHoldTests() {
        this.holdsListRef.forEach(holdRef -> this.holdsAPI.deleteHold(this.getAdminUser(), holdRef));
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.privateSite);
        Arrays.asList(this.rmAdmin, this.rmManagerNoReadOnHold, this.rmManagerNoReadOnNode).forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
        this.deleteRecordCategory(this.recordCategory.getId());
    }
}

