/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.io.FileInputStream;
import java.io.InputStream;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordContent;
import org.alfresco.rest.rm.community.model.record.RecordProperties;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChildCollection;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChildEntry;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ReadRecordTests
extends BaseRMRestTest {
    public static final String CATEGORY_NAME = TestData.RECORD_CATEGORY_NAME + RandomData.getRandomAlphanumeric();
    public static final String ELECTRONIC_RECORD_NAME = "Record electronic" + RandomData.getRandomAlphanumeric();
    public static final String NONELECTRONIC_RECORD_NAME = "Record nonelectronic" + RandomData.getRandomAlphanumeric();
    private Record electronicRecord = Record.builder().name(ELECTRONIC_RECORD_NAME).nodeType("cm:content").build();
    private Record nonelectronicRecord = Record.builder().properties(RecordProperties.builder().description(NONELECTRONIC_RECORD_NAME).title("Title").build()).name(NONELECTRONIC_RECORD_NAME).nodeType("rma:nonElectronicDocument").build();
    private RecordCategory rootCategory;
    private RecordCategory rootCategory2;
    private RecordCategoryChild recordFolder;

    @BeforeClass(alwaysRun=true)
    public void setupReadRecordTests() {
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.rootCategory2 = this.createRootCategory(RandomData.getRandomName((String)"rootCategory2"));
        this.recordFolder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder"));
    }

    @DataProvider(name="invalidContainersForRecords")
    public Object[][] getInvalidContainersForRecords() {
        return new String[][]{{"-filePlan-"}, {"-transfers-"}, {this.rootCategory.getId()}};
    }

    @Test(dataProvider="invalidContainersForRecords", description="Reading records from invalid containers")
    @AlfrescoTest(jira="RM-4361")
    public void readRecordsFromInvalidContainers(String container) {
        Record electronicRecord = Record.builder().name(ELECTRONIC_RECORD_NAME).nodeType("cm:content").content(RecordContent.builder().mimeType("text/plain").build()).build();
        Record nonelectronicRecord = Record.builder().properties(RecordProperties.builder().description("Description").title("Title").build()).name(NONELECTRONIC_RECORD_NAME).nodeType("rma:nonElectronicDocument").build();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        recordFolderAPI.createRecord(electronicRecord, container);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
        recordFolderAPI.createRecord(nonelectronicRecord, container);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
        if ("-filePlan-".equals(container)) {
            ((RestModels)this.getRestAPIFactory().getFilePlansAPI().getRootRecordCategories(container, "").assertThat().entriesListIsNotEmpty()).assertThat().paginationExist();
            this.assertStatusCode(HttpStatus.OK);
        } else if ("-transfers-".equals(container)) {
            ((RestModels)this.getRestAPIFactory().getTransferContainerAPI().getTransfers(container, "where=(isRecord=true)").assertThat().entriesListIsEmpty()).assertThat().paginationExist();
            this.assertStatusCode(HttpStatus.OK);
        } else {
            RecordCategoryChildCollection children = this.getRestAPIFactory().getRecordCategoryAPI().getRecordCategoryChildren(container);
            this.assertStatusCode(HttpStatus.OK);
            ((RestModels)children.assertThat().entriesListCountIs(1)).assertThat().paginationExist();
            Assert.assertEquals((String)((RecordCategoryChildEntry)children.getEntries().get(0)).getEntry().getNodeType(), (String)"rma:recordFolder");
        }
    }

    @Test
    @AlfrescoTest(jira="RM-4361")
    public void readRecordMetadata() {
        String RELATIVE_PATH = "/" + CATEGORY_NAME + RandomData.getRandomAlphanumeric() + "/folder";
        RecordCategory recordCategoryModel = FilePlanComponentsUtil.createRecordCategoryModel(CATEGORY_NAME, CATEGORY_NAME);
        String recordCategoryId = this.getRestAPIFactory().getFilePlansAPI().createRootRecordCategory(recordCategoryModel, "-filePlan-").getId();
        RecordCategoryChild recordFolderModel = RecordCategoryChild.builder().name(TestData.RECORD_FOLDER_NAME).nodeType("rma:recordFolder").relativePath(RELATIVE_PATH).build();
        String recordFolderId = this.getRestAPIFactory().getRecordCategoryAPI().createRecordCategoryChild(recordFolderModel, recordCategoryId, "include=path").getId();
        String recordWithContentId = this.getRestAPIFactory().getRecordFolderAPI().createRecord(this.electronicRecord, recordFolderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
        Record recordWithContent = this.getRestAPIFactory().getRecordsAPI().getRecord(recordWithContentId, "include=isCompleted,content");
        AssertJUnit.assertTrue((boolean)recordWithContent.getName().startsWith(ELECTRONIC_RECORD_NAME));
        Assert.assertNotNull((Object)recordWithContent.getContent().getEncoding());
        Assert.assertEquals((String)recordWithContent.getNodeType(), (String)"cm:content");
        Assert.assertNotNull((Object)recordWithContent.getContent().getEncoding());
        Assert.assertNotNull((Object)recordWithContent.getContent().getMimeType());
        Assert.assertNotNull((Object)recordWithContent.getAspectNames());
        Assert.assertNotEquals((Object)ELECTRONIC_RECORD_NAME, (Object)recordWithContent.getName());
        AssertJUnit.assertTrue((boolean)recordWithContent.getName().contains(recordWithContent.getProperties().getIdentifier()));
        this.assertStatusCode(HttpStatus.OK);
        String nonElectronicRecordId = this.getRestAPIFactory().getRecordFolderAPI().createRecord(this.nonelectronicRecord, recordFolderId).getId();
        Record nonElectronicRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(nonElectronicRecordId, "include=isCompleted,content");
        AssertJUnit.assertTrue((boolean)nonElectronicRecord.getName().startsWith(NONELECTRONIC_RECORD_NAME));
        Assert.assertNull((Object)nonElectronicRecord.getContent());
        Assert.assertEquals((String)nonElectronicRecord.getNodeType(), (String)"rma:nonElectronicDocument");
        Assert.assertNotNull((Object)nonElectronicRecord.getAspectNames());
        Assert.assertEquals((String)nonElectronicRecord.getProperties().getDescription(), (String)NONELECTRONIC_RECORD_NAME);
        Assert.assertNotEquals((Object)NONELECTRONIC_RECORD_NAME, (Object)nonElectronicRecord.getName());
        AssertJUnit.assertTrue((boolean)nonElectronicRecord.getName().contains(nonElectronicRecord.getProperties().getIdentifier()));
        this.assertStatusCode(HttpStatus.OK);
    }

    @Test
    @AlfrescoTest(jira="RM-4361")
    public void readRecordContent() throws Exception {
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        String RECORD_ELECTRONIC = "Record " + RandomData.getRandomAlphanumeric();
        String RECORD_ELECTRONIC_BINARY = "Binary Record" + RandomData.getRandomAlphanumeric();
        String RELATIVE_PATH = "/" + CATEGORY_NAME + RandomData.getRandomAlphanumeric() + "/folder";
        RecordCategoryChild recordFolder = RecordCategoryChild.builder().name(TestData.RECORD_FOLDER_NAME).nodeType("rma:recordFolder").relativePath(RELATIVE_PATH).build();
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        String folderId = recordCategoryAPI.createRecordCategoryChild(recordFolder, this.rootCategory2.getId()).getId();
        Record recordText = Record.builder().name(RECORD_ELECTRONIC).nodeType("cm:content").build();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String recordId = recordFolderAPI.createRecord(recordText, folderId, FilePlanComponentsUtil.createTempFile(RECORD_ELECTRONIC, RECORD_ELECTRONIC)).getId();
        Assert.assertEquals((String)recordsAPI.getRecordContent(recordId).asString(), (String)RECORD_ELECTRONIC);
        this.assertStatusCode(HttpStatus.OK);
        Record recordBinary = Record.builder().name(RECORD_ELECTRONIC_BINARY).nodeType("cm:content").build();
        String binaryRecordId = recordFolderAPI.createRecord(recordBinary, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
        try (InputStream recordContentStream = recordsAPI.getRecordContent(binaryRecordId).asInputStream();
             FileInputStream localFileStream = new FileInputStream(FilePlanComponentsUtil.getFile("money.JPG"));){
            Assert.assertEquals((Object)DigestUtils.sha1((InputStream)recordContentStream), (Object)DigestUtils.sha1((InputStream)localFileStream));
        }
        this.assertStatusCode(HttpStatus.OK);
        Record recordNoContent = Record.builder().name(RECORD_ELECTRONIC).nodeType("cm:content").build();
        String recordNoContentId = recordFolderAPI.createRecord(recordNoContent, folderId).getId();
        AssertJUnit.assertTrue((boolean)recordsAPI.getRecordContent(recordNoContentId).asString().isEmpty());
        this.assertStatusCode(HttpStatus.OK);
    }

    @Test
    @AlfrescoTest(jira="RM-4361")
    public void readNonElectronicRecordContent() {
        Record record = Record.builder().name(RandomData.getRandomName((String)"Record nonelectronic")).nodeType("rma:nonElectronicDocument").build();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String nonElectronicRecord = recordFolderAPI.createRecord(record, this.recordFolder.getId()).getId();
        this.getRestAPIFactory().getRecordsAPI().getRecordContent(nonElectronicRecord);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @DataProvider(name="noContentNodes")
    public Object[][] getNonRecordTypes() {
        return new String[][]{{this.getFilePlan("-filePlan-").getId()}, {this.getTransferContainer("-transfers-").getId()}, {this.rootCategory.getId()}};
    }

    @Test(dataProvider="noContentNodes", description="Reading records from invalid containers")
    @AlfrescoTest(jira="RM-4361")
    public void readContentFromInvalidContainers(String container) {
        this.getRestAPIFactory().getRecordsAPI().getRecordContent(container).asString();
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @AfterClass(alwaysRun=true)
    public void cleanupReadRecordTests() {
        this.deleteRecordCategory(this.rootCategory.getId());
        this.deleteRecordCategory(this.rootCategory2.getId());
    }
}

