/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.files;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.FilesAPI;
import org.alfresco.rest.rm.community.util.DockerHelper;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6779")
public class DeclareAndFileDocumentAsRecordTests
extends BaseRMRestTest {
    private static final String DESTINATION_PATH_NOT_FOUND_EXC = "Unable to execute create-record action, because the destination path could not be found.";
    private static final String INVALID_DESTINATION_PATH_EXC = "Unable to execute create-record action, because the destination path is invalid.";
    private static final String DESTINATION_PATH_NOT_RECORD_FOLDER_EXC = "Unable to execute create-record action, because the destination path is not a record folder.";
    private static final String CLOSED_RECORD_FOLDER_EXC = "You can't add new items to a closed record folder.";
    private static final String HOLD_NAME = RandomData.getRandomName((String)"holdName");
    private static final String RECORD_FOLDER_NAME_WITH_SPACE = "Folder With Spaces In Name";
    private UserModel userFillingPermission;
    private UserModel userReadOnlyPermission;
    private SiteModel publicSite;
    private FolderModel testFolder;
    private FileModel testFile;
    private RecordCategory recordCategory;
    private RecordCategoryChild recordFolder;
    private RecordCategoryChild subcategoryRecordFolder;
    private RecordCategoryChild closedRecordFolder;
    private RecordCategoryChild recordFolderWithSpacesInName;
    private UnfiledContainerChild unfiledContainerFolder;
    private String holdNodeRef;
    @Autowired
    private DockerHelper dockerHelper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private HoldsAPI holdsAPI;

    @DataProvider(name="invalidDestinationPaths")
    public Object[][] getInvalidDestinationPaths() {
        return new String[][]{{"/", DESTINATION_PATH_NOT_FOUND_EXC}, {"Unfiled Records", INVALID_DESTINATION_PATH_EXC}, {"Transfers", INVALID_DESTINATION_PATH_EXC}, {"Holds", INVALID_DESTINATION_PATH_EXC}, {"rm/documentlibrary", DESTINATION_PATH_NOT_FOUND_EXC}, {this.recordCategory.getName(), DESTINATION_PATH_NOT_RECORD_FOLDER_EXC}, {Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.closedRecordFolder.getName()}), CLOSED_RECORD_FOLDER_EXC}, {"Unfiled Records/" + this.unfiledContainerFolder.getName(), INVALID_DESTINATION_PATH_EXC}, {this.testFolder.getCmisLocation(), DESTINATION_PATH_NOT_FOUND_EXC}};
    }

    @DataProvider(name="invalidDestinationIds")
    public Object[][] getInvalidDestinationIds() {
        return new String[][]{{this.getFilePlan("-filePlan-").getId()}, {this.getUnfiledContainer("-unfiled-").getId()}, {this.getTransferContainer("-transfers-").getId()}, {this.rmRolesAndActionsAPI.getItemNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "/Holds")}, {this.recordCategory.getId()}, {this.unfiledContainerFolder.getId()}, {this.testFolder.getNodeRef()}};
    }

    @BeforeClass(alwaysRun=true)
    public void declareAndFileDocumentAsRecordSetup() {
        Step.STEP((String)"Create test collaboration site to store documents in.");
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        Step.STEP((String)"Create a test folder within the collaboration site");
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.publicSite)).createFolder();
        Step.STEP((String)"Create record categories and record folders");
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        RecordCategoryChild subCategory = this.createRecordCategory(this.recordCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        this.recordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        this.subcategoryRecordFolder = this.createFolder(subCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        this.unfiledContainerFolder = this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder");
        this.closedRecordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"closedRecordFolder"));
        this.closeFolder(this.closedRecordFolder.getId());
        this.recordFolderWithSpacesInName = this.createFolder(this.recordCategory.getId(), RECORD_FOLDER_NAME_WITH_SPACE);
        Step.STEP((String)"Create rm users with different permissions on the record category");
        this.userFillingPermission = this.roleService.createCollaboratorWithRMRoleAndPermission(this.publicSite, this.recordCategory, UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_FILING);
        this.userReadOnlyPermission = this.roleService.createCollaboratorWithRMRoleAndPermission(this.publicSite, this.recordCategory, UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_READ_RECORDS);
    }

    @BeforeMethod(alwaysRun=true)
    public void createDocument() {
        Step.STEP((String)"Create a document in the collaboration site");
        this.testFile = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Test
    public void declareAndFileNoLocationUsingActionsAPI() throws Exception {
        Step.STEP((String)"Declare document as record without providing a location parameter value using v1 actions api");
        this.getRestAPIFactory().getActionsAPI(this.userReadOnlyPermission).declareAsRecord((RepoTestModel)this.testFile);
        Step.STEP((String)"Verify the declared record is placed in the Unfiled Records folder");
        Assert.assertTrue((boolean)this.isMatchingRecordInUnfiledRecords(this.testFile), (String)"Record should be filed to Unfiled Records folder");
        Step.STEP((String)"Verify the document in collaboration site is now a record");
        Assert.assertTrue((boolean)this.hasRecordAspect(this.testFile), (String)"File should have record aspect");
    }

    @Test
    public void declareAndFileToValidLocationUsingActionsAPI() throws Exception {
        Step.STEP((String)"Declare document as record with a location parameter value");
        this.getRestAPIFactory().getActionsAPI(this.userFillingPermission).declareAndFile((RepoTestModel)this.testFile, Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.recordFolder.getName()}));
        Step.STEP((String)"Verify the declared record is placed in the record folder");
        Assert.assertTrue((boolean)this.isMatchingRecordInRecordFolder(this.testFile, this.recordFolder), (String)"Record should be filed to record folder");
        Step.STEP((String)"Verify the document in collaboration site is now a record");
        Assert.assertTrue((boolean)this.hasRecordAspect(this.testFile), (String)"File should have record aspect");
    }

    @Test
    public void declareAndFileToValidLocationWithSpacesUsingActionsAPI() throws Exception {
        Step.STEP((String)"Declare document as record with an encoded location parameter value");
        this.getRestAPIFactory().getActionsAPI(this.userFillingPermission).declareAndFile((RepoTestModel)this.testFile, Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{RECORD_FOLDER_NAME_WITH_SPACE}));
        Step.STEP((String)"Verify the declared record is placed in the record folder");
        Assert.assertTrue((boolean)this.isMatchingRecordInRecordFolder(this.testFile, this.recordFolderWithSpacesInName), (String)"Record should be filed to record folder");
        Step.STEP((String)"Verify the document in collaboration site is now a record");
        Assert.assertTrue((boolean)this.hasRecordAspect(this.testFile), (String)"File should have record aspect");
    }

    @Test(dataProvider="invalidDestinationPaths")
    public void declareAndFileToInvalidLocationUsingActionsAPI(String containerPath, String expectedException) throws Exception {
        Step.STEP((String)"Declare document as record with an invalid location parameter value");
        this.getRestAPIFactory().getActionsAPI().declareAndFile((RepoTestModel)this.testFile, containerPath);
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Step.STEP((String)"Check the exception thrown in alfresco logs");
        this.dockerHelper.checkExceptionIsInAlfrescoLogs(expectedException);
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileToValidLocationUsingFilesAPI() throws Exception {
        Step.STEP((String)"Declare document as record with a location parameter value");
        Record record = ((FilesAPI)this.getRestAPIFactory().getFilesAPI(this.userFillingPermission).usingParams(new String[]{String.format("%s=%s", "parentId", this.recordFolder.getId())})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Verify the declared record is placed in the record folder");
        Assert.assertEquals((String)record.getParentId(), (String)this.recordFolder.getId(), (String)"Record should be filed to record folder");
        Step.STEP((String)"Verify the document in collaboration site is now a record");
        Assert.assertTrue((boolean)this.hasRecordAspect(this.testFile), (String)"File should have record aspect");
    }

    @Test(dataProvider="invalidDestinationIds")
    public void declareAndFileToInvalidLocationUsingFilesAPI(String containerID) throws Exception {
        Step.STEP((String)"Declare document as record with an invalid location parameter value");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI().usingParams(new String[]{String.format("%s=%s", "parentId", containerID)})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary("is not valid for this endpoint. Expected nodeType is:{http://www.alfresco.org/model/recordsmanagement/1.0}recordFolder");
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileByUserWithReadOnlyPermission() throws Exception {
        Step.STEP((String)"Declare document as record with a record folder as location parameter");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI(this.userReadOnlyPermission).usingParams(new String[]{String.format("%s=%s", "parentId", this.recordFolder.getId())})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileByNonRMUser() throws Exception {
        Step.STEP((String)"Create an user with no rm rights");
        UserModel nonRMUser = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(nonRMUser, this.publicSite, UserRole.SiteCollaborator);
        Step.STEP((String)"Declare document as record with a record folder as location parameter");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI(nonRMUser).usingParams(new String[]{String.format("%s=%s", "parentId", this.recordFolder.getId())})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileToNonexistentRecordFolderUsingFilesAPI() throws Exception {
        Step.STEP((String)"Declare document as record with a nonexistent location parameter value");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI().usingParams(new String[]{String.format("%s=%s", "parentId", "nonexistent")})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileToClosedRecordFolderUsingFilesAPI() throws Exception {
        Step.STEP((String)"Declare document as record with a closed location parameter value");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI().usingParams(new String[]{String.format("%s=%s", "parentId", this.closedRecordFolder.getId())})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary(CLOSED_RECORD_FOLDER_EXC);
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileToHeldRecordFolderUsingFilesAPI() throws Exception {
        RecordCategoryChild heldRecordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"heldRecordFolder"));
        this.holdNodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), HOLD_NAME, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsAPI.addItemToHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), heldRecordFolder.getId(), HOLD_NAME);
        Step.STEP((String)"Declare document as record with a frozen location parameter value");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI().usingParams(new String[]{String.format("%s=%s", "parentId", heldRecordFolder.getId())})).declareAsRecord(this.testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
        Step.STEP((String)"Check that the file is not a record");
        Assert.assertFalse((boolean)this.hasRecordAspect(this.testFile), (String)"File should not have record aspect");
    }

    @Test
    public void declareAndFileTwiceDifferentLocations() {
        Step.STEP((String)"Create a document in the collaboration site");
        FileModel testFile = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Declare document as record with a record folder as location parameter");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI(this.userFillingPermission).usingParams(new String[]{String.format("%s=%s", "parentId", this.subcategoryRecordFolder.getId())})).declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Declare it again using a different record folder as location parameter");
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI(this.userFillingPermission).usingParams(new String[]{String.format("%s=%s", "parentId", this.recordFolder.getId())})).declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
        Step.STEP((String)"Verify the declared record is placed in the first record folder");
        Assert.assertTrue((boolean)this.isMatchingRecordInRecordFolder(testFile, this.subcategoryRecordFolder), (String)"Record should be filed to recordFolder");
        Assert.assertFalse((boolean)this.isMatchingRecordInRecordFolder(testFile, this.recordFolder), (String)"Record should not be filed to subcategoryRecordFolder");
    }

    @AfterClass(alwaysRun=true)
    public void declareAndFileDocumentAsRecordCleanup() {
        this.holdsAPI.deleteHold(this.getAdminUser(), this.holdNodeRef);
        this.deleteRecordCategory(this.recordCategory.getId());
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(this.unfiledContainerFolder.getId());
        this.dataSite.deleteSite(this.publicSite);
        this.getDataUser().deleteUser(this.userFillingPermission);
        this.getDataUser().deleteUser(this.userReadOnlyPermission);
    }
}

