/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6859")
public class AuditCreateHoldTests
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditCreateHoldTests.class);
    private final String HOLD1 = this.PREFIX + "createHold";
    private final String HOLD2 = this.PREFIX + "createHold2";
    private final String HOLD3 = this.PREFIX + "createHold3";
    private final List<String> holdsListRef = new ArrayList<String>();
    @Autowired
    private RMAuditService rmAuditService;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;
    private UserModel rmAdmin;
    private UserModel rmManager;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAuditCreateHoldTests() {
        Step.STEP((String)"Create test users.");
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        this.rmManager = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_MANAGER.roleId);
    }

    @Test
    public void createHoldEventIsAuditedForNewHold() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Create a new hold.");
        String hold1NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), this.HOLD1, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsListRef.add(hold1NodeRef);
        Step.STEP((String)"Check the audit log contains the entry for the created hold with the hold details.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.CREATE_HOLD, this.rmAdmin, this.HOLD1, Arrays.asList(ImmutableMap.of((Object)"new", (Object)"Active content to be reviewed for the CASE McDermott, FINRA ", (Object)"previous", (Object)"", (Object)"name", (Object)"Hold Reason"), ImmutableMap.of((Object)"new", (Object)this.HOLD1, (Object)"previous", (Object)"", (Object)"name", (Object)"Hold Name")));
    }

    @Test
    public void createHoldEventIsNotAuditedForExistingHold() {
        Step.STEP((String)"Create a new hold.");
        String hold2NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), this.HOLD2, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsListRef.add(hold2NodeRef);
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Try to create again the same hold and expect action to fail.");
        this.holdsAPI.createHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), this.HOLD2, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests", 500);
        Step.STEP((String)"Check the audit log doesn't contain the entry for the second create hold event.");
        AssertJUnit.assertTrue((String)"The list of events should not contain Create Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.CREATE_HOLD).isEmpty());
    }

    @Test
    public void createHoldAuditEntryIsNotLost() {
        String holdName = this.PREFIX + "holdToBeDeleted";
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Create a new hold.");
        this.holdsAPI.createHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), holdName, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        Step.STEP((String)"Get the list of audit entries for the create hold event.");
        List auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.CREATE_HOLD);
        Step.STEP((String)"Delete the created hold.");
        this.holdsAPI.deleteHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), holdName);
        Step.STEP((String)"Get again the list of audit entries for the create hold event.");
        List auditEntriesAfterDelete = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.CREATE_HOLD);
        Step.STEP((String)"Check that the audit entry for the created hold didn't change after hold deletion.");
        AssertJUnit.assertEquals((String)"The audit entry for Create Hold has been changed", (Object)auditEntries, (Object)auditEntriesAfterDelete);
    }

    @Test
    public void createHoldAuditEntryNotVisible() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Create a new hold.");
        String hold3NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), this.HOLD3, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsListRef.add(hold3NodeRef);
        Step.STEP((String)"Check that an user with no Read permissions over the hold can't see the entry for the create hold event");
        AssertJUnit.assertTrue((String)"The list of events should not contain Create Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.rmManager, AuditEvents.CREATE_HOLD).isEmpty());
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpAuditCreateHoldTests() {
        this.holdsListRef.forEach(holdRef -> this.holdsAPI.deleteHold(this.getAdminUser(), holdRef));
        Arrays.asList(this.rmAdmin, this.rmManager).forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
    }
}

