/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.core.v0.BaseAPI;
import org.apache.http.HttpResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RecordCategoriesAPI
extends BaseAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordCategoriesAPI.class);
    private static final String RM_ACTIONS_API = "{0}rma/actions/ExecutionQueue";
    private static final String DISPOSITION_ACTIONS_API = "{0}node/{1}/dispositionschedule/dispositionactiondefinitions";
    private static final String DISPOSITION_SCHEDULE_API = "{0}node/{1}/dispositionschedule";

    public HttpResponse createRetentionSchedule(String user, String password, String categoryName) {
        String catNodeRef = RecordCategoriesAPI.getNodeRefSpacesStore() + this.getItemNodeRef(user, password, "/" + categoryName);
        JSONObject requestParams = new JSONObject();
        requestParams.put("name", (Object)"createDispositionSchedule");
        requestParams.put("nodeRef", (Object)catNodeRef);
        return this.doPostJsonRequest(user, password, 200, requestParams, RM_ACTIONS_API, new String[0]);
    }

    public String getDispositionScheduleNodeRef(String user, String password, String categoryName) {
        String catNodeRef = "workspace/SpacesStore/" + this.getItemNodeRef(user, password, "/" + categoryName);
        JSONObject dispositionSchedule = this.doGetRequest(user, password, MessageFormat.format(DISPOSITION_SCHEDULE_API, "{0}", catNodeRef), new String[0]);
        return dispositionSchedule.getJSONObject("data").getString("nodeRef").replace(RecordCategoriesAPI.getNodeRefSpacesStore(), "");
    }

    public HttpResponse setRetentionScheduleGeneralFields(String user, String password, String retentionNodeRef, Map<BaseAPI.RETENTION_SCHEDULE, String> retentionProperties, Boolean appliedToRecords) {
        String dispRetentionNodeRef = "workspace/SpacesStore/" + retentionNodeRef;
        JSONObject requestParams = new JSONObject();
        requestParams.put("prop_rma_dispositionAuthority", (Object)this.getPropertyValue(retentionProperties, BaseAPI.RETENTION_SCHEDULE.RETENTION_AUTHORITY));
        requestParams.put("prop_rma_dispositionInstructions", (Object)this.getPropertyValue(retentionProperties, BaseAPI.RETENTION_SCHEDULE.RETENTION_INSTRUCTIONS));
        requestParams.put("prop_rma_recordLevelDisposition", (Object)appliedToRecords.toString());
        return this.doPostJsonRequest(user, password, 200, requestParams, MessageFormat.format("{0}node/{1}/formprocessor", "{0}", dispRetentionNodeRef), new String[0]);
    }

    public HttpResponse addDispositionScheduleSteps(String user, String password, String categoryName, Map<BaseAPI.RETENTION_SCHEDULE, String> properties) {
        String catNodeRef = "workspace/SpacesStore/" + this.getItemNodeRef(user, password, "/" + categoryName);
        JSONObject requestParams = new JSONObject();
        this.addPropertyToRequest(requestParams, "name", properties, BaseAPI.RETENTION_SCHEDULE.NAME);
        this.addPropertyToRequest(requestParams, "description", properties, BaseAPI.RETENTION_SCHEDULE.DESCRIPTION);
        this.addPropertyToRequest(requestParams, "period", properties, BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD);
        this.addPropertyToRequest(requestParams, "ghostOnDestroy", properties, BaseAPI.RETENTION_SCHEDULE.RETENTION_GHOST);
        this.addPropertyToRequest(requestParams, "periodProperty", properties, BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD_PROPERTY);
        this.addPropertyToRequest(requestParams, "location", properties, BaseAPI.RETENTION_SCHEDULE.RETENTION_LOCATION);
        String events = this.getPropertyValue(properties, BaseAPI.RETENTION_SCHEDULE.RETENTION_EVENTS);
        if (!events.equals("")) {
            requestParams.append("events", (Object)events);
        }
        this.addPropertyToRequest(requestParams, "combineDispositionStepConditions", properties, BaseAPI.RETENTION_SCHEDULE.COMBINE_DISPOSITION_STEP_CONDITIONS);
        this.addPropertyToRequest(requestParams, "eligibleOnFirstCompleteEvent", properties, BaseAPI.RETENTION_SCHEDULE.RETENTION_ELIGIBLE_FIRST_EVENT);
        return this.doPostJsonRequest(user, password, 200, requestParams, MessageFormat.format(DISPOSITION_ACTIONS_API, "{0}", catNodeRef), new String[0]);
    }

    public void deleteCategory(String username, String password, String categoryName) {
        this.deleteItem(username, password, "/" + categoryName);
    }

    public void deleteSubCategory(String username, String password, String categoryName, String subCategoryName) {
        this.deleteItem(username, password, "/" + categoryName + "/" + subCategoryName);
    }

    public void deleteFolderInContainer(String username, String password, String folderName, String containerName) {
        this.deleteItem(username, password, "/" + containerName + "/" + folderName);
    }

    public Map<BaseAPI.RETENTION_SCHEDULE, String> getRetentionProperties(String authority, String instructions) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> retentionProperties = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        retentionProperties.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_AUTHORITY, authority);
        retentionProperties.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_INSTRUCTIONS, instructions);
        return retentionProperties;
    }
}

