/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistryImpl;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.ExtendedDictionaryListener;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public abstract class CMISAbstractDictionaryService
extends AbstractLifecycleBean
implements CMISDictionaryService,
ExtendedDictionaryListener {
    protected static final Log logger = LogFactory.getLog(CMISAbstractDictionaryService.class);
    protected DictionaryDAO dictionaryDAO;
    protected DictionaryService dictionaryService;
    protected CMISMapping cmisMapping;
    protected PropertyAccessorMapping accessorMapping;
    protected PropertyLuceneBuilderMapping luceneBuilderMapping;
    protected TenantService tenantService;
    private final ReentrantReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock registryWriteLock = this.registryLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock registryReadLock = this.registryLock.readLock();
    private SimpleCache<String, CMISDictionaryRegistry> cmisRegistryCache;
    private final String KEY_OPENCMIS_DICTIONARY_REGISTRY = "key.openCmisDictionaryRegistry";

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setCmisMapping(CMISMapping cmisMapping) {
        this.cmisMapping = cmisMapping;
    }

    public void setPropertyAccessorMapping(PropertyAccessorMapping accessorMapping) {
        this.accessorMapping = accessorMapping;
    }

    public void setPropertyLuceneBuilderMapping(PropertyLuceneBuilderMapping luceneBuilderMapping) {
        this.luceneBuilderMapping = luceneBuilderMapping;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setSingletonCache(SimpleCache<String, CMISDictionaryRegistry> singletonCache) {
        this.cmisRegistryCache = singletonCache;
    }

    protected abstract DictionaryInitializer getCoreDictionaryInitializer();

    protected abstract DictionaryInitializer getTenantDictionaryInitializer();

    protected CMISDictionaryRegistry getRegistry() {
        String tenant = TenantUtil.getCurrentDomain();
        return this.getRegistry(tenant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CMISDictionaryRegistry getRegistry(String tenant) {
        CMISDictionaryRegistry cmisRegistry = null;
        String cacheKey = this.getCacheKey(tenant);
        this.registryReadLock.lock();
        try {
            cmisRegistry = this.cmisRegistryCache.get(cacheKey);
        }
        finally {
            this.registryReadLock.unlock();
        }
        if (cmisRegistry == null) {
            cmisRegistry = this.createDictionaryRegistry(tenant);
            this.registryWriteLock.lock();
            try {
                this.cmisRegistryCache.put(cacheKey, cmisRegistry);
            }
            finally {
                this.registryWriteLock.unlock();
            }
        }
        return cmisRegistry;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.afterDictionaryInit();
        if (this.dictionaryDAO != null) {
            this.dictionaryDAO.registerListener(this);
        } else {
            logger.error((Object)"DictionaryDAO is null - hence CMIS Dictionary not registered for updates");
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    private String getCacheKey() {
        String tenant = this.tenantService.getCurrentUserDomain();
        return this.getCacheKey(tenant);
    }

    private String getCacheKey(String tenant) {
        String cacheKey = "key.openCmisDictionaryRegistry." + tenant + "." + this.cmisMapping.getCmisVersion().toString();
        return cacheKey;
    }

    protected CMISDictionaryRegistry createCoreDictionaryRegistry() {
        CMISDictionaryRegistryImpl cmisRegistry = new CMISDictionaryRegistryImpl(this, this.cmisMapping, this.dictionaryService, this.getCoreDictionaryInitializer());
        cmisRegistry.init();
        return cmisRegistry;
    }

    protected CMISDictionaryRegistry createTenantDictionaryRegistry(String tenant) {
        CMISDictionaryRegistryImpl cmisRegistry = new CMISDictionaryRegistryImpl(this, tenant, "", this.cmisMapping, this.dictionaryService, this.getTenantDictionaryInitializer());
        cmisRegistry.init();
        return cmisRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMISDictionaryRegistry createDictionaryRegistryWithWriteLock() {
        String tenant = TenantUtil.getCurrentDomain();
        CMISDictionaryRegistry cmisRegistry = this.createDictionaryRegistry(tenant);
        String cacheKey = this.getCacheKey(tenant);
        this.registryWriteLock.lock();
        try {
            this.cmisRegistryCache.put(cacheKey, cmisRegistry);
        }
        finally {
            this.registryWriteLock.unlock();
        }
        return cmisRegistry;
    }

    protected CMISDictionaryRegistry createDictionaryRegistry(String tenant) {
        CMISDictionaryRegistry cmisRegistry = null;
        cmisRegistry = tenant.equals("") ? this.createCoreDictionaryRegistry() : this.createTenantDictionaryRegistry(tenant);
        return cmisRegistry;
    }

    @Override
    public TypeDefinitionWrapper findType(String typeId) {
        TypeDefinitionWrapper typeDef = this.getRegistry().getTypeDefByTypeId(typeId);
        if (typeDef != null && typeDef.getTypeDefinition(false).getDisplayName() == null) {
            typeDef.updateDefinition(this.dictionaryService);
        }
        return typeDef;
    }

    @Override
    public boolean isExcluded(QName qname) {
        return this.cmisMapping.isExcluded(qname);
    }

    @Override
    public TypeDefinitionWrapper findTypeForClass(QName clazz, BaseTypeId ... matchingScopes) {
        TypeDefinitionWrapper matchingTypeDef;
        boolean scopeByRelationship = false;
        for (BaseTypeId scope : matchingScopes) {
            if (scope != BaseTypeId.CMIS_RELATIONSHIP) continue;
            scopeByRelationship = true;
            break;
        }
        clazz = this.cmisMapping.getCmisType(clazz);
        TypeDefinitionWrapper typeDef = null;
        if (scopeByRelationship) {
            typeDef = this.getRegistry().getAssocDefByQName(clazz);
        } else {
            typeDef = this.getRegistry().getTypeDefByQName(clazz);
            if (typeDef == null) {
                typeDef = this.getRegistry().getAssocDefByQName(clazz);
            }
        }
        TypeDefinitionWrapper typeDefinitionWrapper = matchingTypeDef = matchingScopes.length == 0 ? typeDef : null;
        if (typeDef != null) {
            for (BaseTypeId scope : matchingScopes) {
                if (typeDef.getBaseTypeId() != scope) continue;
                matchingTypeDef = typeDef;
                break;
            }
        }
        return matchingTypeDef;
    }

    @Override
    public TypeDefinitionWrapper findNodeType(QName clazz) {
        return this.getRegistry().getTypeDefByQName(this.cmisMapping.getCmisType(clazz));
    }

    @Override
    public TypeDefinitionWrapper findAssocType(QName clazz) {
        return this.getRegistry().getAssocDefByQName(this.cmisMapping.getCmisType(clazz));
    }

    @Override
    public TypeDefinitionWrapper findTypeByQueryName(String queryName) {
        return this.getRegistry().getTypeDefByQueryName(ISO9075.lowerCaseEncodedSQL(queryName));
    }

    @Override
    public PropertyDefinitionWrapper findProperty(String propId) {
        return this.getRegistry().getPropDefByPropId(propId);
    }

    @Override
    public PropertyDefinitionWrapper findPropertyByQueryName(String queryName) {
        return this.getRegistry().getPropDefByQueryName(ISO9075.lowerCaseEncodedSQL(queryName));
    }

    @Override
    public List<TypeDefinitionWrapper> getBaseTypes() {
        return this.getBaseTypes(true);
    }

    @Override
    public List<TypeDefinitionWrapper> getBaseTypes(boolean includeParent) {
        List<TypeDefinitionWrapper> types = this.getRegistry().getBaseTypes(includeParent);
        for (TypeDefinitionWrapper typeDef : types) {
            if (typeDef == null || typeDef.getTypeDefinition(false).getDisplayName() != null) continue;
            typeDef.updateDefinition(this.dictionaryService);
        }
        return Collections.unmodifiableList(types);
    }

    @Override
    public List<TypeDefinitionWrapper> getAllTypes() {
        return Collections.unmodifiableList(new ArrayList<AbstractTypeDefinitionWrapper>(this.getRegistry().getTypeDefs()));
    }

    @Override
    public List<TypeDefinitionWrapper> getAllTypes(boolean includeParent) {
        return Collections.unmodifiableList(new ArrayList<AbstractTypeDefinitionWrapper>(this.getRegistry().getTypeDefs(includeParent)));
    }

    @Override
    public PropertyType findDataType(QName dataType) {
        return this.cmisMapping.getDataType(dataType);
    }

    @Override
    public QName findAlfrescoDataType(PropertyType propertyType) {
        return this.cmisMapping.getAlfrescoDataType(propertyType);
    }

    @Override
    public void onDictionaryInit() {
    }

    @Override
    public void modelAdded(CompiledModel model, String tenantDomain) {
        this.getRegistry(tenantDomain).addModel(model);
    }

    @Override
    public void afterDictionaryInit() {
        this.createDictionaryRegistryWithWriteLock();
    }

    @Override
    public void afterDictionaryDestroy() {
        this.registryWriteLock.lock();
        try {
            String cacheKey = this.getCacheKey();
            this.cmisRegistryCache.remove(cacheKey);
        }
        finally {
            this.registryWriteLock.unlock();
        }
    }

    @Override
    public List<TypeDefinitionWrapper> getChildren(String typeId) {
        List<TypeDefinitionWrapper> children = this.getRegistry().getChildren(typeId);
        for (TypeDefinitionWrapper child : children) {
            if (child == null || child.getTypeDefinition(false).getDisplayName() != null) continue;
            child.updateDefinition(this.dictionaryService);
        }
        return children;
    }

    protected static interface DictionaryInitializer {
        public Collection<AbstractTypeDefinitionWrapper> createDefinitions(CMISDictionaryRegistry var1);

        public Collection<AbstractTypeDefinitionWrapper> createDefinitions(CMISDictionaryRegistry var1, CompiledModel var2);
    }
}

