/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl;

import java.util.LinkedHashMap;
import org.alfresco.repo.search.impl.querymodel.ArgumentDefinition;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.service.namespace.QName;

public abstract class BaseFunction
implements Function {
    private String name;
    private QName returnType;
    private LinkedHashMap<String, ArgumentDefinition> argumentDefinitions;

    public BaseFunction(String name, QName returnType, LinkedHashMap<String, ArgumentDefinition> argumentDefinitions) {
        this.name = name;
        this.returnType = returnType;
        this.argumentDefinitions = argumentDefinitions;
    }

    @Override
    public LinkedHashMap<String, ArgumentDefinition> getArgumentDefinitions() {
        return this.argumentDefinitions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QName getReturnType() {
        return this.returnType;
    }

    @Override
    public ArgumentDefinition getArgumentDefinition(String name) {
        ArgumentDefinition definition = this.argumentDefinitions.get(name);
        if (definition != null) {
            return definition;
        }
        throw new IllegalArgumentException(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseFunction[");
        builder.append("Name=" + this.getName()).append(", ");
        builder.append("Return type=" + String.valueOf(this.getReturnType())).append(", ");
        builder.append("ArgumentDefinitions=" + String.valueOf(this.getArgumentDefinitions()));
        builder.append("]");
        return builder.toString();
    }
}

