/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.opencmis.dictionary.QNameFilter;
import org.alfresco.service.namespace.QName;

public class QNameFilterImpl
implements QNameFilter {
    private Map<QName, Boolean> excludedQNames;
    private Set<String> excludedModels;
    private List<String> excludedTypes;

    @Override
    public Collection<QName> filterQName(Collection<QName> typesToFilter) {
        ArrayList<QName> filteredTypes = new ArrayList();
        if (!this.excludedQNames.isEmpty() || !this.excludedModels.isEmpty()) {
            for (QName classQName : typesToFilter) {
                if (this.isExcluded(classQName)) continue;
                filteredTypes.add(classQName);
            }
        } else {
            filteredTypes = typesToFilter;
        }
        return filteredTypes;
    }

    protected void preprocessExcludedTypes(List<String> excludeTypeNames) {
        if (excludeTypeNames == null || excludeTypeNames.isEmpty()) {
            return;
        }
        HashMap<QName, Boolean> qNamesToExclude = new HashMap<QName, Boolean>();
        HashSet<String> modelsToExclude = new HashSet<String>();
        for (String typeDefinition : excludeTypeNames) {
            QName typeDef = QName.createQName(typeDefinition);
            if ("*".equals(typeDef.getLocalName())) {
                modelsToExclude.add(typeDef.getNamespaceURI());
                continue;
            }
            qNamesToExclude.put(typeDef, Boolean.TRUE);
        }
        this.excludedModels = modelsToExclude;
        this.excludedQNames = qNamesToExclude;
    }

    @Override
    public boolean isExcluded(QName typeQName) {
        Boolean isExcluded = this.excludedQNames.get(typeQName);
        return isExcluded != null && isExcluded != false || this.excludedModels.contains(typeQName.getNamespaceURI());
    }

    @Override
    public void initFilter() {
        if (this.excludedTypes == null || this.excludedTypes.isEmpty()) {
            this.excludedTypes = QNameFilterImpl.listOfHardCodedExcludedTypes();
        }
        this.preprocessExcludedTypes(this.excludedTypes);
    }

    public void setExcludedTypes(List<String> excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    public static List<String> listOfHardCodedExcludedTypes() {
        ArrayList<String> hardCodeListOfTypes = new ArrayList<String>();
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/imap/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishingworkflow/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/twitter/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/slideshare/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/facebook/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/youtube/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/linkedin/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/publishing/flickr/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/transfer/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/emailserver/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/calendar}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/blogintegration/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/linksmodel/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/datalist/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/forum/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/cloud/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/bpm/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/workflow/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/workflow/invite/moderated/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/workflow/invite/nominated/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/workflow/cloud/resetpassword/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/workflow/cloud/siteinvitation/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/workflow/signup/selfsignup/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/versionstore/2.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/versionstore/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/action/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/application/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/rule/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/rendition/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/qshare/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/sync/1.0}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/content/1.0}thumbnailed");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/content/1.0}failedThumbnailSource");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/cmis/custom}*");
        hardCodeListOfTypes.add("{http://www.alfresco.org/model/hybridworkflow/1.0}*");
        return hardCodeListOfTypes;
    }

    @Override
    public void setExcluded(QName typeQName, boolean excluded) {
        this.excludedQNames.put(typeQName, excluded);
    }
}

