/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.RelationshipTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMISDictionaryRegistryImpl
implements CMISDictionaryRegistry {
    public static final String ALFRESCO_EXTENSION_NAMESPACE = "http://www.alfresco.org";
    public static final String MANDATORY_ASPECTS = "mandatoryAspects";
    public static final String MANDATORY_ASPECT = "mandatoryAspect";
    protected static final Log logger = LogFactory.getLog(CMISDictionaryRegistryImpl.class);
    private CMISMapping cmisMapping;
    private DictionaryService dictionaryService;
    private String tenant;
    protected CMISAbstractDictionaryService cmisDictionaryService;
    private String parentTenant;
    private CMISAbstractDictionaryService.DictionaryInitializer dictionaryInitializer;
    private Map<QName, TypeDefinitionWrapper> typeDefsByQName = new HashMap<QName, TypeDefinitionWrapper>();
    private Map<QName, AbstractTypeDefinitionWrapper> assocDefsByQName = new HashMap<QName, AbstractTypeDefinitionWrapper>();
    private Map<String, AbstractTypeDefinitionWrapper> typeDefsByTypeId = new HashMap<String, AbstractTypeDefinitionWrapper>();
    private Map<String, TypeDefinitionWrapper> typeDefsByQueryName = new HashMap<String, TypeDefinitionWrapper>();
    private List<TypeDefinitionWrapper> baseTypes = new ArrayList<TypeDefinitionWrapper>();
    private Map<String, PropertyDefinitionWrapper> propDefbyPropId = new HashMap<String, PropertyDefinitionWrapper>();
    private Map<String, PropertyDefinitionWrapper> propDefbyQueryName = new HashMap<String, PropertyDefinitionWrapper>();
    private Map<String, List<TypeDefinitionWrapper>> children = new HashMap<String, List<TypeDefinitionWrapper>>();

    public CMISDictionaryRegistryImpl(CMISAbstractDictionaryService cmisDictionaryService, CMISMapping cmisMapping, DictionaryService dictionaryService, CMISAbstractDictionaryService.DictionaryInitializer dictionaryInitializer) {
        this(cmisDictionaryService, "", null, cmisMapping, dictionaryService, dictionaryInitializer);
    }

    CMISDictionaryRegistryImpl() {
    }

    public CMISDictionaryRegistryImpl(CMISAbstractDictionaryService cmisDictionaryService, String tenant, String parentTenant, CMISMapping cmisMapping, DictionaryService dictionaryService, CMISAbstractDictionaryService.DictionaryInitializer dictionaryInitializer) {
        this.cmisDictionaryService = cmisDictionaryService;
        this.tenant = tenant;
        this.parentTenant = parentTenant;
        this.cmisMapping = cmisMapping;
        this.dictionaryService = dictionaryService;
        this.dictionaryInitializer = dictionaryInitializer;
    }

    protected CMISDictionaryRegistry getParent() {
        CMISDictionaryRegistry registry = null;
        if (this.parentTenant != null) {
            return this.cmisDictionaryService.getRegistry(this.parentTenant);
        }
        return registry;
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    private List<TypeDefinitionWrapper> getChildrenImpl(String typeId) {
        return this.children.get(typeId);
    }

    @Override
    public List<TypeDefinitionWrapper> getChildren(String typeId) {
        LinkedList<TypeDefinitionWrapper> ret = new LinkedList<TypeDefinitionWrapper>();
        List<TypeDefinitionWrapper> children = this.getChildrenImpl(typeId);
        if (children != null) {
            ret.addAll(children);
        }
        if (this.getParent() != null && (children = this.getParent().getChildren(typeId)) != null) {
            ret.addAll(children);
        }
        return ret;
    }

    @Override
    public void setChildren(String typeId, List<TypeDefinitionWrapper> children) {
        this.children.put(typeId, children);
    }

    @Override
    public void addChild(String typeId, TypeDefinitionWrapper child) {
        List<TypeDefinitionWrapper> children = this.children.get(typeId);
        if (children == null) {
            children = new LinkedList<TypeDefinitionWrapper>();
            this.children.put(typeId, children);
        }
        children.add(child);
    }

    @Override
    public TypeDefinitionWrapper getTypeDefByTypeId(String typeId) {
        return this.getTypeDefByTypeId(typeId, true);
    }

    @Override
    public TypeDefinitionWrapper getTypeDefByTypeId(String typeId, boolean includeParent) {
        TypeDefinitionWrapper typeDef = this.typeDefsByTypeId.get(typeId);
        if (typeDef == null && includeParent && this.getParent() != null) {
            typeDef = this.getParent().getTypeDefByTypeId(typeId);
        }
        return typeDef;
    }

    @Override
    public TypeDefinitionWrapper getAssocDefByQName(QName qname) {
        TypeDefinitionWrapper typeDef = this.assocDefsByQName.get(qname);
        if (typeDef == null && this.getParent() != null) {
            typeDef = this.getParent().getAssocDefByQName(qname);
        }
        return typeDef;
    }

    @Override
    public TypeDefinitionWrapper getTypeDefByQueryName(Object queryName) {
        TypeDefinitionWrapper typeDef = this.typeDefsByQueryName.get(queryName);
        if (typeDef == null && this.getParent() != null) {
            typeDef = this.getParent().getTypeDefByQueryName(queryName);
        }
        return typeDef;
    }

    @Override
    public TypeDefinitionWrapper getTypeDefByQName(QName qname) {
        TypeDefinitionWrapper typeDef = this.typeDefsByQName.get(qname);
        if (typeDef == null && this.getParent() != null) {
            typeDef = this.getParent().getTypeDefByQName(qname);
        }
        return typeDef;
    }

    @Override
    public PropertyDefinitionWrapper getPropDefByPropId(String propId) {
        PropertyDefinitionWrapper propDef = this.propDefbyPropId.get(propId);
        if (propDef == null && this.getParent() != null) {
            propDef = this.getParent().getPropDefByPropId(propId);
        }
        return propDef;
    }

    @Override
    public PropertyDefinitionWrapper getPropDefByQueryName(Object queryName) {
        PropertyDefinitionWrapper propDef = this.propDefbyQueryName.get(queryName);
        if (propDef == null && this.getParent() != null) {
            propDef = this.getParent().getPropDefByQueryName(queryName);
        }
        return propDef;
    }

    private Collection<AbstractTypeDefinitionWrapper> getTypeDefsImpl() {
        return this.typeDefsByTypeId.values();
    }

    @Override
    public Collection<AbstractTypeDefinitionWrapper> getTypeDefs() {
        return this.getTypeDefs(true);
    }

    @Override
    public Collection<AbstractTypeDefinitionWrapper> getTypeDefs(boolean includeParent) {
        LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
        ret.addAll(this.getTypeDefsImpl());
        if (includeParent && this.getParent() != null) {
            ret.addAll(this.getParent().getTypeDefs());
        }
        return Collections.unmodifiableCollection(ret);
    }

    private Collection<AbstractTypeDefinitionWrapper> getAssocDefsImpl() {
        return this.assocDefsByQName.values();
    }

    @Override
    public Collection<AbstractTypeDefinitionWrapper> getAssocDefs() {
        return this.getAssocDefs(true);
    }

    @Override
    public Collection<AbstractTypeDefinitionWrapper> getAssocDefs(boolean includeParent) {
        LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
        ret.addAll(this.getAssocDefsImpl());
        if (includeParent && this.getParent() != null) {
            ret.addAll(this.getParent().getAssocDefs());
        }
        return Collections.unmodifiableCollection(ret);
    }

    private void addTypeExtensions(TypeDefinitionWrapper td) {
        List<AspectDefinition> defaultAspects;
        QName classQName = td.getAlfrescoClass();
        ClassDefinition classDef = this.dictionaryService.getClass(classQName);
        if (classDef != null && (defaultAspects = classDef.getDefaultAspects(true)) != null && defaultAspects.size() > 0) {
            ArrayList<CmisExtensionElementImpl> mandatoryAspectsExtensions = new ArrayList<CmisExtensionElementImpl>();
            for (AspectDefinition aspectDef : defaultAspects) {
                QName aspectQName = aspectDef.getName();
                TypeDefinitionWrapper aspectType = this.getTypeDefByQName(this.cmisMapping.getCmisType(aspectQName));
                if (aspectType == null) continue;
                mandatoryAspectsExtensions.add(new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, MANDATORY_ASPECT, null, aspectType.getTypeId()));
            }
            if (!mandatoryAspectsExtensions.isEmpty()) {
                td.getTypeDefinition(true).setExtensions(Collections.singletonList(new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, MANDATORY_ASPECTS, null, mandatoryAspectsExtensions)));
            }
        }
    }

    @Override
    public void addModel(CompiledModel model) {
        Collection<AbstractTypeDefinitionWrapper> types = this.dictionaryInitializer.createDefinitions(this, model);
        this.addTypes(types);
        for (AbstractTypeDefinitionWrapper type : types) {
            type.resolveInheritance(this.cmisMapping, this, this.dictionaryService);
        }
    }

    @Override
    public void updateModel(CompiledModel model) {
    }

    @Override
    public void removeModel(CompiledModel model) {
    }

    private void clear() {
        this.typeDefsByQName.clear();
        this.assocDefsByQName.clear();
        this.typeDefsByTypeId.clear();
        this.typeDefsByQueryName.clear();
        this.baseTypes.clear();
        this.propDefbyPropId.clear();
        this.propDefbyQueryName.clear();
        this.children.clear();
    }

    private void addTypes(Collection<AbstractTypeDefinitionWrapper> types) {
        for (AbstractTypeDefinitionWrapper objectTypeDef : types) {
            List<TypeDefinitionWrapper> children = objectTypeDef.connectParentAndSubTypes(this.cmisMapping, this, this.dictionaryService);
            this.setChildren(objectTypeDef.getTypeId(), children);
        }
        for (AbstractTypeDefinitionWrapper typeDef : types) {
            if (typeDef.getTypeDefinition(false).getParentTypeId() != null && this.tenant.equals("")) continue;
            if (this.tenant.equals("")) {
                this.baseTypes.add(typeDef);
            }
            typeDef.resolveInheritance(this.cmisMapping, this, this.dictionaryService);
        }
        for (AbstractTypeDefinitionWrapper typeDef : types) {
            this.registerPropertyDefinitions(typeDef);
        }
        for (AbstractTypeDefinitionWrapper typeDef : types) {
            typeDef.assertComplete();
            this.addTypeExtensions(typeDef);
        }
    }

    public void init() {
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating type definitions...");
        }
        Collection<AbstractTypeDefinitionWrapper> types = this.dictionaryInitializer.createDefinitions(this);
        this.addTypes(types);
        long end = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Initialized CMIS Dictionary " + String.valueOf(this.cmisMapping.getCmisVersion()) + " tenant " + this.tenant + " in " + (end - start) + "ms. Types:" + this.typeDefsByTypeId.size() + ", Base Types:" + this.baseTypes.size()));
        }
    }

    private List<TypeDefinitionWrapper> getBaseTypesImpl() {
        return this.baseTypes;
    }

    @Override
    public List<TypeDefinitionWrapper> getBaseTypes() {
        return this.getBaseTypes(true);
    }

    @Override
    public List<TypeDefinitionWrapper> getBaseTypes(boolean includeParent) {
        LinkedList<TypeDefinitionWrapper> ret = new LinkedList<TypeDefinitionWrapper>();
        List<TypeDefinitionWrapper> baseTypes = this.getBaseTypesImpl();
        if (baseTypes != null) {
            ret.addAll(baseTypes);
        }
        if (includeParent && this.getParent() != null && (baseTypes = this.getParent().getBaseTypes()) != null) {
            ret.addAll(baseTypes);
        }
        return Collections.unmodifiableList(ret);
    }

    @Override
    public void registerTypeDefinition(AbstractTypeDefinitionWrapper typeDef) {
        TypeDefinitionWrapper existingTypeDef = this.typeDefsByTypeId.get(typeDef.getTypeId());
        if (existingTypeDef != null && logger.isWarnEnabled()) {
            logger.warn((Object)("Type " + typeDef.getTypeId() + " already registered"));
        }
        this.typeDefsByTypeId.put(typeDef.getTypeId(), typeDef);
        QName typeQName = typeDef.getAlfrescoName();
        if (typeQName != null) {
            if (typeDef instanceof RelationshipTypeDefintionWrapper && !typeDef.isBaseType()) {
                this.assocDefsByQName.put(typeQName, typeDef);
            } else {
                this.typeDefsByQName.put(typeQName, typeDef);
            }
        }
        this.typeDefsByQueryName.put(typeDef.getTypeDefinition(false).getQueryName(), typeDef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered type " + typeDef.getTypeId() + " (scope=" + String.valueOf(typeDef.getBaseTypeId()) + ")"));
            logger.debug((Object)(" QName: " + String.valueOf(typeDef.getAlfrescoName())));
            logger.debug((Object)(" Table: " + typeDef.getTypeDefinition(false).getQueryName()));
            logger.debug((Object)(" Action Evaluators: " + typeDef.getActionEvaluators().size()));
        }
    }

    public void registerPropertyDefinitions(AbstractTypeDefinitionWrapper typeDef) {
        for (PropertyDefinitionWrapper propDef : typeDef.getProperties(false)) {
            if (propDef.getPropertyDefinition().isInherited().booleanValue()) continue;
            this.propDefbyPropId.put(propDef.getPropertyId(), propDef);
            this.propDefbyQueryName.put(propDef.getPropertyDefinition().getQueryName(), propDef);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DictionaryRegistry[");
        builder.append("Types=").append(this.typeDefsByTypeId.size()).append(", ");
        builder.append("Base Types=").append(this.baseTypes.size()).append(", ");
        builder.append("]");
        return builder.toString();
    }
}

