/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.AbstractModelTest;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class DiffModelTest
extends AbstractModelTest {
    public static final String MODEL1_DUPLICATED_XML = "<model name=\"test1:model11\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>";

    public void testDeleteModel() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>           <property name=\"test1:prop6\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:text</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, null);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"deleted"), 3, new Pair((Object)"ASPECT", (Object)"deleted"), 3);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNoExistingModelToDelete() {
        try {
            List modelDiffs = this.dictionaryDAO.diffModel(null, null);
            DiffModelTest.assertTrue((String)"Should throw exeception that there is no previous version of the model to delete", (boolean)true);
        }
        catch (AlfrescoRuntimeException e) {
            DiffModelTest.assertTrue((String)"Wrong error message", (boolean)e.getMessage().equals("Invalid arguments - no previous version of model to delete"));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>           <property name=\"test1:prop6\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:text</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel compiledModel = this.dictionaryDAO.getCompiledModel(modelName);
        try {
            List modelDiffs = this.dictionaryDAO.diffModel(null, compiledModel);
            DiffModelTest.assertTrue((String)"Should throw exeception that there is no previous version of the model to delete", (boolean)true);
        }
        catch (AlfrescoRuntimeException e) {
            DiffModelTest.assertTrue((String)"Wrong error message", (boolean)e.getMessage().equals("Invalid arguments - no previous version of model to delete"));
        }
    }

    public void testNewModel() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>           <property name=\"test1:prop6\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:text</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(null, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"created"), 3, new Pair((Object)"ASPECT", (Object)"created"), 3);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testDuplicateModels() {
        ByteArrayInputStream byteArrayInputStream1 = new ByteArrayInputStream("<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>           <property name=\"test1:prop6\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:text</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(MODEL1_DUPLICATED_XML.getBytes());
        M2Model model1 = M2Model.createModel((InputStream)byteArrayInputStream1);
        this.dictionaryDAO.putModel(model1);
        M2Model model2 = M2Model.createModel((InputStream)byteArrayInputStream2);
        try {
            this.dictionaryDAO.putModel(model2);
            DiffModelTest.fail((String)"This model with this URI has already been defined");
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void testNonIncUpdateModel() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>           <property name=\"test1:prop6\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:text</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model1\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type3\">        <title>Base</title>        <description>The Base Type 3</description>        <properties>           <property name=\"test1:prop5\">              <type>d:text</type>           </property>        </properties>      </type>      <type name=\"test1:type4\">        <title>Base</title>        <description>The Base Type 4</description>        <properties>           <property name=\"test1:prop7\">              <type>d:text</type>           </property>           <property name=\"test1:prop8\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect3\">        <title>Base</title>        <description>The Base Aspect 3</description>        <properties>           <property name=\"test1:prop13\">              <type>d:int</type>           </property>           <property name=\"test1:prop14\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect4\">        <title>Base</title>        <description>The Base Aspect 4</description>        <properties>           <property name=\"test1:prop15\">              <type>d:text</type>           </property>           <property name=\"test1:prop16\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"created"), 1, new Pair((Object)"TYPE", (Object)"unchanged"), 2, new Pair((Object)"TYPE", (Object)"deleted"), 1, new Pair((Object)"ASPECT", (Object)"created"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 2, new Pair((Object)"ASPECT", (Object)"deleted"), 1, new Pair((Object)"PROPERTY", (Object)"unchanged"), 6, new Pair((Object)"PROPERTY", (Object)"updated"), 1, new Pair((Object)"PROPERTY", (Object)"deleted"), 1);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testIncUpdatePropertiesAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model2\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model2\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>           <property name=\"test1:prop3\">              <type>d:date</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop11\">              <type>d:boolean</type>           </property>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"unchanged"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"PROPERTY", (Object)"unchanged"), 4, new Pair((Object)"PROPERTY", (Object)"created"), 2);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testIncUpdateTypesAndAspectsAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model3\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model3\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"unchanged"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"TYPE", (Object)"created"), 1, new Pair((Object)"ASPECT", (Object)"created"), 1, new Pair((Object)"PROPERTY", (Object)"unchanged"), 4);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testIncUpdateAssociationsAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model5\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model5\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>        <associations>           <child-association name=\"test1:assoc1\">               <source>                   <mandatory>false</mandatory>                   <many>false</many>               </source>               <target>                   <class>test1:type2</class>                   <mandatory>false</mandatory>                   <many>false</many>               </target>           </child-association>        </associations>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>        <associations>           <association name=\"test1:assoc2\">               <source>                   <role>test1:role1</role>                   <mandatory>false</mandatory>                   <many>true</many>               </source>               <target>                   <class>test1:aspect2</class>                   <role>test1:role2</role>                   <mandatory>false</mandatory>                   <many>true</many>               </target>           </association>        </associations>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"updated_inc"), 1, new Pair((Object)"TYPE", (Object)"unchanged"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 2, new Pair((Object)"PROPERTY", (Object)"unchanged"), 6, new Pair((Object)"ASSOCIATION", (Object)"created"), 2);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testIncUpdateTitleDescription() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model6\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Type1 Title</title>        <description>Type1 Description</description>        <properties>           <property name=\"test1:prop1\">              <title>Prop1 Title</title>              <description>Prop1 Description</description>              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Aspect1 Title</title>        <description>Aspect1 Description</description>        <properties>           <property name=\"test1:prop9\">              <title>Prop9 Title</title>              <description>Prop9 Description</description>              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model6\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description - UPDATE1</description>   <author>Alfresco - UPDATE1</author>   <published>2009-08-01</published>   <version>2.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Type1 Title - UPDATE1</title>        <description>Type1 Description - UPDATE1</description>        <properties>           <property name=\"test1:prop1\">              <title>Prop1 Title - UPDATE1</title>              <description>Prop1 Description - UPDATE1</description>              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Aspect1 Title</title>        <description>Aspect1 Description</description>        <properties>           <property name=\"test1:prop9\">              <title>Prop9 Title - UPDATE1</title>              <description>Prop9 Description - UPDATE1</description>              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"updated_inc"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"PROPERTY", (Object)"updated_inc"), 2);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNonIncUpdatePropertiesRemoved() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model2\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>           <property name=\"test1:prop3\">              <type>d:date</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop11\">              <type>d:boolean</type>           </property>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model2\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"unchanged"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"PROPERTY", (Object)"unchanged"), 4, new Pair((Object)"PROPERTY", (Object)"deleted"), 2);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNonIncUpdateTypesAndAspectsRemoved() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model3\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model3\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>           <property name=\"test1:prop2\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>           <property name=\"test1:prop10\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"unchanged"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"TYPE", (Object)"deleted"), 1, new Pair((Object)"ASPECT", (Object)"deleted"), 1, new Pair((Object)"PROPERTY", (Object)"unchanged"), 4);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNonIncUpdateDefaultAspectAdded() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model4\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model4\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>        <mandatory-aspects>           <aspect>test1:aspect1</aspect>        </mandatory-aspects>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"updated"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"PROPERTY", (Object)"unchanged"), 2);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNonIncUpdateAssociationsRemoved() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model5\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>        <associations>           <child-association name=\"test1:assoc1\">               <source>                   <mandatory>false</mandatory>                   <many>false</many>               </source>               <target>                   <class>test1:type2</class>                   <mandatory>false</mandatory>                   <many>false</many>               </target>           </child-association>        </associations>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>        <associations>           <association name=\"test1:assoc2\">               <source>                   <role>test1:role1</role>                   <mandatory>false</mandatory>                   <many>true</many>               </source>               <target>                   <class>test1:aspect2</class>                   <role>test1:role2</role>                   <mandatory>false</mandatory>                   <many>true</many>               </target>           </association>        </associations>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model5\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description</description>   <author>Alfresco</author>   <published>2007-08-01</published>   <version>1.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Base</title>        <description>The Base Type 1</description>        <properties>           <property name=\"test1:prop1\">              <type>d:text</type>           </property>        </properties>      </type>      <type name=\"test1:type2\">        <title>Base</title>        <description>The Base Type 2</description>        <properties>           <property name=\"test1:prop3\">              <type>d:text</type>           </property>           <property name=\"test1:prop4\">              <type>d:int</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Base</title>        <description>The Base Aspect 1</description>        <properties>           <property name=\"test1:prop9\">              <type>d:text</type>           </property>        </properties>      </aspect>      <aspect name=\"test1:aspect2\">        <title>Base</title>        <description>The Base Aspect 2</description>        <properties>           <property name=\"test1:prop11\">              <type>d:text</type>           </property>           <property name=\"test1:prop12\">              <type>d:int</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"TYPE", (Object)"updated"), 1, new Pair((Object)"TYPE", (Object)"unchanged"), 1, new Pair((Object)"ASPECT", (Object)"unchanged"), 2, new Pair((Object)"PROPERTY", (Object)"unchanged"), 6, new Pair((Object)"ASSOCIATION", (Object)"deleted"), 2);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testIncUpdatePropertiesAddedToMandatoryAspect() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test7:model7\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test7/1.0\" prefix=\"test7\"/>   </namespaces>   <aspects>      <aspect name=\"test7:aspectA\">      </aspect>      <aspect name=\"test7:aspectB\">         <mandatory-aspects>             <aspect>test7:aspectA</aspect>          </mandatory-aspects>       </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test7:model7\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test7/1.0\" prefix=\"test7\"/>   </namespaces>   <aspects>      <aspect name=\"test7:aspectA\">         <properties>             <property name=\"test7:propA1\">                <title>Prop A1</title>                <type>d:text</type>             </property>          </properties>       </aspect>      <aspect name=\"test7:aspectB\">         <mandatory-aspects>             <aspect>test7:aspectA</aspect>          </mandatory-aspects>       </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"ASPECT", (Object)"unchanged"), 2, new Pair((Object)"PROPERTY", (Object)"created"), 1);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNonIncUpdatePropertiesRemovedFromMandatoryAspect() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test7:model7\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test7/1.0\" prefix=\"test7\"/>   </namespaces>   <aspects>      <aspect name=\"test7:aspectA\">         <properties>             <property name=\"test7:propA1\">                <title>Prop A1</title>                <type>d:text</type>             </property>          </properties>       </aspect>      <aspect name=\"test7:aspectB\">         <mandatory-aspects>             <aspect>test7:aspectA</aspect>          </mandatory-aspects>       </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test7:model7\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test7/1.0\" prefix=\"test7\"/>   </namespaces>   <aspects>      <aspect name=\"test7:aspectA\">      </aspect>      <aspect name=\"test7:aspectB\">         <mandatory-aspects>             <aspect>test7:aspectA</aspect>          </mandatory-aspects>       </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"ASPECT", (Object)"unchanged"), 2, new Pair((Object)"PROPERTY", (Object)"deleted"), 1);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testIncChangeMandatoryProperties() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test8:model8\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test8/1.0\" prefix=\"test8\"/>   </namespaces>   <aspects>      <aspect name=\"test8:aspectA\">         <properties>             <property name=\"test8:propA1\">                <title>Prop A1</title>                <type>d:text</type>                <mandatory enforced=\"true\" protected =\"true\">true</mandatory>             </property>          </properties>       </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test8:model8\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test8/1.0\" prefix=\"test8\"/>   </namespaces>   <aspects>      <aspect name=\"test8:aspectA\">         <properties>             <property name=\"test8:propA1\">                <title>Prop A1</title>                <type>d:text</type>                <mandatory>false</mandatory>             </property>          </properties>       </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"PROPERTY", (Object)"updated_inc"), 1);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    public void testNonIncChangeMandatoryProperties() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test8:model8\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test8/1.0\" prefix=\"test8\"/>   </namespaces>   <aspects>      <aspect name=\"test8:aspectA\">         <properties>             <property name=\"test8:propA1\">                <title>Prop A1</title>                <type>d:text</type>                <mandatory>false</mandatory>             </property>          </properties>       </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        CompiledModel previousVersion = this.dictionaryDAO.getCompiledModel(modelName);
        byteArrayInputStream = new ByteArrayInputStream("<model name=\"test8:model8\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test8/1.0\" prefix=\"test8\"/>   </namespaces>   <aspects>      <aspect name=\"test8:aspectA\">         <properties>             <property name=\"test8:propA1\">                <title>Prop A1</title>                <type>d:text</type>                <mandatory enforced=\"true\" protected =\"true\">true</mandatory>             </property>          </properties>       </aspect>   </aspects></model>".getBytes());
        model = M2Model.createModel((InputStream)byteArrayInputStream);
        modelName = this.dictionaryDAO.putModel(model);
        CompiledModel newVersion = this.dictionaryDAO.getCompiledModel(modelName);
        List modelDiffs = this.dictionaryDAO.diffModel(previousVersion, newVersion);
        Map<Pair, Integer> expected = Map.of(new Pair((Object)"ASPECT", (Object)"unchanged"), 1, new Pair((Object)"PROPERTY", (Object)"updated"), 1);
        DiffModelTest.assertEquals((String)"Unexpected set of diffs found.", expected, this.getAllDiffCounts(modelDiffs));
    }

    private Map<Pair<String, String>, Integer> getAllDiffCounts(List<M2ModelDiff> m2ModelDiffs) {
        return m2ModelDiffs.stream().map(modelDiff -> new Pair((Object)modelDiff.getElementType(), (Object)modelDiff.getDiffType())).collect(Collectors.toMap(Function.identity(), pair -> 1, Integer::sum));
    }
}

