/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import junit.framework.TestCase;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

public class QNamePatternTest
extends TestCase {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/QNamePatternTest";
    QName check1;
    QName check2;
    QName check3;

    public QNamePatternTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.check1 = QName.createQName(null, (String)"ABC");
        this.check2 = QName.createQName((String)TEST_NAMESPACE, (String)"XYZ");
        this.check3 = QName.createQName((String)TEST_NAMESPACE, (String)"ABC");
    }

    public void testSimpleQNamePattern() throws Exception {
        QName pattern = QName.createQName((String)TEST_NAMESPACE, (String)"ABC");
        QNamePatternTest.assertFalse((String)("Simple match failed: " + String.valueOf(this.check1)), (boolean)pattern.isMatch(this.check1));
        QNamePatternTest.assertFalse((String)("Simple match failed: " + String.valueOf(this.check2)), (boolean)pattern.isMatch(this.check2));
        QNamePatternTest.assertTrue((String)("Simple match failed: " + String.valueOf(this.check3)), (boolean)pattern.isMatch(this.check3));
    }

    public void testRegexQNamePatternMatcher() throws Exception {
        RegexQNamePattern pattern = new RegexQNamePattern(".*alfresco.*", "A.?C");
        QNamePatternTest.assertFalse((String)("Regex match failed: " + String.valueOf(this.check1)), (boolean)pattern.isMatch(this.check1));
        QNamePatternTest.assertFalse((String)("Regex match failed: " + String.valueOf(this.check2)), (boolean)pattern.isMatch(this.check2));
        QNamePatternTest.assertTrue((String)("Regex match failed: " + String.valueOf(this.check3)), (boolean)pattern.isMatch(this.check3));
        QNamePatternTest.assertTrue((String)("All match failed: " + String.valueOf(this.check1)), (boolean)RegexQNamePattern.MATCH_ALL.isMatch(this.check1));
        QNamePatternTest.assertTrue((String)("All match failed: " + String.valueOf(this.check2)), (boolean)RegexQNamePattern.MATCH_ALL.isMatch(this.check2));
        QNamePatternTest.assertTrue((String)("All match failed: " + String.valueOf(this.check3)), (boolean)RegexQNamePattern.MATCH_ALL.isMatch(this.check3));
    }
}

