/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.BasicSearchParameters;
import org.alfresco.service.cmr.search.SearchParameters;

public class SearchSQLParameters
implements BasicSearchParameters {
    private final String language;
    private final String query;
    private List<StoreRef> stores = new ArrayList<StoreRef>();
    private List<Locale> locales = new ArrayList<Locale>();
    private boolean includeMetadata;

    public SearchSQLParameters(String query, String language, List<Locale> locales, boolean includeMetadata) {
        this.query = query;
        this.language = language;
        this.locales = locales;
        this.includeMetadata = includeMetadata;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<StoreRef> getStores() {
        return this.stores;
    }

    @Override
    public List<Locale> getLocales() {
        return this.locales;
    }

    @Override
    public List<SearchParameters.SortDefinition> getSortDefinitions() {
        return null;
    }

    public void addStore(StoreRef store) {
        this.stores.add(store);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchParameters [language=").append(this.language).append(", query=").append(this.query).append(", stores=").append(this.stores).append(", locales=").append(this.locales).append("]");
        return builder.toString();
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }
}

