/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.opencmis.mapping.AbstractSimpleLuceneBuilder;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class DirectLuceneBuilder
extends AbstractSimpleLuceneBuilder {
    private DictionaryService dictionaryService;
    private QName alfrescoName;

    public DirectLuceneBuilder(DictionaryService dictionaryService, QName alfrescoName) {
        this.dictionaryService = dictionaryService;
        this.alfrescoName = alfrescoName;
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa) throws E {
        String field = this.getLuceneFieldName();
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(QName.createQName(field.substring(1)));
        if (propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            throw new CmisInvalidArgumentException("Order on content properties is not curently supported");
        }
        if (propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT) || propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            field = lqpa.getSortField(field);
        } else if (propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
            field = lqpa.getDatetimeSortField(field, propertyDef);
        }
        return field;
    }

    @Override
    public String getLuceneFieldName() {
        StringBuilder field = new StringBuilder(64);
        field.append("@");
        field.append(this.alfrescoName);
        return field.toString();
    }

    @Override
    protected String getValueAsString(Serializable value) {
        PropertyDefinition pd = this.dictionaryService.getProperty(this.alfrescoName);
        Object converted = DefaultTypeConverter.INSTANCE.convert(pd.getDataType(), (Object)value);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    protected QName getQNameForExists() {
        return this.alfrescoName;
    }

    @Override
    protected DataTypeDefinition getInDataType() {
        PropertyDefinition pd = this.dictionaryService.getProperty(this.alfrescoName);
        return pd.getDataType();
    }

    @Override
    protected String getRangeMax() {
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATE)) {
            return "MAX";
        }
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATETIME)) {
            return "MAX";
        }
        return super.getRangeMax();
    }

    @Override
    protected String getRangeMin() {
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATE)) {
            return "MIN";
        }
        if (this.getInDataType().getName().equals(DataTypeDefinition.DATETIME)) {
            return "MIN";
        }
        return super.getRangeMin();
    }
}

