/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;

public class RelationshipTypeDefintionWrapper
extends AbstractTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    private RelationshipTypeDefinitionImpl typeDef;
    private RelationshipTypeDefinitionImpl typeDefInclProperties;
    private DictionaryService dictionaryService;

    public RelationshipTypeDefintionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, DictionaryService dictionaryService, ClassDefinition cmisClassDef) {
        this.dictionaryService = dictionaryService;
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new RelationshipTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
            this.typeDef.setIsCreatable(Boolean.valueOf(false));
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            this.typeDef.setParentTypeId(BaseTypeId.CMIS_RELATIONSHIP.value());
            this.typeDef.setIsCreatable(Boolean.valueOf(true));
        }
        this.typeDef.setDisplayName(null);
        this.typeDef.setDescription(null);
        this.typeDef.setIsQueryable(Boolean.valueOf(false));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(false));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(false));
        this.typeDef.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        this.typeDef.setIsFileable(Boolean.valueOf(false));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, accessorMapping, luceneBuilderMapping, dictionaryService, cmisClassDef);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_RELATIONSHIP);
    }

    public RelationshipTypeDefintionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, DictionaryService dictionaryService, AssociationDefinition cmisAssocDef) {
        this.dictionaryService = dictionaryService;
        this.alfrescoName = cmisAssocDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new RelationshipTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        this.typeDef.setQueryName(cmisMapping.buildPrefixEncodedString(this.alfrescoName));
        this.typeDef.setParentTypeId(BaseTypeId.CMIS_RELATIONSHIP.value());
        this.typeDef.setDisplayName(null);
        this.typeDef.setDescription(null);
        this.typeDef.setIsCreatable(Boolean.valueOf(true));
        this.typeDef.setIsQueryable(Boolean.valueOf(false));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(false));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(false));
        this.typeDef.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        this.typeDef.setIsFileable(Boolean.valueOf(false));
        ArrayList<String> both = new ArrayList<String>(2);
        both.add(BaseTypeId.CMIS_DOCUMENT.value());
        both.add(BaseTypeId.CMIS_FOLDER.value());
        String sourceTypeId = cmisMapping.getCmisTypeId(cmisMapping.getCmisType(cmisAssocDef.getSourceClass().getName()));
        if (sourceTypeId != null) {
            this.typeDef.setAllowedSourceTypes(Collections.singletonList(sourceTypeId));
        } else {
            this.typeDef.setAllowedSourceTypes(both);
        }
        String targetTypeId = cmisMapping.getCmisTypeId(cmisMapping.getCmisType(cmisAssocDef.getTargetClass().getName()));
        if (targetTypeId != null) {
            this.typeDef.setAllowedTargetTypes(Collections.singletonList(targetTypeId));
        } else {
            this.typeDef.setAllowedTargetTypes(both);
        }
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_RELATIONSHIP);
    }

    @Override
    public List<TypeDefinitionWrapper> connectParentAndSubTypes(CMISMapping cmisMapping, CMISDictionaryRegistry registry, DictionaryService dictionaryService) {
        String parentTypeId = this.typeDef.getParentTypeId();
        if (parentTypeId != null) {
            this.parent = registry.getTypeDefByTypeId(parentTypeId);
            if (registry.getTenant() != null && this.parent != null && registry.getTypeDefByTypeId(parentTypeId, false) == null) {
                registry.addChild(this.parent.getTypeId(), this);
            }
        } else {
            if (!this.isBaseType()) {
                throw new AlfrescoRuntimeException("Type " + this.typeDef.getId() + " has no parent!");
            }
            this.parent = null;
        }
        LinkedList<TypeDefinitionWrapper> children = new LinkedList<TypeDefinitionWrapper>();
        if (this.isBaseType()) {
            for (TypeDefinitionWrapper typeDefinitionWrapper : registry.getAssocDefs()) {
                children.add(typeDefinitionWrapper);
            }
        }
        return children;
    }

    @Override
    public void resolveInheritance(CMISMapping cmisMapping, CMISDictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.parent != null) {
            for (PropertyDefinitionWrapper propDef : this.parent.getProperties(false)) {
                PropertyDefinition alfrescoPropDef = dictionaryService.getProperty(propDef.getOwningType().getAlfrescoName(), propDef.getAlfrescoName());
                org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition<?> propertyDefintion = this.createPropertyDefinition(cmisMapping, propDef.getPropertyId(), alfrescoPropDef.getName(), dictionaryService, alfrescoPropDef, true);
                if (propertyDefintion == null) continue;
                this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), propDef.getOwningType(), propDef.getPropertyAccessor(), propDef.getPropertyLuceneBuilder()));
            }
        }
        List<TypeDefinitionWrapper> children = registry.getChildren(this.typeDef.getId());
        for (TypeDefinitionWrapper child : children) {
            if (!(child instanceof AbstractTypeDefinitionWrapper)) continue;
            ((AbstractTypeDefinitionWrapper)child).resolveInheritance(cmisMapping, registry, dictionaryService);
        }
    }

    @Override
    public void updateDefinition(DictionaryService dictionaryService) {
        AssociationDefinition assocDef = dictionaryService.getAssociation(this.alfrescoName);
        if (assocDef != null) {
            this.setTypeDefDisplayName(assocDef.getTitle(dictionaryService));
            this.setTypeDefDescription(assocDef.getDescription(dictionaryService));
        } else {
            super.updateDefinition(dictionaryService);
        }
        this.updateTypeDefInclProperties();
    }

    @Override
    public PropertyDefinitionWrapper getPropertyById(String propertyId) {
        this.updateProperty(this.dictionaryService, (PropertyDefinitionWrapper)this.propertiesById.get(propertyId));
        return (PropertyDefinitionWrapper)this.propertiesById.get(propertyId);
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties() {
        this.updateProperties(this.dictionaryService);
        return this.propertiesById.values();
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties(boolean update) {
        if (update) {
            return this.getProperties();
        }
        return this.propertiesById.values();
    }
}

