/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.alfresco.repo.cache.SimpleCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SimpleCacheTestBase<T extends SimpleCache<Integer, String>> {
    protected T cache;

    @Before
    public void setUp() throws Exception {
        this.cache = this.createCache();
    }

    protected abstract T createCache();

    @Test
    public void canStoreNullValues() {
        this.cache.put((Serializable)Integer.valueOf(2), null);
        Assert.assertEquals(null, (Object)this.cache.get((Serializable)Integer.valueOf(2)));
        Assert.assertTrue((boolean)this.cache.contains((Serializable)Integer.valueOf(2)));
        Assert.assertEquals(null, (Object)this.cache.get((Serializable)Integer.valueOf(4)));
        Assert.assertFalse((boolean)this.cache.contains((Serializable)Integer.valueOf(4)));
    }

    @Test
    public void canRemoveItems() {
        this.cache.put((Serializable)Integer.valueOf(1), (Object)"hello");
        this.cache.put((Serializable)Integer.valueOf(2), (Object)"world");
        Assert.assertEquals((Object)"hello", (Object)this.cache.get((Serializable)Integer.valueOf(1)));
        Assert.assertEquals((Object)"world", (Object)this.cache.get((Serializable)Integer.valueOf(2)));
        this.cache.remove((Serializable)Integer.valueOf(2));
        Assert.assertEquals((Object)"hello", (Object)this.cache.get((Serializable)Integer.valueOf(1)));
        Assert.assertEquals(null, (Object)this.cache.get((Serializable)Integer.valueOf(2)));
        Assert.assertEquals((Object)false, (Object)this.cache.contains((Serializable)Integer.valueOf(2)));
    }

    @Test
    public void canClearItems() {
        this.cache.put((Serializable)Integer.valueOf(1), (Object)"hello");
        this.cache.put((Serializable)Integer.valueOf(2), (Object)"world");
        Assert.assertEquals((Object)"hello", (Object)this.cache.get((Serializable)Integer.valueOf(1)));
        Assert.assertEquals((Object)"world", (Object)this.cache.get((Serializable)Integer.valueOf(2)));
        this.cache.clear();
        Assert.assertEquals(null, (Object)this.cache.get((Serializable)Integer.valueOf(1)));
        Assert.assertEquals((Object)false, (Object)this.cache.contains((Serializable)Integer.valueOf(1)));
        Assert.assertEquals(null, (Object)this.cache.get((Serializable)Integer.valueOf(2)));
        Assert.assertEquals((Object)false, (Object)this.cache.contains((Serializable)Integer.valueOf(2)));
    }

    @Test
    public void canGetKeys() {
        this.cache.put((Serializable)Integer.valueOf(3), (Object)"blue");
        this.cache.put((Serializable)Integer.valueOf(12), (Object)"red");
        this.cache.put((Serializable)Integer.valueOf(43), (Object)"olive");
        ArrayList keys = new ArrayList(this.cache.getKeys());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        Assert.assertEquals((long)3L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)it.next()).intValue());
        Assert.assertEquals((long)43L, (long)((Integer)it.next()).intValue());
        Assert.assertFalse((String)"There should be no more keys.", (boolean)it.hasNext());
    }

    @Test
    public void noConcurrentModificationException() {
        this.cache.put((Serializable)Integer.valueOf(1), (Object)"1");
        this.cache.put((Serializable)Integer.valueOf(2), (Object)"2");
        this.cache.put((Serializable)Integer.valueOf(3), (Object)"3");
        this.cache.put((Serializable)Integer.valueOf(4), (Object)"4");
        Iterator i = this.cache.getKeys().iterator();
        i.next();
        i.next();
        this.cache.put((Serializable)Integer.valueOf(5), (Object)"5");
        i.next();
    }
}

