/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;

public class StringLengthConstraint
extends AbstractConstraint {
    private static final String ERR_INVALID_MIN_LENGTH = "d_dictionary.constraint.string_length.invalid_min_length";
    private static final String ERR_INVALID_MAX_LENGTH = "d_dictionary.constraint.string_length.invalid_max_length";
    private static final String ERR_NON_STRING = "d_dictionary.constraint.string_length.non_string";
    private static final String ERR_INVALID_LENGTH = "d_dictionary.constraint.string_length.invalid_length";
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;

    @Override
    public String getType() {
        return "LENGTH";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("StringLengthConstraint").append("[ minLength=").append(this.minLength).append(", maxLength=").append(this.maxLength).append("]");
        return sb.toString();
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        if (minLength > this.maxLength || minLength < 0) {
            throw new DictionaryException(ERR_INVALID_MIN_LENGTH, minLength);
        }
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < this.minLength) {
            throw new DictionaryException(ERR_INVALID_MAX_LENGTH, maxLength);
        }
        this.maxLength = maxLength;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("minLength", this.minLength);
        params.put("maxLength", this.maxLength);
        return params;
    }

    @Override
    protected void evaluateSingleValue(Object value) {
        Object checkValue = null;
        try {
            checkValue = DefaultTypeConverter.INSTANCE.convert(String.class, value);
        }
        catch (TypeConversionException e) {
            throw new ConstraintException(ERR_NON_STRING, value);
        }
        int length = ((String)checkValue).length();
        if (length > this.maxLength || length < this.minLength) {
            if (length > 20) {
                checkValue = ((String)checkValue).substring(0, 17) + "...";
            }
            throw new ConstraintException(ERR_INVALID_LENGTH, checkValue, this.minLength, this.maxLength);
        }
    }
}

