/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Collection;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.xerces.util.XMLChar;

@AlfrescoPublicApi
public class ISO9075 {
    private static final int MASK = 15;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ISO9075() {
    }

    private static boolean isSQLNameStart(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '_' == c;
    }

    private static boolean isSQLName(char c) {
        if (ISO9075.isSQLNameStart(c)) {
            return true;
        }
        if ('0' <= c && c <= '9') {
            return true;
        }
        if (':' == c) {
            return true;
        }
        if ('$' == c) {
            return true;
        }
        return '#' == c;
    }

    public static String encodeSQL(String toEncode) {
        if (toEncode == null || toEncode.length() == 0) {
            return toEncode;
        }
        StringBuilder builder = new StringBuilder(toEncode.length());
        for (int i = 0; i < toEncode.length(); ++i) {
            char c = toEncode.charAt(i);
            if (i == 0) {
                if (ISO9075.isSQLNameStart(c)) {
                    if (ISO9075.matchesEncodedPattern(toEncode, i)) {
                        ISO9075.encode('_', builder);
                        continue;
                    }
                    builder.append(c);
                    continue;
                }
                ISO9075.encode(c, builder);
                continue;
            }
            if (!ISO9075.isSQLName(c)) {
                ISO9075.encode(c, builder);
                continue;
            }
            if (ISO9075.matchesEncodedPattern(toEncode, i)) {
                ISO9075.encode('_', builder);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String encode(String toEncode) {
        if (toEncode == null || toEncode.length() == 0) {
            return toEncode;
        }
        if (XMLChar.isValidName((String)toEncode) && toEncode.indexOf("_x") == -1 && toEncode.indexOf(58) == -1) {
            return toEncode;
        }
        StringBuilder builder = new StringBuilder(toEncode.length());
        for (int i = 0; i < toEncode.length(); ++i) {
            char c = toEncode.charAt(i);
            if (i == 0) {
                if (XMLChar.isNCNameStart((int)c)) {
                    if (ISO9075.matchesEncodedPattern(toEncode, i)) {
                        ISO9075.encode('_', builder);
                        continue;
                    }
                    builder.append(c);
                    continue;
                }
                ISO9075.encode(c, builder);
                continue;
            }
            if (!XMLChar.isNCName((int)c)) {
                ISO9075.encode(c, builder);
                continue;
            }
            if (ISO9075.matchesEncodedPattern(toEncode, i)) {
                ISO9075.encode('_', builder);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean matchesEncodedPattern(String string, int position) {
        return string.length() > position + 6 && string.charAt(position) == '_' && string.charAt(position + 1) == 'x' && ISO9075.isHexChar(string.charAt(position + 2)) && ISO9075.isHexChar(string.charAt(position + 3)) && ISO9075.isHexChar(string.charAt(position + 4)) && ISO9075.isHexChar(string.charAt(position + 5)) && string.charAt(position + 6) == '_';
    }

    private static boolean isHexChar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static String decode(String toDecode) {
        if (toDecode == null || toDecode.length() < 7 || toDecode.indexOf("_x") < 0) {
            return toDecode;
        }
        StringBuffer decoded = new StringBuffer();
        int l = toDecode.length();
        for (int i = 0; i < l; ++i) {
            if (ISO9075.matchesEncodedPattern(toDecode, i)) {
                decoded.append((char)Integer.parseInt(toDecode.substring(i + 2, i + 6), 16));
                i += 6;
                continue;
            }
            decoded.append(toDecode.charAt(i));
        }
        return decoded.toString();
    }

    private static void encode(char c, StringBuilder builder) {
        char[] buf = new char[]{'_', 'x', '0', '0', '0', '0', '_'};
        int charPos = 6;
        do {
            buf[--charPos] = DIGITS[c & 0xF];
        } while ((c = (char)(c >>> 4)) != '\u0000');
        builder.append(buf);
    }

    public static String getXPathName(QName qName, NamespacePrefixResolver nspr) {
        Collection<String> prefixes = nspr.getPrefixes(qName.getNamespaceURI());
        if (prefixes.size() == 0) {
            throw new NamespaceException("A namespace prefix is not registered for uri " + qName.getNamespaceURI());
        }
        String prefix = prefixes.iterator().next();
        if (prefix.equals("")) {
            return ISO9075.encode(qName.getLocalName());
        }
        return prefix + ":" + ISO9075.encode(qName.getLocalName());
    }

    public static String getXPathName(QName qName) {
        return "{" + qName.getNamespaceURI() + "}" + ISO9075.encode(qName.getLocalName());
    }

    public static QName parseXPathName(String str) {
        if (!str.startsWith("{")) {
            throw new IllegalArgumentException("Invalid xpath string " + str);
        }
        int idx = str.indexOf("}");
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid xpath string " + str);
        }
        String namespaceURI = str.substring(1, idx);
        String localName = str.substring(idx + 1);
        return QName.createQName(namespaceURI, localName);
    }

    public static Object lowerCaseEncodedSQL(String toLowerCaseEncoded) {
        String lowerCased = toLowerCaseEncoded.toLowerCase();
        StringBuilder builder = new StringBuilder(toLowerCaseEncoded.length());
        for (int i = 0; i < toLowerCaseEncoded.length(); ++i) {
            if (ISO9075.matchesEncodedPattern(toLowerCaseEncoded, i)) {
                for (int j = 0; j < 7; ++j) {
                    builder.append(lowerCased.charAt(i + j));
                }
                i += 6;
                continue;
            }
            builder.append(toLowerCaseEncoded.charAt(i));
        }
        return builder.toString();
    }
}

