/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.search;

import java.util.ArrayList;
import java.util.Locale;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.springframework.extensions.surf.util.I18NUtil;

public class CMISQueryOptions
extends QueryOptions {
    private CMISQueryMode queryMode = CMISQueryMode.CMS_STRICT;
    private CmisVersion cmisVersion = CmisVersion.CMIS_1_1;

    public static CMISQueryOptions create(SearchParameters searchParameters) {
        String sql = searchParameters.getQuery();
        CMISQueryOptions options = new CMISQueryOptions(sql, (StoreRef)((ArrayList)searchParameters.getStores()).get(0));
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setDefaultFTSConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND);
        options.setDefaultFTSFieldConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND);
        options.setSkipCount(searchParameters.getSkipCount());
        options.setMaxPermissionChecks(searchParameters.getMaxPermissionChecks());
        options.setMaxPermissionCheckTimeMillis(searchParameters.getMaxPermissionCheckTimeMillis());
        if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE) {
            options.setMaxItems(searchParameters.getLimit());
        } else {
            options.setMaxItems(searchParameters.getMaxItems());
        }
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setLocales(searchParameters.getLocales());
        options.setStores(searchParameters.getStores());
        options.setUseInMemorySort(searchParameters.getUseInMemorySort());
        options.setMaxRawResultSetSizeForInMemorySort(searchParameters.getMaxRawResultSetSizeForInMemorySort());
        options.setQueryParameterDefinitions(searchParameters.getQueryParameterDefinitions());
        options.setDefaultFieldName(searchParameters.getDefaultFieldName());
        options.setBulkFetchEnabled(searchParameters.isBulkFetchEnabled());
        options.setExcludeTenantFilter(searchParameters.getExcludeTenantFilter());
        options.setSinceTxId(searchParameters.getSinceTxId());
        for (String name : searchParameters.getQueryTemplates().keySet()) {
            String template = searchParameters.getQueryTemplates().get(name);
            options.addQueryTemplate(name, template);
        }
        return options;
    }

    public CMISQueryOptions(String query, StoreRef storeRef) {
        this(query, storeRef, I18NUtil.getLocale());
    }

    public CMISQueryOptions(String query, StoreRef storeRef, Locale locale) {
        super(query, storeRef, locale);
    }

    public CmisVersion getCmisVersion() {
        return this.cmisVersion;
    }

    public void setCmisVersion(CmisVersion cmisVersion) {
        this.cmisVersion = cmisVersion;
    }

    public CMISQueryMode getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(CMISQueryMode queryMode) {
        this.queryMode = queryMode;
    }

    @Override
    public SearchParameters getAsSearchParmeters() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setDefaultFieldName(this.getDefaultFieldName());
        searchParameters.setDefaultFTSFieldConnective(this.getDefaultFTSFieldConnective() == QueryOptions.Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setDefaultFTSOperator(this.getDefaultFTSConnective() == QueryOptions.Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setDefaultOperator(this.getDefaultFTSConnective() == QueryOptions.Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setLanguage("cmis-alfresco");
        if (this.getMaxItems() > 0) {
            searchParameters.setLimit(this.getMaxItems());
            searchParameters.setLimitBy(LimitBy.FINAL_SIZE);
            searchParameters.setMaxItems(this.getMaxItems());
        }
        searchParameters.setMaxPermissionChecks(this.getMaxPermissionChecks());
        searchParameters.setMaxPermissionCheckTimeMillis(this.getMaxPermissionCheckTimeMillis());
        searchParameters.setMlAnalaysisMode(this.getMlAnalaysisMode());
        searchParameters.setQuery(this.getQuery());
        searchParameters.setSkipCount(this.getSkipCount());
        for (Locale locale : this.getLocales()) {
            searchParameters.addLocale(locale);
        }
        for (QueryParameterDefinition queryParameterDefinition : this.getQueryParameterDefinitions()) {
            searchParameters.addQueryParameterDefinition(queryParameterDefinition);
        }
        for (StoreRef storeRef : this.getStores()) {
            searchParameters.addStore(storeRef);
        }
        searchParameters.setBulkFetchEnabled(this.isBulkFetchEnabled());
        searchParameters.setQueryConsistency(this.getQueryConsistency());
        searchParameters.setSinceTxId(this.getSinceTxId());
        for (String name : this.getQueryTemplates().keySet()) {
            String template = this.getQueryTemplates().get(name);
            searchParameters.addQueryTemplate(name, template);
        }
        return searchParameters;
    }

    public static enum CMISQueryMode {
        CMS_STRICT,
        CMS_WITH_ALFRESCO_EXTENSIONS;

    }
}

