/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2ConstraintDefinition;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2PropertyOverride;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

class M2PropertyDefinition
implements PropertyDefinition {
    private ClassDefinition classDef;
    private M2Property m2Property;
    private QName name;
    private QName propertyTypeName;
    private DataTypeDefinition dataType;
    private String analyserResourceBundleName;
    private List<ConstraintDefinition> constraintDefs = Collections.emptyList();
    private transient MessageLookup staticMessageLookup = new StaticMessageLookup();

    M2PropertyDefinition(ClassDefinition classDef, M2Property m2Property, NamespacePrefixResolver prefixResolver) {
        this.classDef = classDef;
        this.m2Property = m2Property;
        this.name = QName.createQName(m2Property.getName(), prefixResolver);
        this.propertyTypeName = QName.createQName(m2Property.getType(), prefixResolver);
    }

    M2PropertyDefinition(ClassDefinition classDef, PropertyDefinition propertyDef, M2PropertyOverride override, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        this.classDef = classDef;
        this.name = propertyDef.getName();
        this.dataType = propertyDef.getDataType();
        this.propertyTypeName = this.dataType.getName();
        this.m2Property = this.createOverriddenProperty(propertyDef, override, prefixResolver, modelConstraints);
    }

    void resolveDependencies(ModelQuery query, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        if (this.propertyTypeName == null) {
            throw new DictionaryException("d_dictionary.property.err.property_type_not_specified", this.name.toPrefixString());
        }
        this.dataType = query.getDataType(this.propertyTypeName);
        if (this.dataType == null) {
            throw new DictionaryException("d_dictionary.property.err.property_type_not_found", this.propertyTypeName.toPrefixString(), this.name.toPrefixString());
        }
        if (this.propertyTypeName.equals(DataTypeDefinition.CONTENT) && this.isMultiValued()) {
            throw new DictionaryException("d_dictionary.property.err.single_valued_content");
        }
        this.constraintDefs = M2PropertyDefinition.buildConstraints(this.m2Property.getConstraints(), this, prefixResolver, modelConstraints);
    }

    private static List<ConstraintDefinition> buildConstraints(List<M2Constraint> m2constraints, M2PropertyDefinition m2PropertyDef, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        ArrayList<ConstraintDefinition> constraints = new ArrayList<ConstraintDefinition>(5);
        HashMap<QName, M2ConstraintDefinition> constraintsByQName = new HashMap<QName, M2ConstraintDefinition>(7);
        for (M2Constraint constraint : m2constraints) {
            M2ConstraintDefinition def;
            QName qname;
            if (constraint.getName() == null) {
                StringBuilder builder = new StringBuilder();
                builder.append(m2PropertyDef.classDef.getModel().getName().getLocalName()).append("_");
                builder.append(m2PropertyDef.classDef.getName().getLocalName()).append("_");
                builder.append(m2PropertyDef.getName().getLocalName()).append("_");
                builder.append("anon_");
                builder.append(constraints.size());
                QName newName = QName.createQName(m2PropertyDef.classDef.getModel().getName().getNamespaceURI(), builder.toString());
                constraint.setName(newName.getPrefixedQName(prefixResolver).toPrefixString());
            }
            if (constraintsByQName.containsKey(qname = (def = new M2ConstraintDefinition(m2PropertyDef, constraint, prefixResolver)).getName())) {
                throw new DictionaryException.DuplicateDefinitionException("d_dictionary.property.err.duplicate_constraint_on_property", def.getName().toPrefixString(), m2PropertyDef.name.toPrefixString());
            }
            if (modelConstraints.containsKey(qname)) {
                throw new DictionaryException.DuplicateDefinitionException("d_dictionary.model.err.duplicate_constraint_on_model", def.getName().toPrefixString(), def.getModel().getName().toPrefixString());
            }
            constraintsByQName.put(qname, def);
            constraints.add(def);
            modelConstraints.put(qname, def);
        }
        return constraints;
    }

    private M2Property createOverriddenProperty(PropertyDefinition propertyDef, M2PropertyOverride override, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        M2Property property = new M2Property();
        property.setOverride(true);
        String defaultValue = override.getDefaultValue();
        property.setDefaultValue(defaultValue == null ? propertyDef.getDefaultValue() : defaultValue);
        Boolean isOverrideMandatory = override.isMandatory();
        Boolean isOverrideMandatoryEnforced = override.isMandatoryEnforced();
        if (isOverrideMandatory != null && propertyDef.isMandatory()) {
            if (!isOverrideMandatory.booleanValue()) {
                throw new DictionaryException("d_dictionary.property.err.cannot_relax_mandatory", propertyDef.getName().toPrefixString());
            }
            if (isOverrideMandatoryEnforced != null && !isOverrideMandatoryEnforced.booleanValue() && propertyDef.isMandatoryEnforced()) {
                throw new DictionaryException("d_dictionary.property.err.cannot_relax_mandatory_enforcement", propertyDef.getName().toPrefixString());
            }
        }
        property.setMandatory(isOverrideMandatory == null ? propertyDef.isMandatory() : isOverrideMandatory.booleanValue());
        property.setMandatoryEnforced(isOverrideMandatoryEnforced == null ? propertyDef.isMandatoryEnforced() : isOverrideMandatoryEnforced.booleanValue());
        List<M2Constraint> overrideConstraints = override.getConstraints();
        this.constraintDefs = overrideConstraints != null ? M2PropertyDefinition.buildConstraints(overrideConstraints, this, prefixResolver, modelConstraints) : propertyDef.getConstraints();
        property.setDescription(propertyDef.getDescription(null));
        property.setIndexed(propertyDef.isIndexed());
        property.setIndexedAtomically(propertyDef.isIndexedAtomically());
        property.setMultiValued(propertyDef.isMultiValued());
        property.setProtected(propertyDef.isProtected());
        property.setStoredInIndex(propertyDef.isStoredInIndex());
        property.setTitle(propertyDef.getTitle(null));
        property.setIndexTokenisationMode(propertyDef.getIndexTokenisationMode());
        return property;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name: " + String.valueOf(this.getName()) + "\n");
        sb.append("Title: " + this.getTitle(null) + "\n");
        sb.append("Description: " + this.getDescription(null) + "\n");
        sb.append("Default Value: " + this.getDefaultValue() + "\n");
        sb.append("DataType Name: " + String.valueOf(this.getDataType().getName()) + "\n");
        sb.append("ContainerClass Name: " + String.valueOf(this.getContainerClass().getName()) + "\n");
        sb.append("isMultiValued: " + this.isMultiValued() + "\n");
        sb.append("isMandatory: " + this.isMandatory() + "\n");
        sb.append("isMandatoryEnforced: " + this.isMandatoryEnforced() + "\n");
        sb.append("isProtected: " + this.isProtected() + "\n");
        sb.append("isIndexed: " + this.isIndexed() + "\n");
        sb.append("isStoredInIndex: " + this.isStoredInIndex() + "\n");
        sb.append("isIndexedAtomically: " + this.isIndexedAtomically() + "\n");
        sb.append("indexTokenisationMode: " + String.valueOf((Object)this.getIndexTokenisationMode()) + "\n");
        return sb.toString();
    }

    @Override
    public ModelDefinition getModel() {
        return this.classDef.getModel();
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.getTitle(this.staticMessageLookup);
    }

    @Override
    public String getTitle(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.classDef.getModel(), messageLookup, "property", this.name, "title");
        if (value == null) {
            value = this.m2Property.getTitle();
        }
        return value;
    }

    @Override
    public String getTitle(MessageLookup messageLookup, Locale locale) {
        String value = M2Label.getLabel(locale, this.classDef.getModel(), messageLookup, "property", this.name, "title");
        if (value == null) {
            value = this.m2Property.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.staticMessageLookup);
    }

    @Override
    public String getDescription(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.classDef.getModel(), messageLookup, "property", this.name, "description");
        if (value == null) {
            value = this.m2Property.getDescription();
        }
        return value;
    }

    @Override
    public String getDescription(MessageLookup messageLookup, Locale locale) {
        String value = M2Label.getLabel(locale, this.classDef.getModel(), messageLookup, "property", this.name, "description");
        if (value == null) {
            value = this.m2Property.getDescription();
        }
        return value;
    }

    @Override
    public String getDefaultValue() {
        return this.m2Property.getDefaultValue();
    }

    @Override
    public DataTypeDefinition getDataType() {
        return this.dataType;
    }

    @Override
    public ClassDefinition getContainerClass() {
        return this.classDef;
    }

    @Override
    public boolean isOverride() {
        return this.m2Property.isOverride();
    }

    @Override
    public boolean isMultiValued() {
        return this.m2Property.isMultiValued();
    }

    @Override
    public boolean isMandatory() {
        return this.m2Property.isMandatory();
    }

    @Override
    public boolean isMandatoryEnforced() {
        return this.m2Property.isMandatoryEnforced();
    }

    @Override
    public boolean isProtected() {
        return this.m2Property.isProtected();
    }

    @Override
    public boolean isIndexed() {
        if (this.m2Property.isIndexed() == null) {
            return true;
        }
        return this.m2Property.isIndexed();
    }

    @Override
    public boolean isStoredInIndex() {
        if (this.m2Property.isStoredInIndex() == null) {
            return false;
        }
        return this.m2Property.isStoredInIndex();
    }

    @Override
    public boolean isIndexedAtomically() {
        if (this.m2Property.isIndexedAtomically() == null) {
            return true;
        }
        return this.m2Property.isIndexedAtomically();
    }

    @Override
    public IndexTokenisationMode getIndexTokenisationMode() {
        if (this.m2Property.getIndexTokenisationMode() == null) {
            return IndexTokenisationMode.TRUE;
        }
        return this.m2Property.getIndexTokenisationMode();
    }

    @Override
    public Facetable getFacetable() {
        if (this.m2Property.isFacetable() == null) {
            return Facetable.UNSET;
        }
        if (this.m2Property.isFacetable().booleanValue()) {
            return Facetable.TRUE;
        }
        return Facetable.FALSE;
    }

    @Override
    public List<ConstraintDefinition> getConstraints() {
        return this.constraintDefs;
    }

    M2ModelDiff diffProperty(PropertyDefinition propDef) {
        M2ModelDiff modelDiff = null;
        boolean isUpdated = false;
        boolean isUpdatedIncrementally = false;
        if (this == propDef) {
            modelDiff = new M2ModelDiff(this.name, "PROPERTY", "unchanged");
            return modelDiff;
        }
        if (!this.name.equals(propDef.getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getTitle(null), (String)propDef.getTitle(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDescription(null), (String)propDef.getDescription(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDefaultValue(), (String)propDef.getDefaultValue(), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getDataType().getName(), (Object)propDef.getDataType().getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getContainerClass().getName(), (Object)propDef.getContainerClass().getName())) {
            isUpdated = true;
        }
        if (this.isMultiValued() != propDef.isMultiValued()) {
            isUpdated = true;
        }
        if (this.isMandatory() != propDef.isMandatory()) {
            if (this.isMandatory() && !propDef.isMandatory()) {
                isUpdatedIncrementally = true;
            } else {
                isUpdated = true;
            }
        }
        if (this.isMandatoryEnforced() != propDef.isMandatoryEnforced()) {
            if (this.isMandatoryEnforced() && !propDef.isMandatoryEnforced()) {
                isUpdatedIncrementally = true;
            } else {
                isUpdated = true;
            }
        }
        if (this.isProtected() != propDef.isProtected()) {
            if (this.isProtected() && !propDef.isProtected()) {
                isUpdatedIncrementally = true;
            } else {
                isUpdated = true;
            }
        }
        if (this.isIndexed() != propDef.isIndexed()) {
            isUpdated = true;
        }
        if (this.isStoredInIndex() != propDef.isStoredInIndex()) {
            isUpdatedIncrementally = true;
        }
        if (this.isIndexedAtomically() != propDef.isIndexedAtomically()) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getIndexTokenisationMode().toString(), (String)propDef.getIndexTokenisationMode().toString(), (boolean)false)) {
            isUpdated = true;
        }
        if (this.isOverride() != propDef.isOverride()) {
            isUpdated = true;
        }
        modelDiff = isUpdated ? new M2ModelDiff(this.name, "PROPERTY", "updated") : (isUpdatedIncrementally ? new M2ModelDiff(this.name, "PROPERTY", "updated_inc") : new M2ModelDiff(this.name, "PROPERTY", "unchanged"));
        return modelDiff;
    }

    static Collection<M2ModelDiff> diffPropertyLists(Collection<PropertyDefinition> previousProperties, Collection<PropertyDefinition> newProperties) {
        boolean found;
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        for (PropertyDefinition previousProperty : previousProperties) {
            found = false;
            for (PropertyDefinition newProperty : newProperties) {
                if (!newProperty.getName().equals(previousProperty.getName())) continue;
                modelDiffs.add(((M2PropertyDefinition)previousProperty).diffProperty(newProperty));
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(previousProperty.getName(), "PROPERTY", "deleted"));
        }
        for (PropertyDefinition newProperty : newProperties) {
            found = false;
            for (PropertyDefinition previousProperty : previousProperties) {
                if (!newProperty.getName().equals(previousProperty.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(newProperty.getName(), "PROPERTY", "created"));
        }
        return modelDiffs;
    }
}

