/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantContextHolder;
import org.alfresco.util.ParameterCheck;

public abstract class TenantUtil {
    public static final String SYSTEM_TENANT = "-system-";
    public static final String DEFAULT_TENANT = "-default-";

    public static <R> R runAsUserTenant(final TenantRunAsWork<R> runAsWork, String uid, final String tenantDomain) {
        return AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<R>(){

            @Override
            public R doWork() {
                return TenantUtil.runAsTenant(runAsWork, tenantDomain);
            }
        }, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runAsTenant(TenantRunAsWork<R> runAsWork, String tenantDomain) {
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        if (tenantDomain.indexOf("@") > 0) {
            throw new AlfrescoRuntimeException("Unexpected tenant domain: " + tenantDomain + " (should not contain '@')");
        }
        String currentTenantDomain = null;
        try {
            currentTenantDomain = TenantContextHolder.setTenantDomain(tenantDomain);
            R r = TenantUtil.runAsWork(runAsWork);
            return r;
        }
        finally {
            TenantContextHolder.setTenantDomain(currentTenantDomain);
        }
    }

    public static <R> R runAsDefaultTenant(TenantRunAsWork<R> runAsWork) {
        if (TenantUtil.getCurrentDomain().equals("")) {
            return TenantUtil.runAsWork(runAsWork);
        }
        return TenantUtil.runAsSystemTenant(runAsWork, "");
    }

    public static <R> R runAsSystemTenant(TenantRunAsWork<R> runAsWork, String tenantDomain) {
        return TenantUtil.runAsUserTenant(runAsWork, AuthenticationUtil.getSystemUserName(), tenantDomain);
    }

    private static <R> R runAsWork(TenantRunAsWork<R> runAsWork) {
        try {
            return runAsWork.doWork();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error encountered while performing TenantUtil.runAsWork: " + e.getMessage(), e);
        }
    }

    public static String getCurrentDomain() {
        String tenantDomain = TenantContextHolder.getTenantDomain();
        if (tenantDomain == null) {
            tenantDomain = "";
        }
        return tenantDomain;
    }

    public static boolean isCurrentDomainDefault() {
        return "".equals(TenantUtil.getCurrentDomain());
    }

    public static String getTenantDomain(String name) {
        int idx2;
        ParameterCheck.mandatory((String)"name", (Object)name);
        int idx1 = name.indexOf("@");
        if (idx1 == 0 && (idx2 = name.indexOf("@", 1)) != -1) {
            return name.substring(1, idx2);
        }
        return "";
    }

    public static boolean isDefaultTenantName(String name) {
        return "".equals(TenantUtil.getTenantDomain(name));
    }

    public static interface TenantRunAsWork<Result> {
        public Result doWork() throws Exception;
    }
}

