/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.NumericEncoder;

public class NumericEncodingTest
extends TestCase {
    public NumericEncodingTest() {
    }

    public NumericEncodingTest(String arg0) {
        super(arg0);
    }

    public void xtestAllIntegerEncodings() {
        String lastString = null;
        String nextString = null;
        for (long i = Integer.MIN_VALUE; i <= Integer.MAX_VALUE; ++i) {
            nextString = NumericEncoder.encode((int)((int)i));
            if (lastString != null) {
                NumericEncodingTest.assertFalse((lastString.compareTo(nextString) > 0 ? 1 : 0) != 0);
            }
            lastString = nextString;
        }
    }

    public void xtestAllFloatEncodings() {
        Float last = null;
        Float next = null;
        String lastString = null;
        String nextString = null;
        for (int sign = 1; sign >= 0; --sign) {
            int bitPattern;
            int mantissa;
            int exponent;
            if (sign == 0) {
                for (exponent = 0; exponent <= 255; ++exponent) {
                    for (mantissa = 0; mantissa <= 0x7FFFFF; ++mantissa) {
                        bitPattern = sign << 31 | exponent << 23 | mantissa;
                        next = Float.valueOf(Float.intBitsToFloat(bitPattern));
                        if (!next.equals(Float.valueOf(Float.NaN)) && last != null && last.compareTo(next) > 0) {
                            System.err.println(last + " > " + next);
                        }
                        if (!next.equals(Float.valueOf(Float.NaN))) {
                            nextString = NumericEncoder.encode((float)next.floatValue());
                            if (lastString != null && lastString.compareTo(nextString) > 0) {
                                System.err.println(lastString + " > " + nextString);
                            }
                            lastString = nextString;
                        }
                        last = next;
                    }
                }
                continue;
            }
            for (exponent = 255; exponent >= 0; --exponent) {
                for (mantissa = 0x7FFFFF; mantissa >= 0; --mantissa) {
                    bitPattern = sign << 31 | exponent << 23 | mantissa;
                    next = Float.valueOf(Float.intBitsToFloat(bitPattern));
                    if (!next.equals(Float.valueOf(Float.NaN)) && last != null && last.compareTo(next) > 0) {
                        System.err.println(last + " > " + next);
                    }
                    if (!next.equals(Float.valueOf(Float.NaN))) {
                        nextString = NumericEncoder.encode((float)next.floatValue());
                        if (lastString != null && lastString.compareTo(nextString) > 0) {
                            System.err.println(lastString + " > " + nextString);
                        }
                        lastString = nextString;
                    }
                    last = next;
                }
            }
        }
    }

    public void testIntegerEncoding() {
        NumericEncodingTest.assertEquals((String)"00000000", (String)NumericEncoder.encode((int)Integer.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"00000001", (String)NumericEncoder.encode((int)-2147483647));
        NumericEncodingTest.assertEquals((String)"7fffffff", (String)NumericEncoder.encode((int)-1));
        NumericEncodingTest.assertEquals((String)"80000000", (String)NumericEncoder.encode((int)0));
        NumericEncodingTest.assertEquals((String)"80000001", (String)NumericEncoder.encode((int)1));
        NumericEncodingTest.assertEquals((String)"fffffffe", (String)NumericEncoder.encode((int)0x7FFFFFFE));
        NumericEncodingTest.assertEquals((String)"ffffffff", (String)NumericEncoder.encode((int)Integer.MAX_VALUE));
    }

    public void testLongEncoding() {
        NumericEncodingTest.assertEquals((String)"0000000000000000", (String)NumericEncoder.encode((long)Long.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"0000000000000001", (String)NumericEncoder.encode((long)-9223372036854775807L));
        NumericEncodingTest.assertEquals((String)"7fffffffffffffff", (String)NumericEncoder.encode((long)-1L));
        NumericEncodingTest.assertEquals((String)"8000000000000000", (String)NumericEncoder.encode((long)0L));
        NumericEncodingTest.assertEquals((String)"8000000000000001", (String)NumericEncoder.encode((long)1L));
        NumericEncodingTest.assertEquals((String)"fffffffffffffffe", (String)NumericEncoder.encode((long)0x7FFFFFFFFFFFFFFEL));
        NumericEncodingTest.assertEquals((String)"ffffffffffffffff", (String)NumericEncoder.encode((long)Long.MAX_VALUE));
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)Long.MIN_VALUE)), (long)Long.MIN_VALUE);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)-9223372036854775807L)), (long)-9223372036854775807L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)-1L)), (long)-1L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)0L)), (long)0L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)1L)), (long)1L);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)0x7FFFFFFFFFFFFFFEL)), (long)0x7FFFFFFFFFFFFFFEL);
        NumericEncodingTest.assertEquals((long)NumericEncoder.decodeLong((String)NumericEncoder.encode((long)Long.MAX_VALUE)), (long)Long.MAX_VALUE);
    }

    public void testFloatEncoding() {
        NumericEncodingTest.assertEquals((String)"007fffff", (String)NumericEncoder.encode((float)Float.NEGATIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"00800000", (String)NumericEncoder.encode((float)-3.4028235E38f));
        NumericEncodingTest.assertEquals((String)"7ffffffe", (String)NumericEncoder.encode((float)-1.4E-45f));
        NumericEncodingTest.assertEquals((String)"7fffffff", (String)NumericEncoder.encode((float)-0.0f));
        NumericEncodingTest.assertEquals((String)"80000000", (String)NumericEncoder.encode((float)0.0f));
        NumericEncodingTest.assertEquals((String)"80000001", (String)NumericEncoder.encode((float)Float.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"ff7fffff", (String)NumericEncoder.encode((float)Float.MAX_VALUE));
        NumericEncodingTest.assertEquals((String)"ff800000", (String)NumericEncoder.encode((float)Float.POSITIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"ffc00000", (String)NumericEncoder.encode((float)Float.NaN));
    }

    public void testDoubleEncoding() {
        NumericEncodingTest.assertEquals((String)"000fffffffffffff", (String)NumericEncoder.encode((double)Double.NEGATIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"0010000000000000", (String)NumericEncoder.encode((double)-1.7976931348623157E308));
        NumericEncodingTest.assertEquals((String)"7ffffffffffffffe", (String)NumericEncoder.encode((double)-4.9E-324));
        NumericEncodingTest.assertEquals((String)"7fffffffffffffff", (String)NumericEncoder.encode((double)-0.0));
        NumericEncodingTest.assertEquals((String)"8000000000000000", (String)NumericEncoder.encode((double)0.0));
        NumericEncodingTest.assertEquals((String)"8000000000000001", (String)NumericEncoder.encode((double)Double.MIN_VALUE));
        NumericEncodingTest.assertEquals((String)"ffefffffffffffff", (String)NumericEncoder.encode((double)Double.MAX_VALUE));
        NumericEncodingTest.assertEquals((String)"fff0000000000000", (String)NumericEncoder.encode((double)Double.POSITIVE_INFINITY));
        NumericEncodingTest.assertEquals((String)"fff8000000000000", (String)NumericEncoder.encode((double)Double.NaN));
        NumericEncodingTest.assertTrue((NumericEncoder.encode((double)-0.9).compareTo(NumericEncoder.encode((double)0.88)) < 0 ? 1 : 0) != 0);
        NumericEncodingTest.assertTrue((NumericEncoder.encode((double)-0.9).compareTo(NumericEncoder.encode((double)0.91)) < 0 ? 1 : 0) != 0);
        NumericEncodingTest.assertTrue((NumericEncoder.encode((double)0.88).compareTo(NumericEncoder.encode((double)0.91)) < 0 ? 1 : 0) != 0);
    }
}

