/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

public class NumericEncoder {
    static int INTEGER_SIGN_MASK = Integer.MIN_VALUE;
    static long LONG_SIGN_MASK = Long.MIN_VALUE;
    static int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    static int FLOAT_EXPONENT_MASK = 2139095040;
    static int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    static long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    static long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    static long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int MASK = 15;

    private NumericEncoder() {
    }

    public static String encode(int intToEncode) {
        int replacement = intToEncode ^ INTEGER_SIGN_MASK;
        return NumericEncoder.encodeToHex(replacement);
    }

    public static String encode(long longToEncode) {
        long replacement = longToEncode ^ LONG_SIGN_MASK;
        return NumericEncoder.encodeToHex(replacement);
    }

    public static String encode(Long longToEncode) {
        if (longToEncode == null) {
            return NumericEncoder.encode(0L);
        }
        return NumericEncoder.encode((long)longToEncode);
    }

    public static long decodeLong(String hex) {
        return NumericEncoder.decodeFromHex(hex) ^ LONG_SIGN_MASK;
    }

    public static int decodeInt(String hex) {
        return NumericEncoder.decodeIntFromHex(hex) ^ INTEGER_SIGN_MASK;
    }

    public static String encode(float floatToEncode) {
        int bits = Float.floatToIntBits(floatToEncode);
        int sign = bits & FLOAT_SIGN_MASK;
        int exponent = bits & FLOAT_EXPONENT_MASK;
        int mantissa = bits & FLOAT_MANTISSA_MASK;
        if (sign != 0) {
            exponent ^= FLOAT_EXPONENT_MASK;
            mantissa ^= FLOAT_MANTISSA_MASK;
        }
        int replacement = (sign ^= FLOAT_SIGN_MASK) | exponent | mantissa;
        return NumericEncoder.encodeToHex(replacement);
    }

    public static String encode(double doubleToEncode) {
        long bits = Double.doubleToLongBits(doubleToEncode);
        long sign = bits & DOUBLE_SIGN_MASK;
        long exponent = bits & DOUBLE_EXPONENT_MASK;
        long mantissa = bits & DOUBLE_MANTISSA_MASK;
        if (sign != 0L) {
            exponent ^= DOUBLE_EXPONENT_MASK;
            mantissa ^= DOUBLE_MANTISSA_MASK;
        }
        long replacement = (sign ^= DOUBLE_SIGN_MASK) | exponent | mantissa;
        return NumericEncoder.encodeToHex(replacement);
    }

    private static String encodeToHex(int i) {
        char[] buf = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        int charPos = 8;
        do {
            buf[--charPos] = DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0);
        return new String(buf);
    }

    private static String encodeToHex(long l) {
        char[] buf = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        int charPos = 16;
        do {
            buf[--charPos] = DIGITS[(int)l & 0xF];
        } while ((l >>>= 4) != 0L);
        return new String(buf);
    }

    private static long decodeFromHex(String hex) {
        long l = 0L;
        long factor = 1L;
        int i = 15;
        while (i >= 0) {
            int digit = Character.digit(hex.charAt(i), 16);
            l += (long)digit * factor;
            --i;
            factor <<= 4;
        }
        return l;
    }

    private static int decodeIntFromHex(String hex) {
        int l = 0;
        int factor = 1;
        int i = 7;
        while (i >= 0) {
            int digit = Character.digit(hex.charAt(i), 16);
            l += digit * factor;
            --i;
            factor <<= 4;
        }
        return l;
    }
}

