/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSPrefixTerm;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;

public class LuceneFTSPrefixTerm<Q, S, E extends Throwable>
extends FTSPrefixTerm
implements LuceneQueryBuilderComponent<Q, S, E> {
    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        Q query;
        QueryParserAdaptor<Q, S, E> lqpa = luceneContext.getLuceneQueryParserAdaptor();
        Argument argument = functionArgs.get("Term");
        String term = (String)((Object)argument.getValue(functionContext));
        term = term.substring(0, term.length() - 1);
        argument = functionArgs.get("TokenisationMode");
        AnalysisMode mode = (AnalysisMode)((Object)argument.getValue(functionContext));
        PropertyArgument propArg = (PropertyArgument)functionArgs.get("Property");
        if (propArg != null) {
            String prop = propArg.getPropertyName();
            query = lqpa.getPrefixQuery(functionContext.getLuceneFieldName(prop), term, mode);
        } else {
            query = lqpa.getPrefixQuery(lqpa.getField(), term, mode);
        }
        return query;
    }
}

