/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.dictionary.AbstractDictionaryRegistry;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.DictionaryRegistry;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.QName;

public class TenantDictionaryRegistryImpl
extends AbstractDictionaryRegistry {
    private String tenantDomain;

    public TenantDictionaryRegistryImpl(DictionaryDAO dictionaryDAO, String tenantDomain) {
        super(dictionaryDAO);
        this.tenantDomain = tenantDomain;
    }

    @Override
    public String getTenantDomain() {
        return this.tenantDomain;
    }

    private DictionaryRegistry getParent() {
        return this.dictionaryDAO.getDictionaryRegistry("");
    }

    @Override
    public QName putModelImpl(CompiledModel model) {
        if (this.getParent().modelExists(model.getModelDefinition().getName())) {
            throw new IllegalArgumentException("Cannot change core model: " + String.valueOf(model));
        }
        QName ret = super.putModelImpl(model);
        return ret;
    }

    @Override
    public Map<QName, CompiledModel> getCompiledModels(boolean includeInherited) {
        HashMap<QName, CompiledModel> ret = new HashMap<QName, CompiledModel>();
        ret.putAll(super.getCompiledModels(includeInherited));
        if (includeInherited) {
            ret.putAll(this.getParent().getCompiledModels(includeInherited));
        }
        return ret;
    }

    @Override
    public List<CompiledModel> getModelsForUri(String uri) {
        LinkedList<CompiledModel> models = new LinkedList<CompiledModel>();
        List<CompiledModel> parentModels = this.getParent().getModelsForUri(uri);
        models.addAll(parentModels);
        models.addAll(this.getModelsForUriImpl(uri));
        return models;
    }

    @Override
    public CompiledModel getModel(QName name) {
        CompiledModel model = this.getModelImpl(name);
        if (model == null) {
            model = this.getParent().getModel(name);
        }
        return model;
    }

    @Override
    public void removeModel(QName modelName) {
        CompiledModel model = this.removeModelImpl(modelName);
        if (model == null) {
            this.getParent().removeModel(modelName);
        }
    }

    @Override
    public AspectDefinition getAspect(QName aspectName) {
        AspectDefinition aspect = this.getAspectImpl(aspectName);
        if (aspect == null) {
            aspect = this.getParent().getAspect(aspectName);
        }
        return aspect;
    }

    @Override
    public boolean isModelInherited(QName modelName) {
        return this.getParent().getModel(modelName) != null;
    }

    @Override
    public Map<String, String> getPrefixesCache() {
        HashMap<String, String> prefixesCache = new HashMap<String, String>();
        Map<String, String> parentPrefixes = this.getParent().getPrefixesCache();
        prefixesCache.putAll(parentPrefixes);
        prefixesCache.putAll(this.getPrefixesCacheImpl());
        return prefixesCache;
    }

    @Override
    public List<String> getUrisCache() {
        LinkedList<String> urisCache = new LinkedList<String>();
        List<String> parentUris = this.getParent().getUrisCache();
        urisCache.addAll(parentUris);
        urisCache.addAll(this.getUrisCacheImpl());
        return urisCache;
    }

    @Override
    public Collection<String> getPrefixes(String URI) {
        Collection<String> prefixes = this.getParent().getPrefixes(URI);
        prefixes.addAll(this.getPrefixesImpl(URI));
        return prefixes;
    }

    @Override
    public void addURI(String uri) {
        if (this.getParent().hasURI(uri)) {
            throw new NamespaceException("URI " + uri + " has already been defined");
        }
        this.addURIImpl(uri);
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        if (this.getParent().hasPrefix(prefix)) {
            throw new NamespaceException("Prefix " + prefix + " has already been defined");
        }
        this.addPrefixImpl(prefix, uri);
    }

    @Override
    public void removeURI(String uri) {
        if (!this.removeURIImpl(uri)) {
            this.getParent().removeURI(uri);
        }
    }

    @Override
    public void removePrefix(String prefix) {
        if (!this.removePrefixImpl(prefix)) {
            this.getParent().removePrefix(prefix);
        }
    }

    @Override
    protected void initImpl() {
        long startTime = System.currentTimeMillis();
        for (DictionaryListener dictionaryDeployer : this.dictionaryDAO.getDictionaryListeners()) {
            dictionaryDeployer.onDictionaryInit();
        }
        if (logger.isInfoEnabled()) {
            Map<QName, CompiledModel> models = this.getCompiledModels(false);
            logger.info((Object)("Init Tenant Dictionary: model count = " + (models != null ? models.size() : 0) + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + String.valueOf(Thread.currentThread()) + "]"));
        }
    }

    @Override
    public TypeDefinition getType(QName typeName) {
        TypeDefinition type = this.getTypeImpl(typeName);
        if (type == null) {
            type = this.getParent().getType(typeName);
        }
        return type;
    }

    @Override
    public void removeImpl() {
        for (DictionaryListener listener : this.dictionaryDAO.getDictionaryListeners()) {
            listener.afterDictionaryDestroy();
        }
    }
}

