/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository.datatype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.VersionNumber;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.util.I18NUtil;

@AlfrescoPublicApi
public class DefaultTypeConverter
extends TypeConverter {
    public static TypeConverter INSTANCE = new DefaultTypeConverter();

    private DefaultTypeConverter() {
        this.addConverter(String.class, Class.class, new TypeConverter.Converter<String, Class>(){

            @Override
            public Class convert(String source) {
                try {
                    return Class.forName(source);
                }
                catch (ClassNotFoundException e) {
                    throw new TypeConversionException("Failed to convert string to class: " + source, e);
                }
            }
        });
        this.addConverter(String.class, Boolean.class, new TypeConverter.Converter<String, Boolean>(){

            @Override
            public Boolean convert(String source) {
                return Boolean.valueOf(source);
            }
        });
        this.addConverter(String.class, Character.class, new TypeConverter.Converter<String, Character>(){

            @Override
            public Character convert(String source) {
                if (source == null || source.length() == 0) {
                    return null;
                }
                return Character.valueOf(source.charAt(0));
            }
        });
        this.addConverter(String.class, Number.class, new TypeConverter.Converter<String, Number>(){

            @Override
            public Number convert(String source) {
                try {
                    return DecimalFormat.getNumberInstance().parse(source);
                }
                catch (ParseException e) {
                    throw new TypeConversionException("Failed to parse number " + source, e);
                }
            }
        });
        this.addConverter(String.class, Byte.class, new TypeConverter.Converter<String, Byte>(){

            @Override
            public Byte convert(String source) {
                return Byte.valueOf(source);
            }
        });
        this.addConverter(String.class, Short.class, new TypeConverter.Converter<String, Short>(){

            @Override
            public Short convert(String source) {
                return Short.valueOf(source);
            }
        });
        this.addConverter(String.class, Integer.class, new TypeConverter.Converter<String, Integer>(){

            @Override
            public Integer convert(String source) {
                return Integer.valueOf(source);
            }
        });
        this.addConverter(String.class, Long.class, new TypeConverter.Converter<String, Long>(){

            @Override
            public Long convert(String source) {
                return Long.valueOf(source);
            }
        });
        this.addConverter(String.class, Float.class, new TypeConverter.Converter<String, Float>(){

            @Override
            public Float convert(String source) {
                return Float.valueOf(source);
            }
        });
        this.addConverter(String.class, Double.class, new TypeConverter.Converter<String, Double>(){

            @Override
            public Double convert(String source) {
                return Double.valueOf(source);
            }
        });
        this.addConverter(String.class, BigInteger.class, new TypeConverter.Converter<String, BigInteger>(){

            @Override
            public BigInteger convert(String source) {
                return new BigInteger(source);
            }
        });
        this.addConverter(String.class, BigDecimal.class, new TypeConverter.Converter<String, BigDecimal>(){

            @Override
            public BigDecimal convert(String source) {
                return new BigDecimal(source);
            }
        });
        this.addConverter(String.class, Date.class, new TypeConverter.Converter<String, Date>(){

            @Override
            public Date convert(String source) {
                try {
                    Date date = ISO8601DateFormat.parse((String)source);
                    return date;
                }
                catch (PlatformRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + source + " to string", e);
                }
                catch (AlfrescoRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + source + " to string", e);
                }
            }
        });
        this.addConverter(String.class, Duration.class, new TypeConverter.Converter<String, Duration>(){

            @Override
            public Duration convert(String source) {
                return new Duration(source);
            }
        });
        this.addConverter(String.class, QName.class, new TypeConverter.Converter<String, QName>(){

            @Override
            public QName convert(String source) {
                return QName.createQName(source);
            }
        });
        this.addConverter(String.class, ContentData.class, new TypeConverter.Converter<String, ContentData>(){

            @Override
            public ContentData convert(String source) {
                return ContentData.createContentProperty(source);
            }
        });
        this.addConverter(String.class, NodeRef.class, new TypeConverter.Converter<String, NodeRef>(){

            @Override
            public NodeRef convert(String source) {
                return new NodeRef(source);
            }
        });
        this.addConverter(String.class, StoreRef.class, new TypeConverter.Converter<String, StoreRef>(){

            @Override
            public StoreRef convert(String source) {
                return new StoreRef(source);
            }
        });
        this.addConverter(String.class, ChildAssociationRef.class, new TypeConverter.Converter<String, ChildAssociationRef>(){

            @Override
            public ChildAssociationRef convert(String source) {
                return new ChildAssociationRef(source);
            }
        });
        this.addConverter(String.class, AssociationRef.class, new TypeConverter.Converter<String, AssociationRef>(){

            @Override
            public AssociationRef convert(String source) {
                return new AssociationRef(source);
            }
        });
        this.addConverter(String.class, InputStream.class, new TypeConverter.Converter<String, InputStream>(){

            @Override
            public InputStream convert(String source) {
                try {
                    return new ByteArrayInputStream(source.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TypeConversionException("Encoding not supported", e);
                }
            }
        });
        this.addConverter(String.class, MLText.class, new TypeConverter.Converter<String, MLText>(){

            @Override
            public MLText convert(String source) {
                return new MLText(source);
            }
        });
        this.addConverter(String.class, Locale.class, new TypeConverter.Converter<String, Locale>(){

            @Override
            public Locale convert(String source) {
                return I18NUtil.parseLocale((String)source);
            }
        });
        this.addConverter(String.class, Period.class, new TypeConverter.Converter<String, Period>(){

            @Override
            public Period convert(String source) {
                return new Period(source);
            }
        });
        this.addConverter(Map.class, Period.class, new TypeConverter.Converter<Map, Period>(){

            @Override
            public Period convert(Map source) {
                return new Period(source);
            }
        });
        this.addConverter(String.class, VersionNumber.class, new TypeConverter.Converter<String, VersionNumber>(){

            @Override
            public VersionNumber convert(String source) {
                return new VersionNumber(source);
            }
        });
        this.addConverter(Locale.class, String.class, new TypeConverter.Converter<Locale, String>(){

            @Override
            public String convert(Locale source) {
                Object localeStr = source.toString();
                if (((String)localeStr).length() < 6) {
                    localeStr = (String)localeStr + "_";
                }
                return localeStr;
            }
        });
        this.addConverter(VersionNumber.class, String.class, new TypeConverter.Converter<VersionNumber, String>(){

            @Override
            public String convert(VersionNumber source) {
                return source.toString();
            }
        });
        this.addConverter(MLText.class, String.class, new TypeConverter.Converter<MLText, String>(){

            @Override
            public String convert(MLText source) {
                return source.getDefaultValue();
            }
        });
        this.addConverter(Enum.class, String.class, new TypeConverter.Converter<Enum, String>(){

            @Override
            public String convert(Enum source) {
                return source.toString();
            }
        });
        this.addConverter(Period.class, String.class, new TypeConverter.Converter<Period, String>(){

            @Override
            public String convert(Period source) {
                return source.toString();
            }
        });
        this.addConverter(Class.class, String.class, new TypeConverter.Converter<Class, String>(){

            @Override
            public String convert(Class source) {
                return source.getName();
            }
        });
        this.addConverter(Number.class, Boolean.class, new TypeConverter.Converter<Number, Boolean>(){

            @Override
            public Boolean convert(Number source) {
                return new Boolean(source.longValue() > 0L);
            }
        });
        this.addConverter(Number.class, Byte.class, new TypeConverter.Converter<Number, Byte>(){

            @Override
            public Byte convert(Number source) {
                return source.byteValue();
            }
        });
        this.addConverter(Number.class, Short.class, new TypeConverter.Converter<Number, Short>(){

            @Override
            public Short convert(Number source) {
                return source.shortValue();
            }
        });
        this.addConverter(Number.class, Integer.class, new TypeConverter.Converter<Number, Integer>(){

            @Override
            public Integer convert(Number source) {
                return source.intValue();
            }
        });
        this.addConverter(Number.class, Long.class, new TypeConverter.Converter<Number, Long>(){

            @Override
            public Long convert(Number source) {
                return source.longValue();
            }
        });
        this.addConverter(Number.class, Float.class, new TypeConverter.Converter<Number, Float>(){

            @Override
            public Float convert(Number source) {
                return Float.valueOf(source.floatValue());
            }
        });
        this.addConverter(Number.class, Double.class, new TypeConverter.Converter<Number, Double>(){

            @Override
            public Double convert(Number source) {
                return source.doubleValue();
            }
        });
        this.addConverter(Number.class, Date.class, new TypeConverter.Converter<Number, Date>(){

            @Override
            public Date convert(Number source) {
                return new Date(source.longValue());
            }
        });
        this.addConverter(Number.class, String.class, new TypeConverter.Converter<Number, String>(){

            @Override
            public String convert(Number source) {
                return source.toString();
            }
        });
        this.addConverter(Number.class, BigInteger.class, new TypeConverter.Converter<Number, BigInteger>(){

            @Override
            public BigInteger convert(Number source) {
                if (source instanceof BigDecimal) {
                    return ((BigDecimal)source).toBigInteger();
                }
                return BigInteger.valueOf(source.longValue());
            }
        });
        this.addConverter(Number.class, BigDecimal.class, new TypeConverter.Converter<Number, BigDecimal>(){

            @Override
            public BigDecimal convert(Number source) {
                if (source instanceof BigInteger) {
                    return new BigDecimal((BigInteger)source);
                }
                if (source instanceof Double) {
                    return BigDecimal.valueOf((Double)source);
                }
                if (source instanceof Float) {
                    Float val = (Float)source;
                    if (val.isInfinite()) {
                        return new BigDecimal(3.4028234663852886E38);
                    }
                    return BigDecimal.valueOf(((Float)source).floatValue());
                }
                return BigDecimal.valueOf(source.longValue());
            }
        });
        this.addDynamicTwoStageConverter(Number.class, String.class, InputStream.class);
        this.addConverter(Timestamp.class, Date.class, new TypeConverter.Converter<Timestamp, Date>(){

            @Override
            public Date convert(Timestamp source) {
                return new Date(source.getTime());
            }
        });
        this.addConverter(Date.class, Number.class, new TypeConverter.Converter<Date, Number>(){

            @Override
            public Number convert(Date source) {
                return source.getTime();
            }
        });
        this.addConverter(Date.class, String.class, new TypeConverter.Converter<Date, String>(){

            @Override
            public String convert(Date source) {
                try {
                    return ISO8601DateFormat.format((Date)source);
                }
                catch (PlatformRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + String.valueOf(source) + " to string", e);
                }
            }
        });
        this.addConverter(Date.class, Calendar.class, new TypeConverter.Converter<Date, Calendar>(){

            @Override
            public Calendar convert(Date source) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(source);
                return calendar;
            }
        });
        this.addConverter(Date.class, GregorianCalendar.class, new TypeConverter.Converter<Date, GregorianCalendar>(){

            @Override
            public GregorianCalendar convert(Date source) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(source);
                return calendar;
            }
        });
        this.addDynamicTwoStageConverter(Date.class, String.class, InputStream.class);
        final Long LONG_FALSE = new Long(0L);
        final Long LONG_TRUE = new Long(1L);
        this.addConverter(Boolean.class, Long.class, new TypeConverter.Converter<Boolean, Long>(){

            @Override
            public Long convert(Boolean source) {
                return source != false ? LONG_TRUE : LONG_FALSE;
            }
        });
        this.addConverter(Boolean.class, String.class, new TypeConverter.Converter<Boolean, String>(){

            @Override
            public String convert(Boolean source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Boolean.class, String.class, InputStream.class);
        this.addConverter(Character.class, String.class, new TypeConverter.Converter<Character, String>(){

            @Override
            public String convert(Character source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Character.class, String.class, InputStream.class);
        this.addConverter(Duration.class, String.class, new TypeConverter.Converter<Duration, String>(){

            @Override
            public String convert(Duration source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Duration.class, String.class, InputStream.class);
        this.addConverter(Byte.class, String.class, new TypeConverter.Converter<Byte, String>(){

            @Override
            public String convert(Byte source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Byte.class, String.class, InputStream.class);
        this.addConverter(Short.class, String.class, new TypeConverter.Converter<Short, String>(){

            @Override
            public String convert(Short source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Short.class, String.class, InputStream.class);
        this.addConverter(Integer.class, String.class, new TypeConverter.Converter<Integer, String>(){

            @Override
            public String convert(Integer source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Integer.class, String.class, InputStream.class);
        this.addConverter(Long.class, String.class, new TypeConverter.Converter<Long, String>(){

            @Override
            public String convert(Long source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Long.class, String.class, InputStream.class);
        this.addConverter(Float.class, String.class, new TypeConverter.Converter<Float, String>(){

            @Override
            public String convert(Float source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Float.class, String.class, InputStream.class);
        this.addConverter(Double.class, String.class, new TypeConverter.Converter<Double, String>(){

            @Override
            public String convert(Double source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Double.class, String.class, InputStream.class);
        this.addConverter(BigInteger.class, String.class, new TypeConverter.Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(BigInteger.class, String.class, InputStream.class);
        this.addConverter(Calendar.class, Date.class, new TypeConverter.Converter<Calendar, Date>(){

            @Override
            public Date convert(Calendar source) {
                return source.getTime();
            }
        });
        this.addConverter(Calendar.class, String.class, new TypeConverter.Converter<Calendar, String>(){

            @Override
            public String convert(Calendar source) {
                try {
                    return ISO8601DateFormat.format((Date)source.getTime());
                }
                catch (PlatformRuntimeException e) {
                    throw new TypeConversionException("Failed to convert date " + String.valueOf(source) + " to string", e);
                }
            }
        });
        this.addConverter(BigDecimal.class, String.class, new TypeConverter.Converter<BigDecimal, String>(){

            @Override
            public String convert(BigDecimal source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(BigDecimal.class, String.class, InputStream.class);
        this.addConverter(QName.class, String.class, new TypeConverter.Converter<QName, String>(){

            @Override
            public String convert(QName source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(QName.class, String.class, InputStream.class);
        this.addConverter(EntityRef.class, String.class, new TypeConverter.Converter<EntityRef, String>(){

            @Override
            public String convert(EntityRef source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(EntityRef.class, String.class, InputStream.class);
        this.addConverter(ContentData.class, String.class, new TypeConverter.Converter<ContentData, String>(){

            @Override
            public String convert(ContentData source) {
                return source.getInfoUrl();
            }
        });
        this.addDynamicTwoStageConverter(ContentData.class, String.class, InputStream.class);
        this.addConverter(Path.class, String.class, new TypeConverter.Converter<Path, String>(){

            @Override
            public String convert(Path source) {
                return source.toString();
            }
        });
        this.addDynamicTwoStageConverter(Path.class, String.class, InputStream.class);
        this.addConverter(ContentReader.class, InputStream.class, new TypeConverter.Converter<ContentReader, InputStream>(){

            @Override
            public InputStream convert(ContentReader source) {
                return source.getContentInputStream();
            }
        });
        this.addConverter(ContentReader.class, String.class, new TypeConverter.Converter<ContentReader, String>(){

            @Override
            public String convert(ContentReader source) {
                return source.toString();
            }
        });
        this.addConverter(ContentWriter.class, String.class, new TypeConverter.Converter<ContentWriter, String>(){

            @Override
            public String convert(ContentWriter source) {
                return source.toString();
            }
        });
        this.addConverter(InputStream.class, String.class, new TypeConverter.Converter<InputStream, String>(){

            @Override
            public String convert(InputStream source) {
                try {
                    int read;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((read = source.read(buffer)) > 0) {
                        out.write(buffer, 0, read);
                    }
                    byte[] data = out.toByteArray();
                    String string = new String(data, "UTF-8");
                    return string;
                }
                catch (UnsupportedEncodingException e) {
                    throw new TypeConversionException("Cannot convert input stream to String.", e);
                }
                catch (IOException e) {
                    throw new TypeConversionException("Conversion from stream to string failed", e);
                }
                finally {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
        this.addDynamicTwoStageConverter(InputStream.class, String.class, Date.class);
        this.addDynamicTwoStageConverter(InputStream.class, String.class, Double.class);
        this.addDynamicTwoStageConverter(InputStream.class, String.class, Long.class);
        this.addDynamicTwoStageConverter(InputStream.class, String.class, Boolean.class);
        this.addDynamicTwoStageConverter(InputStream.class, String.class, QName.class);
        this.addDynamicTwoStageConverter(InputStream.class, String.class, Path.class);
        this.addDynamicTwoStageConverter(InputStream.class, String.class, NodeRef.class);
        this.addConverter(SearchParameters.class, String.class, new TypeConverter.Converter<SearchParameters, String>(){

            @Override
            public String convert(SearchParameters source) {
                return source.toAuditString();
            }
        });
        this.addConverter(CMISQueryOptions.class, String.class, new TypeConverter.Converter<CMISQueryOptions, String>(){

            @Override
            public String convert(CMISQueryOptions source) {
                return source.getAsSearchParmeters().toAuditString();
            }
        });
    }
}

