/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.ArgumentDefinition;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.Multiplicity;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.StaticArgument;
import org.alfresco.repo.search.impl.querymodel.impl.BaseArgumentDefinition;
import org.alfresco.repo.search.impl.querymodel.impl.BaseFunction;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;

public abstract class BaseComparison
extends BaseFunction {
    public static final String ARG_LHS = "LHS";
    public static final String ARG_RHS = "RHS";
    public static final String ARG_MODE = "Mode";
    public static LinkedHashMap<String, ArgumentDefinition> ARGS = new LinkedHashMap();
    private PropertyArgument propertyArgument;
    private StaticArgument staticArgument;
    private FunctionArgument functionArgument;
    private String staticPosition;

    public BaseComparison(String name, QName returnType, LinkedHashMap<String, ArgumentDefinition> argumentDefinitions) {
        super(name, returnType, argumentDefinitions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyAndStaticArguments(Map<String, Argument> functionArgs) {
        Argument lhs = functionArgs.get(ARG_LHS);
        Argument rhs = functionArgs.get(ARG_RHS);
        if (lhs instanceof PropertyArgument) {
            if (rhs instanceof PropertyArgument || rhs instanceof FunctionArgument) {
                throw new QueryModelException("Implicit join is not supported");
            }
            if (!(rhs instanceof StaticArgument)) throw new QueryModelException("Argument of type " + rhs.getClass().getName() + " is not supported");
            this.propertyArgument = (PropertyArgument)lhs;
            this.staticArgument = (StaticArgument)rhs;
            this.staticPosition = ARG_RHS;
            return;
        } else if (lhs instanceof FunctionArgument) {
            if (rhs instanceof PropertyArgument || rhs instanceof FunctionArgument) {
                throw new QueryModelException("Implicit join is not supported");
            }
            if (!(rhs instanceof StaticArgument)) throw new QueryModelException("Argument of type " + rhs.getClass().getName() + " is not supported");
            this.functionArgument = (FunctionArgument)lhs;
            this.staticArgument = (StaticArgument)rhs;
            this.staticPosition = ARG_RHS;
            return;
        } else if (rhs instanceof PropertyArgument) {
            if (lhs instanceof PropertyArgument || lhs instanceof FunctionArgument) {
                throw new QueryModelException("Implicit join is not supported");
            }
            if (!(lhs instanceof StaticArgument)) throw new QueryModelException("Argument of type " + lhs.getClass().getName() + " is not supported");
            this.propertyArgument = (PropertyArgument)rhs;
            this.staticArgument = (StaticArgument)lhs;
            this.staticPosition = ARG_LHS;
            return;
        } else {
            if (!(rhs instanceof FunctionArgument)) throw new QueryModelException("Equals must have one property argument");
            if (lhs instanceof PropertyArgument || lhs instanceof FunctionArgument) {
                throw new QueryModelException("Implicit join is not supported");
            }
            if (!(lhs instanceof StaticArgument)) throw new QueryModelException("Argument of type " + lhs.getClass().getName() + " is not supported");
            this.functionArgument = (FunctionArgument)rhs;
            this.staticArgument = (StaticArgument)lhs;
            this.staticPosition = ARG_LHS;
        }
    }

    protected PropertyArgument getPropertyArgument() {
        return this.propertyArgument;
    }

    protected StaticArgument getStaticArgument() {
        return this.staticArgument;
    }

    public String getStaticPosition() {
        return this.staticPosition;
    }

    protected FunctionArgument getFunctionArgument() {
        return this.functionArgument;
    }

    public String getPropertyName() {
        if (this.propertyArgument != null) {
            return this.propertyArgument.getPropertyName();
        }
        if (this.functionArgument != null) {
            String functionName = this.functionArgument.getFunction().getName();
            if (functionName.equals("Upper")) {
                Argument arg = this.functionArgument.getFunctionArguments().get("Arg");
                if (arg instanceof PropertyArgument) {
                    return ((PropertyArgument)arg).getPropertyName();
                }
                throw new QueryModelException("Upper must have a column argument " + String.valueOf(arg));
            }
            if (functionName.equals("Lower")) {
                Argument arg = this.functionArgument.getFunctionArguments().get("Arg");
                if (arg instanceof PropertyArgument) {
                    return ((PropertyArgument)arg).getPropertyName();
                }
                throw new QueryModelException("Lower must have a column argument " + String.valueOf(arg));
            }
            throw new QueryModelException("Unsupported function: " + functionName);
        }
        throw new QueryModelException("A property of function argument must be provided");
    }

    static {
        ARGS.put(ARG_LHS, new BaseArgumentDefinition(Multiplicity.ANY, ARG_LHS, DataTypeDefinition.ANY, true));
        ARGS.put(ARG_RHS, new BaseArgumentDefinition(Multiplicity.ANY, ARG_RHS, DataTypeDefinition.ANY, true));
        ARGS.put(ARG_MODE, new BaseArgumentDefinition(Multiplicity.ANY, ARG_MODE, DataTypeDefinition.ANY, true));
    }
}

