/*
 * Decompiled with CFR 0.152.
 */
package org.safehaus.uuid.ext;

import java.io.File;
import java.io.IOException;
import org.safehaus.uuid.Logger;
import org.safehaus.uuid.TimestampSynchronizer;
import org.safehaus.uuid.ext.LockedFile;

public final class FileBasedTimestampSynchronizer
extends TimestampSynchronizer {
    static final long DEFAULT_UPDATE_INTERVAL = 10000L;
    static final String FILENAME1 = "uuid1.lck";
    static final String FILENAME2 = "uuid2.lck";
    long mInterval = 10000L;
    final LockedFile mLocked1;
    final LockedFile mLocked2;
    boolean mFirstActive = false;

    public FileBasedTimestampSynchronizer() throws IOException {
        this(new File(FILENAME1), new File(FILENAME2));
    }

    public FileBasedTimestampSynchronizer(File file, File file2) throws IOException {
        this(file, file2, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedTimestampSynchronizer(File file, File file2, long l) throws IOException {
        this.mInterval = l;
        this.mLocked1 = new LockedFile(file);
        boolean bl = false;
        try {
            this.mLocked2 = new LockedFile(file2);
            bl = true;
        }
        finally {
            if (!bl) {
                this.mLocked1.deactivate();
            }
        }
    }

    public void setUpdateInterval(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Illegal value (" + l + "); has to be a positive integer value");
        }
        this.mInterval = l;
    }

    protected long initialize() throws IOException {
        long l;
        long l2;
        long l3 = this.mLocked1.readStamp();
        if (l3 > (l2 = this.mLocked2.readStamp())) {
            this.mFirstActive = true;
            l = l3;
        } else {
            this.mFirstActive = false;
            l = l2;
        }
        if (l <= 0L) {
            Logger.logWarning("Could not determine safe timer starting point: assuming current system time is acceptable");
        } else {
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            if (l4 + this.mInterval < l) {
                Logger.logWarning("Safe timestamp read is " + (l - l4) + " milliseconds in future, and is greater than the inteval (" + this.mInterval + ")");
            }
        }
        return l;
    }

    public void deactivate() throws IOException {
        FileBasedTimestampSynchronizer.doDeactivate(this.mLocked1, this.mLocked2);
    }

    public long update(long l) throws IOException {
        long l2 = l + this.mInterval;
        if (this.mFirstActive) {
            this.mLocked2.writeStamp(l2);
        } else {
            this.mLocked1.writeStamp(l2);
        }
        this.mFirstActive = !this.mFirstActive;
        return l2;
    }

    protected static void doDeactivate(LockedFile lockedFile, LockedFile lockedFile2) {
        if (lockedFile != null) {
            lockedFile.deactivate();
        }
        if (lockedFile2 != null) {
            lockedFile2.deactivate();
        }
    }
}

