/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsArchiveEntries;
import de.schlichtherle.truezip.fs.FsArchiveEntry;
import de.schlichtherle.truezip.zip.DateTimeConverter;
import de.schlichtherle.truezip.zip.ZipEntry;

public class ZipDriverEntry
extends ZipEntry
implements FsArchiveEntry {
    public ZipDriverEntry(String name) {
        super(name);
    }

    protected ZipDriverEntry(String name, ZipEntry template) {
        super(name, template);
    }

    @Override
    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    protected DateTimeConverter getDateTimeConverter() {
        return DateTimeConverter.ZIP;
    }

    @Override
    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: {
                return this.getSize();
            }
            case STORAGE: {
                return this.getCompressedSize();
            }
        }
        return -1L;
    }

    @Override
    public boolean setSize(Entry.Size type, long size) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size);
        return true;
    }

    @Override
    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getTime();
        return 0L <= time ? time : -1L;
    }

    @Override
    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setTime(time);
        return true;
    }

    @Override
    public String toString() {
        return FsArchiveEntries.toString(this);
    }
}

