/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.transform.TransformManagerImpl;

public abstract class StreamHandler {
    protected TransformManagerImpl transformManager = new TransformManagerImpl();
    protected InputStream inputStream;
    protected OutputStream outputStream;

    public abstract void handleTransformRequest() throws Exception;

    protected void init() throws IOException {
        this.setInputStream();
        this.setOutputStream();
    }

    private void setInputStream() throws IOException {
        this.inputStream = this.transformManager.setInputStream(this.getInputStream());
    }

    protected void setOutputStream() throws IOException {
        this.outputStream = this.transformManager.setOutputStream(this.getOutputStream());
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    protected void handleTransform(CustomTransformer customTransformer) throws Exception {
        try {
            this.transform(customTransformer);
            this.handleSuccessfulTransform();
        }
        finally {
            this.closeOutputStream();
            this.closeInputStreamWithoutException();
            this.deleteTmpFiles();
        }
    }

    protected abstract void transform(CustomTransformer var1) throws Exception;

    protected void handleSuccessfulTransform() throws IOException {
        this.transformManager.copyTargetFileToOutputStream();
        this.onSuccessfulTransform();
    }

    protected void onSuccessfulTransform() {
    }

    protected void closeOutputStream() throws IOException {
        this.transformManager.getOutputStream().close();
    }

    private void closeInputStreamWithoutException() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteTmpFiles() {
        this.transformManager.deleteSourceFile();
        this.transformManager.deleteTargetFile();
    }
}

