/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import com.google.common.collect.ImmutableList;
import jakarta.jms.Destination;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithFragments;
import org.alfresco.transform.base.fakes.FakeTransformerFragments;
import org.alfresco.transform.base.messaging.TransformReplySender;
import org.alfresco.transform.base.model.FileRefEntity;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.base.sfs.SharedFileStoreClient;
import org.alfresco.transform.base.transform.StreamHandlerTest;
import org.alfresco.transform.base.transform.TransformHandler;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.webmvc.test.autoconfigure.AutoConfigureMockMvc;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@AutoConfigureMockMvc
@SpringBootTest(classes={Application.class})
@ContextConfiguration(classes={FakeTransformEngineWithFragments.class, FakeTransformerFragments.class})
public class FragmentHandlerTest {
    @Autowired
    private TransformHandler transformHandler;
    @Autowired
    private MockMvc mockMvc;
    @MockitoBean
    protected SharedFileStoreClient fakeSfsClient;
    @MockitoBean
    private TransformReplySender transformReplySender;
    @MockitoBean
    private ProbeTransform probeTransform;

    private void assertFragments(String sourceText, String expectedError, List<String> expectedLines) {
        ArrayList replies = new ArrayList();
        ArrayList lines = new ArrayList();
        String sourceReference = UUID.randomUUID().toString();
        String targetReference = UUID.randomUUID().toString();
        Mockito.when((Object)this.fakeSfsClient.retrieveFile((String)ArgumentMatchers.any())).thenReturn((Object)new ResponseEntity((Object)new ByteArrayResource(sourceText.getBytes(StandardCharsets.UTF_8)), new HttpHeaders(), (HttpStatusCode)HttpStatus.OK));
        Mockito.when((Object)this.fakeSfsClient.saveFile((File)ArgumentMatchers.any())).thenAnswer(invocation -> {
            lines.add(StreamHandlerTest.read((File)invocation.getArgument(0)));
            return new FileRefResponse(new FileRefEntity(targetReference));
        });
        ((TransformReplySender)Mockito.doAnswer(invocation -> {
            replies.add(Pair.of((Object)((Destination)invocation.getArgument(0)), (Object)((TransformReply)invocation.getArgument(1))));
            return null;
        }).when((Object)this.transformReplySender)).send((Destination)ArgumentMatchers.any(), (TransformReply)ArgumentMatchers.any());
        TransformRequest request = TransformRequest.builder().withRequestId(UUID.randomUUID().toString()).withSourceMediaType("application/pdf").withTargetMediaType("image/jpeg").withTargetExtension("jpeg").withSchema(1).withClientData("ACS").withSourceReference(sourceReference).withSourceSize(Long.valueOf(32L)).withInternalContextForTransformEngineTests().build();
        this.transformHandler.handleMessageRequest(request, Long.valueOf(Long.MAX_VALUE), null, this.probeTransform);
        TransformReply lastReply = (TransformReply)((Pair)replies.get(replies.size() - 1)).getRight();
        String errorDetails = lastReply.getErrorDetails();
        int status = lastReply.getStatus();
        if (expectedError == null) {
            Assertions.assertNull((Object)errorDetails);
            Assertions.assertEquals((int)HttpStatus.CREATED.value(), (int)status);
        } else {
            Assertions.assertEquals((Object)("Transform failed - " + expectedError), (Object)errorDetails);
            Assertions.assertEquals((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (int)status);
        }
        Assertions.assertEquals(expectedLines, lines);
    }

    @Test
    public void testErrorIfHttp() {
        String expectedError = "Fragments may only be sent via message queues. This an http request";
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> this.mockMvc.perform((RequestBuilder)((MockMultipartHttpServletRequestBuilder)((MockMultipartHttpServletRequestBuilder)MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(new MockMultipartFile("file", null, "text/plain", "Start".getBytes(StandardCharsets.UTF_8)))).param("sourceMimetype", new String[]{"application/pdf"})).param("targetMimetype", new String[]{"image/jpeg"})).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)expectedError))));
    }

    @Test
    public void testWithoutCallingRespondWithFragment() {
        this.assertFragments("WithoutFragments", null, (List<String>)ImmutableList.of((Object)"WithoutFragments"));
    }

    @Test
    public void testSingleRespondWithFragmentCall() {
        this.assertFragments("Finished", null, (List<String>)ImmutableList.of((Object)"Finished"));
    }

    @Test
    public void testMultipleFragmentCallsWithFinished() {
        this.assertFragments("line1\nline2\nFinished", null, (List<String>)ImmutableList.of((Object)"line1", (Object)"line2", (Object)"Finished"));
    }

    @Test
    public void testMultipleFragmentsCallsWithoutFinish() {
        this.assertFragments("line1\nline2\nline3", null, (List<String>)ImmutableList.of((Object)"line1", (Object)"line2", (Object)"line3"));
    }

    @Test
    public void testMultipleFragmentsCallsWithoutSendingLastFragment() {
        this.assertFragments("line1\nline2\nline3\nIgnored", null, (List<String>)ImmutableList.of((Object)"line1", (Object)"line2", (Object)"line3"));
    }

    @Test
    public void testNoFragments() {
        this.assertFragments("NullFinished", "No fragments were produced", (List<String>)ImmutableList.of());
    }

    @Test
    public void testEndTooEarlyUsingFinished() {
        this.assertFragments("line1\nFinished\nline3", "Final fragment already sent", (List<String>)ImmutableList.of((Object)"line1", (Object)"Finished"));
    }

    @Test
    public void testEndTooEarlyUsingNull() {
        this.assertFragments("line1\nNull\nline3", "Final fragment already sent", (List<String>)ImmutableList.of((Object)"line1"));
    }

    @Test
    public void testFinishedAndNull() {
        this.assertFragments("line1\nFinished\nNull", null, (List<String>)ImmutableList.of((Object)"line1", (Object)"Finished"));
    }

    @Test
    public void testNullAndNull() {
        this.assertFragments("line1\nNull\nNull", null, (List<String>)ImmutableList.of((Object)"line1"));
    }

    @Test
    public void testNullAndFinished() {
        this.assertFragments("line1\nNull\nFinished", "Final fragment already sent", (List<String>)ImmutableList.of((Object)"line1"));
    }
}

