/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.transform.base.Application;
import org.alfresco.transform.base.fakes.AbstractFakeTransformEngine;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithAllInOne;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithOneCustomTransformer;
import org.alfresco.transform.base.fakes.FakeTransformEngineWithTwoCustomTransformers;
import org.alfresco.transform.base.registry.TransformConfigFiles;
import org.alfresco.transform.base.registry.TransformConfigFilesHistoric;
import org.alfresco.transform.base.registry.TransformConfigFromFiles;
import org.alfresco.transform.base.registry.TransformConfigFromTransformEngines;
import org.alfresco.transform.base.registry.TransformConfigSource;
import org.alfresco.transform.base.registry.TransformRegistry;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.Transformer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.webmvc.test.autoconfigure.AutoConfigureMockMvc;
import org.springframework.test.util.ReflectionTestUtils;

@AutoConfigureMockMvc
@SpringBootTest(classes={Application.class})
public class TransformRegistryTest {
    @Autowired
    private TransformRegistry transformRegistry;
    @Autowired
    private List<TransformConfigSource> transformConfigSources;
    @Autowired
    private TransformConfigFromTransformEngines transformConfigFromTransformEngines;
    @Autowired
    private TransformConfigFromFiles transformConfigFromFiles;
    @Autowired
    private TransformConfigFiles transformConfigFiles;
    @Autowired
    private TransformConfigFilesHistoric transformConfigFilesHistoric;

    @AfterEach
    private void after() {
        this.transformConfigSources.clear();
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", Collections.emptyList());
        ReflectionTestUtils.setField((Object)this.transformConfigFiles, (String)"files", Collections.emptyMap());
        ReflectionTestUtils.setField((Object)this.transformConfigFilesHistoric, (String)"additional", Collections.emptyMap());
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"isTRouter", (Object)false);
        this.transformRegistry.retrieveConfig();
    }

    private String getTransformerNames(TransformConfig transformConfig) {
        return transformConfig.getTransformers().stream().map(Transformer::getTransformerName).sorted().collect(Collectors.joining(", "));
    }

    @Test
    public void noConfig() {
        Assertions.assertEquals((Object)"", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void singleTransformEngine() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithOneCustomTransformer()));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"Pdf2Jpg", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void multipleTransformEngines() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithAllInOne(), (Object)new FakeTransformEngineWithOneCustomTransformer(), (Object)new FakeTransformEngineWithTwoCustomTransformers()));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"Pdf2Jpg, Pdf2Png, TxT2Pdf, Txt2JpgViaPdf, Txt2PngViaPdf", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void uncombinedConfigFromEngine() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithAllInOne(), (Object)new FakeTransformEngineWithTwoCustomTransformers()));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"Pdf2Png, TxT2Pdf, Txt2JpgViaPdf, Txt2PngViaPdf", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"isTRouter", (Object)true);
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"Pdf2Png, TxT2Pdf, Txt2PngViaPdf", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void combinedConfigFromRouter() {
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"isTRouter", (Object)true);
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithAllInOne(), (Object)new FakeTransformEngineWithTwoCustomTransformers()));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"Pdf2Png, TxT2Pdf, Txt2PngViaPdf", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void singleTransformEngineWithAdditionalConfig() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithOneCustomTransformer()));
        ReflectionTestUtils.setField((Object)this.transformConfigFiles, (String)"files", (Object)ImmutableMap.of((Object)"a", (Object)"config/addA2B.json", (Object)"foo", (Object)"config/addB2C.json"));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformConfigFromFiles.initFileConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"A2B, B2C, Pdf2Jpg", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void singleTransformEngineWithHistoricAdditionalRoutes() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithOneCustomTransformer()));
        ReflectionTestUtils.setField((Object)this.transformConfigFilesHistoric, (String)"additional", (Object)ImmutableMap.of((Object)"a", (Object)"config/addA2B.json", (Object)"foo", (Object)"config/addB2C.json"));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformConfigFromFiles.initFileConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"A2B, B2C, Pdf2Jpg", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void singleTransformEngineWithHistoricTransformerRoutesExternalFile() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithOneCustomTransformer()));
        ReflectionTestUtils.setField((Object)this.transformConfigFilesHistoric, (String)"TRANSFORMER_ROUTES_FROM_CLASSPATH", (Object)"config/removePdf2JpgAndAddA2Z.json");
        ReflectionTestUtils.setField((Object)this.transformConfigFilesHistoric, (String)"transformerRoutesExternalFile", (Object)"config/addA2B.json");
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformConfigFromFiles.initFileConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"A2B, Pdf2Jpg", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void singleTransformEngineWithHistoricTransformerRoutesOnClasspath() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithOneCustomTransformer()));
        ReflectionTestUtils.setField((Object)this.transformConfigFilesHistoric, (String)"TRANSFORMER_ROUTES_FROM_CLASSPATH", (Object)"config/removePdf2JpgAndAddA2Z.json");
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformConfigFromFiles.initFileConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertEquals((Object)"A2Z", (Object)this.getTransformerNames(this.transformRegistry.getTransformConfig()));
    }

    @Test
    public void isReadyForTransformRequests() {
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertFalse((boolean)this.transformRegistry.isReadyForTransformRequests());
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new FakeTransformEngineWithOneCustomTransformer()));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertTrue((boolean)this.transformRegistry.isReadyForTransformRequests());
    }

    @Test
    public void testCheckSourceSize() {
        ReflectionTestUtils.setField((Object)this.transformConfigFromTransformEngines, (String)"transformEngines", (Object)ImmutableList.of((Object)new AbstractFakeTransformEngine(){

            public TransformConfig getTransformConfig() {
                return TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)Transformer.builder().withTransformerName("transformerName").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/msword")).withTargetMediaType("application/pdf")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/vnd.ms-excel")).withTargetMediaType("application/pdf")).withMaxSourceSizeBytes(Long.valueOf(12345L)).build()))).build())).build();
            }
        }));
        this.transformConfigFromTransformEngines.initTransformEngineConfig();
        this.transformRegistry.retrieveConfig();
        Assertions.assertTrue((boolean)this.transformRegistry.checkSourceSize("transformerName", "application/msword", Long.valueOf(Long.MAX_VALUE), "application/pdf"));
        Assertions.assertTrue((boolean)this.transformRegistry.checkSourceSize("transformerName", "application/vnd.ms-excel", Long.valueOf(12345L), "application/pdf"));
        Assertions.assertFalse((boolean)this.transformRegistry.checkSourceSize("transformerName", "application/vnd.ms-excel", Long.valueOf(12346L), "application/pdf"));
        Assertions.assertFalse((boolean)this.transformRegistry.checkSourceSize("transformerName", "doesNotExist", Long.valueOf(12345L), "application/pdf"));
        Assertions.assertFalse((boolean)this.transformRegistry.checkSourceSize("doesNotExist", "application/msword", Long.valueOf(12345L), "application/pdf"));
    }
}

