/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.messaging;

import jakarta.jms.Destination;
import org.alfresco.transform.client.model.TransformReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;

@Component
public class TransformReplySender {
    private static final Logger logger = LoggerFactory.getLogger(TransformReplySender.class);
    @Autowired
    private JmsTemplate jmsTemplate;

    public void send(Destination destination, TransformReply reply) {
        this.send(destination, reply, reply.getRequestId());
    }

    public void send(Destination destination, TransformReply reply, String correlationId) {
        if (destination != null) {
            try {
                this.jmsTemplate.convertAndSend(destination, (Object)reply, m -> {
                    m.setJMSCorrelationID(correlationId);
                    return m;
                });
                logger.trace("Sent: {} - with correlation ID {}", (Object)reply, (Object)correlationId);
            }
            catch (Exception e) {
                logger.error("Failed to send T-Reply " + String.valueOf(reply) + " - for correlation ID " + correlationId, (Throwable)e);
            }
        }
    }
}

