/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.clients;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.alfresco.transform.base.clients.JacksonSerializer;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;

public class JmsClient {
    private final ConnectionFactory factory;
    private final ActiveMQQueue queue;

    public JmsClient(String server, String queueName) {
        this.factory = new ActiveMQConnectionFactory(server);
        this.queue = new ActiveMQQueue(queueName);
    }

    public ActiveMQQueue getDestination() {
        return this.queue;
    }

    public void sendBytesMessage(TransformRequest request) throws Exception {
        this.sendBytesMessage(request, request.getRequestId());
    }

    public void sendBytesMessage(TransformRequest request, String correlationID) throws Exception {
        this.sendBytesMessage(JacksonSerializer.serialize(request), correlationID);
    }

    public void sendBytesMessage(TransformRequest request, String correlationID, Destination replyTo) throws Exception {
        this.sendBytesMessage(JacksonSerializer.serialize(request), correlationID, replyTo);
    }

    public void sendBytesMessage(byte[] data, String correlationID) throws Exception {
        try (Connection connection = this.factory.createConnection();
             Session session = connection.createSession(false, 1);
             MessageProducer producer = session.createProducer((Destination)this.queue);){
            producer.setDeliveryMode(2);
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(data);
            if (correlationID != null) {
                message.setJMSCorrelationID(correlationID);
            }
            producer.send((Message)message);
        }
    }

    public void sendBytesMessage(byte[] data, String correlationID, Destination replyTo) throws Exception {
        try (Connection connection = this.factory.createConnection();
             Session session = connection.createSession(false, 1);
             MessageProducer producer = session.createProducer((Destination)this.queue);){
            producer.setDeliveryMode(2);
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(data);
            if (correlationID != null) {
                message.setJMSCorrelationID(correlationID);
            }
            if (replyTo != null) {
                message.setJMSReplyTo(replyTo);
            }
            producer.send((Message)message);
        }
    }

    public void sendTextMessage(TransformRequest request) throws Exception {
        this.sendTextMessage(request, request.getRequestId());
    }

    public void sendTextMessage(TransformRequest request, String correlationID) throws Exception {
        this.sendTextMessage(new String(JacksonSerializer.serialize(request)), correlationID);
    }

    public void sendTextMessage(String data, String correlationID) throws Exception {
        try (Connection connection = this.factory.createConnection();
             Session session = connection.createSession(false, 1);
             MessageProducer producer = session.createProducer((Destination)this.queue);){
            producer.setDeliveryMode(2);
            TextMessage message = session.createTextMessage(data);
            if (correlationID != null) {
                message.setJMSCorrelationID(correlationID);
            }
            producer.send((Message)message);
        }
    }

    public TransformReply receiveMessage() throws Exception {
        return this.receiveMessage(120000L);
    }

    /*
     * Exception decompiling
     */
    public TransformReply receiveMessage(long timeout) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cleanQueue() {
        try {
            while (this.receiveMessage(2000L) != null) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

